//
// The HiRise Constraint Solver for Java, Ver. 2.0
//
// Copyright (C) 1998-1999 Hiroshi HOSOBE
//
////////////////////////////////////////////////////////////////

//package jp.ac.u_tokyo.s.is.hirise;

import java.util.*;

public final class Variable extends HiRiseObject {

	private double m_val;
	private Vector m_cons = new Vector(8, 8);

	public String toString()
	{
		String str = super.toString();
		String name = getName();
		if (name != null)
			str += ": " + name;
		return str + ": " + m_val;
	}

	public final String getName2()
	{
		String name = getName();
		if (name == null)
			name = "@" + Integer.toHexString(hashCode());
		return name;
	}

	private void init(double val)
	{
		m_val = val;
	}

	public Variable()
	{
		init(0);
	}

	public Variable(String name)
	{
		super(name);
		init(0);
	}

	public Variable(double val)
	{
		init(val);
	}
	
	public Variable(String name, double val)
	{
		super(name);
		init(val);
	}
	
 	public final void set(double val)
 	{
 		m_val = val;
 	}

 	public final double get()
 	{
 		return m_val;
 	}

	public final int countCons()
 	{
 		return m_cons.size();
 	}

	public final Constraint getCon(int i)
 	{
 		return (Constraint) m_cons.elementAt(i);
 	}

    public final int index(Constraint con)
 	{
 		return m_cons.indexOf(con);
 	}

    public final Variable add(Constraint con)
 	{
 		m_cons.addElement(con);

 		return this;
 	}

    public final Variable remove(Constraint con)
 	{
 		m_cons.removeElement(con);
		
 		return this;
 	}

}
