//
// The HiRise Constraint Solver for Java, Ver. 2.0
//
// Copyright (C) 1998-1999 Hiroshi HOSOBE
//
////////////////////////////////////////////////////////////////

//package jp.ac.u_tokyo.s.is.hirise;

import java.util.*;

public class Stay extends Constraint {

	public String toString()
	{
		String str = super.toString();
		if (countVars() > 0)
			str += ": stay(" + getVar(0).getName2() + ")";
		return str;
	}

	private void init()
	{
	}
	
	Stay(int str)
	{
		super(str);
		init();
	}

	Stay(String name, int str)
	{
		super(name, str);
		init();
	}

	Stay(int str, Variable var)
	{
		super(str);
		init();
		add(var);
	}

	Stay(String name, int str, Variable var)
	{
		super(name, str);
		init();
		add(var);
	}

	public Constraint add(Variable var)
	{
		if (countVars() > 0) 
			throw new IllegalArgumentException("variable already added");

		super.add(var);

		return this;
	}

}
