//
// A Sample Program for the HiRise Constraint Solver
//
// Copyright (C) 1998-1999 Hiroshi HOSOBE
//
////////////////////////////////////////////////////////////////

import java.util.*;

public class Sample extends Object {

	private static void sample1()
	{
		System.out.println("sample 1");

		Solver solver = new Solver();	// the HiRise constaint solver

		Variable x = new Variable(1);	// variable x with initial value 1
		Variable y = new Variable();	// variable y
		Variable z = new Variable();	// variable z

		Stay stay = new Stay(0, x);		// stay on x with strength 0  
		solver.add(stay);				// add stay

		Edit edit = new Edit(1, y);		// edit on y with strength 1
		solver.add(edit);				// add edit

		Linear linear = new Linear(2);	// linear with strength 2
		linear.add(x, 1);				// x
		linear.add(y, 2);				// + 2 * y
		linear.add(z, -1);				// - 1 * z
		linear.setConst(3);				// = 3
		solver.add(linear);				// add linear

		solver.plan();					// plan

		edit.set(2);					// let edit assign 2 to y
		solver.execute();				// execute
		System.out.println("x = " + x.get() + ", y = " + y.get()
						   + ", z = " + z.get()); // print result

		edit.set(3);					// let edit assign 3 to y
		solver.execute();				// execute
		System.out.println("x = " + x.get() + ", y = " + y.get()
						   + ", z = " + z.get()); // print result
	
		solver.remove(stay);			// remove stay
		solver.remove(edit);			// remove edit
		solver.remove(linear);			// remove linear
	}

	private static void sample2()
	{
		System.out.println("sample 2");

		Solver solver = new Solver();

		Variable x = new Variable();
		Variable y = new Variable();

		ConstraintSet medium = new ConstraintSet(ConstraintSet.CONJUNCTIVE);

		// x = 1 (str 1)
		Linear medium_x = new Linear(1);
		medium_x.add(x, 1);
		medium_x.setConst(1);
		medium.add(medium_x);

		// y = 1 (str 1)
		Linear medium_y = new Linear(1);
		medium_y.add(y, 1);
		medium_y.setConst(1);
		medium.add(medium_y);

		solver.add(medium);
		
		// y = 2 (str 2)
		Linear weak = new Linear(2);
		weak.add(y, 1);
		weak.setConst(2);
		solver.add(weak);

		solver.plan();
		solver.execute();

		System.out.println("x = " + x.get() + ", y = " + y.get());

		// x = 0 (str 0)
		Linear strong = new Linear(0);
		strong.add(x, 1);
		strong.setConst(0);
		solver.add(strong);

		solver.plan();
		solver.execute();

		System.out.println("x = " + x.get() + ", y = " + y.get());
	}

	private static void sample3()
	{
		System.out.println("sample 3");

		Solver solver = new Solver();

		Variable x = new Variable();
		Variable y = new Variable();

		ConstraintSet set = new ConstraintSet(ConstraintSet.OPTIMIZING);

		// x = 1 (str 1)
		Linear set_x = new Linear(1);
		set_x.add(x, 1);
		set_x.setConst(1);
		set.add(set_x);

		// y = 1 (str 1)
		Linear set_y = new Linear(1);
		set_y.add(y, 1);
		set_y.setConst(1);
		set.add(set_y);

		solver.add(set);

		// 2 * y - x = 0 (str 0)
		Linear linear = new Linear(0);
		linear.add(y, 2);
		linear.add(x, -1);
		solver.add(linear);

		// x = 1 will be satisfied
		solver.plan();
		solver.execute();

		System.out.println("x = " + x.get() + ", y = " + y.get());

		solver.remove(linear);

		// 2 * x - y = 0 (str 0)
		linear = new Linear(0);
		linear.add(x, 2);
		linear.add(y, -1);
		solver.add(linear);

		// y = 1 will be satisfied
		solver.plan();
		solver.execute();

		System.out.println("x = " + x.get() + ", y = " + y.get());
	}

	public static void main(String[] args)
	{
		sample1();
		sample2();
		sample3();
	}

}
