//
// The HiRise Constraint Solver for Java, Ver. 2.0
//
// Copyright (C) 1998-1999 Hiroshi HOSOBE
//
////////////////////////////////////////////////////////////////

//package jp.ac.u_tokyo.s.is.hirise;

import java.util.*;

public class Linear extends Constraint {

	private Vector m_coefs = new Vector(8, 8);
	private double m_const = 0;

	public String toString()
	{
		int i;

		String str = super.toString() + ": ";

		int nVars = countVars();
		if (nVars == 0)
			str += "(no_vars)";
		else {
			for (i = 0; i < nVars; i++) {
				str += getCoef(i) + "*" + getVar(i).getName2();
				if (i < nVars - 1)
					str += " + ";
			}
		}

		return str + " = " + m_const;
	}

	private void init()
	{
	}
	
	Linear(int str)
	{
		super(str);
		init();
	}

	Linear(String name, int str)
	{
		super(name, str);
		init();
	}

	public Constraint add(Variable var)
	{
		add(var, 1);

		return this;
	}

    public Linear add(Variable var, double coef)
	{
		super.add(var);
		m_coefs.addElement(new VecElem(-1, coef));
		
		return this;
	}

    public final double getCoef(int index)
	{
		return ((VecElem) m_coefs.elementAt(index)).value;
	}

	public final Vector getCoefs()
	{
		return m_coefs;
	}

    public final Linear setConst(double ct)
	{
		m_const = ct;
		
		return this;
	}
	
    public final double getConst()
	{
		return m_const;
	}

	// var0 = var1
	public final Linear equal(Variable var0, Variable var1)
	{
		if (countVars() > 0)
			throw new IllegalArgumentException("variables already added");

		add(var0, 1);
		add(var1, -1);
		
		return this;
	}

	// var0 + var1 = var2
	public final Linear sum(Variable var0, Variable var1, Variable var2)
	{
		if (countVars() > 0)
			throw new IllegalArgumentException("variables already added");

		add(var0, 1);
		add(var1, 1);
		add(var2, -1);
		
		return this;
	}

	// (var0 + var1) / 2 = var2
	public final Linear center(Variable var0, Variable var1, Variable var2)
	{
		if (countVars() > 0)
			throw new IllegalArgumentException("variables already added");

		add(var0, 1);
		add(var1, 1);
		add(var2, -2);
		
		return this;
	}

}
