//
// The HiRise Constraint Solver for Java, Ver. 2.0
//
// Copyright (C) 1998-1999 Hiroshi HOSOBE
//
////////////////////////////////////////////////////////////////

//package jp.ac.u_tokyo.s.is.hirise;

import java.util.*;

abstract public class HiRiseObject extends Object {

	protected final class VecElem extends Object {

		public int index;
		public double value;

		VecElem(int idx, double val)
		{
			index = idx;
			value = val;
		}

		VecElem(VecElem elem)
		{
			index = elem.index;
			value = elem.value;
		}

	}

    private String m_name;

    HiRiseObject()
	{
	}
	
    HiRiseObject(String name)
	{
		m_name = name;
	}

    public final String getName()
	{
		return m_name;
	}
	
    public final String getClassAndName()
	{
		String str = getClass().getName();
		String name = getName();
		if (name == null)
			str += ": " + name;
		return str;
	}

}
