//
// HiRiseDemo: A Demo Applet for the HiRise Constraint Solver
//
// Copyright (C) 1998-1999 Hiroshi HOSOBE
//
////////////////////////////////////////////////////////////////

import java.awt.*;
import java.awt.event.*;
import java.applet.*;

public final class HiRiseDemo extends Applet 
implements ActionListener, ItemListener {
	
	public static final String TREE = "Tree";
	public static final String C_SET = "ConstraintSet";
	public static final String INFO = "Information";

	private Cursor m_defaultCursor;
	private Cursor m_waitCursor;
	
	private Choice m_demoChoice;
	private Button m_newButton;
	//private Button m_stopButton;
	
	private Panel m_mainPanel;
	private TreeDemo m_treeDemo;
	private CSetDemo m_cSetDemo;
	
	public String getAppletInfo()
	{
		return InfoPanel.info;
	}
	
	public void init()
	{
		super.init();
		
		m_defaultCursor = new Cursor(Cursor.DEFAULT_CURSOR);
		m_waitCursor = new Cursor(Cursor.WAIT_CURSOR);
		setDefaultCursor();		
		
		setLayout(new BorderLayout());

		Panel p = new Panel();
		add(p, BorderLayout.NORTH);
		p.setLayout(new FlowLayout(FlowLayout.LEFT));

		m_demoChoice = new Choice();
		p.add(m_demoChoice);
		m_demoChoice.addItemListener(this);
		m_demoChoice.add(TREE);
		m_demoChoice.add(C_SET);
		m_demoChoice.add(INFO);
			
		m_newButton = new Button("New");
		p.add(m_newButton);
		m_newButton.addActionListener(this);

		//m_stopButton = new Button("Stop");
		//m_cmdPanel.add(m_stopButton);
		//m_stopButton.addActionListener(this);
		//m_stopButton.setEnabled(false);

		m_mainPanel = new Panel();
		add(m_mainPanel, BorderLayout.CENTER);
		CardLayout cl = new CardLayout();
		m_mainPanel.setLayout(cl);
	
		m_treeDemo = new TreeDemo(this);
		m_mainPanel.add(m_treeDemo, TREE);

		m_cSetDemo = new CSetDemo(this);
		m_mainPanel.add(m_cSetDemo, C_SET);

		m_mainPanel.add(new InfoPanel(), INFO);
		
		cl.show(m_mainPanel, TREE);
	}
	
	public void setDefaultCursor()
	{
		setCursor(m_defaultCursor);
	}

	public void setWaitCursor()
	{
		setCursor(m_waitCursor);
	}

	public void actionPerformed(ActionEvent ev)
	{
		Object src = ev.getSource();
		if (src == m_newButton) {
			String item = m_demoChoice.getSelectedItem();
			if (item == TREE)
				m_treeDemo.start();
			else if (item == C_SET)
				m_cSetDemo.start();
		}
	}
	
	public void itemStateChanged(ItemEvent ev)
	{
		Object src = ev.getSource();
		if (src == m_demoChoice) {
			String item = m_demoChoice.getSelectedItem();
			((CardLayout) m_mainPanel.getLayout()).show(m_mainPanel, item);
			m_newButton.setEnabled(item != INFO);
		}
	}
	
}
