//
// HiRiseDemo: A Demo Applet for the HiRise Constraint Solver
//
// Copyright (C) 1998-1999 Hiroshi HOSOBE
//
////////////////////////////////////////////////////////////////

import java.awt.*;

public final class GraphicsUtility
{
	
	public static final void drawThickLine(
		Graphics g, int x1, int y1, int x2, int y2, int w) 
	{
		int dx = x2 - x1;
		int dy = y2 - y1;
		float d = (float) Math.sqrt(dx * dx + dy * dy);

		float hw = (float) w / 2;
		float ox = dy / d * hw;
		float oy = dx / d * hw;

		int[] x = new int[4];
		int[] y = new int[4];
 		x[0] = (int) (x1 + ox);
 		y[0] = (int) (y1 - oy);
 		x[1] = (int) (x1 - ox);
 		y[1] = (int) (y1 + oy);
 		x[2] = (int) (x2 - ox);
 		y[2] = (int) (y2 + oy);
 		x[3] = (int) (x2 + ox);
 		y[3] = (int) (y2 - oy);

		g.fillPolygon(x, y, 4);
	}
	
}
