//
// The HiRise Constraint Solver for Java, Ver. 2.0
//
// Copyright (C) 1998-1999 Hiroshi HOSOBE
//
////////////////////////////////////////////////////////////////

//package jp.ac.u_tokyo.s.is.hirise;

import java.util.*;

public class Edit extends Constraint {

	private double m_val = 0;

	public String toString()
	{
		String str = super.toString();
		if (countVars() > 0)
			str += ": edit(" + getVar(0).getName2() + ") :" + m_val;
		return str;
	}

	private void init()
	{
	}
	
	Edit(int str)
	{
		super(str);
		init();
	}

	Edit(String name, int str)
	{
		super(name, str);
		init();
	}

	Edit(int str, Variable var)
	{
		super(str);
		init();
		add(var);
	}

	Edit(String name, int str, Variable var)
	{
		super(name, str);
		init();
		add(var);
	}

	public Constraint add(Variable var)
	{
		return add(var, 0);
	}

	public Constraint add(Variable var, double val)
	{
		if (countVars() > 0)
			throw new IllegalArgumentException("variable already added");

		super.add(var);
		m_val = val;

		return this;
	}

	public Constraint set(double val)
	{
		m_val = val;

		return this;
	}
	
	public double get()
	{
		return m_val;
	}

}
