//
// The HiRise Constraint Solver for Java, Ver. 2.0
//
// Copyright (C) 1998-1999 Hiroshi HOSOBE
//
////////////////////////////////////////////////////////////////

//package jp.ac.u_tokyo.s.is.hirise;

import java.util.*;

public class ConstraintSet extends Constraint {

	// strategies
	public static final int NORMAL = 0;
	public static final int CONJUNCTIVE = 1;
	public static final int OPTIMIZING = 2;

	public static final String[] STRATEGY_STRING = {
		"NORMAL", "CONJUNCTIVE", "OPTIMIZING" };

	private static final Class m_setClass = (new ConstraintSet(0)).getClass();
	private static final Class m_stayClass = (new Stay(0)).getClass();
	private static final Class m_editClass = (new Edit(0)).getClass();
	private static final Class m_linearClass = (new Linear(0)).getClass();

	private int m_strategy;
	private Vector m_cons = new Vector(8, 8);

	ConstraintSet(int strategy)
	{
		super(-1); // this strength is temporal
		m_strategy = strategy;
	}

	ConstraintSet()
	{
		this(NORMAL);
	}

	public String toString()
	{
		int n, i;

		String str = "";

		n = m_cons.size();
		for (i = 0; i < n; i++) {
			str += m_cons.elementAt(i).toString();
			if (i < n - 1)
				str += "; ";
		}

		return str;
	}

	public final int getStrategy()
	{
		return m_strategy;
	}

	public final int countCons()
	{
		return m_cons.size();
	}

	public final Constraint getCon(int i)
	{
		return (Constraint) m_cons.elementAt(i);
	}

	public final int index(Constraint con)
	{
		return m_cons.indexOf(con);
	}

	public final void add(Constraint con)
	{
		if (con == null)
			throw new IllegalArgumentException(
				"null pointer given as constraint");

		Class cls = con.getClass();
		if (cls == m_setClass)
			throw new IllegalArgumentException(
				"ConstraintSet nested: " + con.getClassAndName());

		if (m_strategy == CONJUNCTIVE ||
			m_strategy == OPTIMIZING) {
			int nCons = m_cons.size();
			if (nCons >= 3)
				throw new IllegalArgumentException(
					"too many constraints with "
					+ STRATEGY_STRING[m_strategy] + " strategy: "
					+ con.getClassAndName());

			if (nCons == 0) {
				if (con.getStrength() == 0)
					throw new IllegalArgumentException(
						"required strength given with "
		                + STRATEGY_STRING[m_strategy] + " strategy: "
                        + con.getClassAndName());
			}
			else {
				Constraint con0 = (Constraint) m_cons.elementAt(0);
				if (con.getStrength() != con0.getStrength())
					throw new IllegalArgumentException(
						"multiple strengths given with "
						+ STRATEGY_STRING[m_strategy] + " strategy: "
                        + con.getClassAndName());
			}
		}

		m_cons.addElement(con);
		con.setConstraintSet(this);
	}

}
