//
// The HiRise Constraint Solver for Java, Ver. 2.0
//
// Copyright (C) 1998-1999 Hiroshi HOSOBE
//
////////////////////////////////////////////////////////////////

//package jp.ac.u_tokyo.s.is.hirise;

import java.util.*;

public class Constraint extends HiRiseObject {

	private ConstraintSet m_set;
	private Solver m_solver;
    private int m_str;
    private Vector m_vars = new Vector(8, 8);
    private int m_row;

	public String toString()
	{
		String str = super.toString();
		String name = getName();
		if (name != null)
			str += ": " + name;
		return str + ": " + m_str;
	}

	private void init(int str)
	{
		m_str = str;
	}
	
 	public Constraint(int str)
	{
		init(str);
 	}

 	public Constraint(String name, int str)
	{
		super(name);
		init(str);
 	}

	public final void setConstraintSet(ConstraintSet set)
	{
		m_set = set;
	}

	public final ConstraintSet getConstraintSet()
	{
		return m_set;
	}

	public final void setSolver(Solver solver)
	{
		m_solver = solver;
	}

	public final Solver getSolver()
	{
		return m_solver;
	}

	public final int getStrength()
	{
		return m_str;
	}
    
	public final int countVars()
	{
		return m_vars.size();
	}

	public final Variable getVar(int i)
	{
		return (Variable) m_vars.elementAt(i);
	}

	public final int index(Variable var)
	{
		return m_vars.indexOf(var);
	}

	public Constraint add(Variable var)
	{
		if (var == null)
			throw new IllegalArgumentException(
				"null pointer given as variable");

		if (m_vars.indexOf(var) != -1)
			throw new IllegalArgumentException("variable already added");

		m_vars.addElement(var);

		return this;
	}
	
	public final void setRow(int row)
	{
		m_row = row;
	}

	public final int getRow()
	{
		return m_row;
	}

	//
	// for Edit
	//
	
	public Constraint set(double val)
	{
		throw new IllegalArgumentException("set value to non-edit constraint");
	}
	
	public double get()
	{
		throw new IllegalArgumentException(
			"get value from non-edit constraint");
	}

}
