/************************************************************************
 *									*
 *		free_tree	     Aug  19, 1998			* 
 *                                   Oct  26, 1998                      *
 *									*
 ************************************************************************/

#include "protml.h"

/* free tree memory */
void free_tree(Tree *tr, int taxa)
{
	int n;
	Node *dp, *up;

	for (n = 0; n < (taxa-3); n++) {
		dp = tr->ibrnchp[n];
		up = dp->kinp;
		free_dmatrix(up->iprob);
		free_dmatrix(dp->iprob);
		free_ivector(dp->paths);
		free(up);
		free(dp);
	}
	for (n = 0; n < taxa; n++) {
		dp = tr->ebrnchp[n];
		up = dp->kinp;		
		free_dmatrix(up->iprob);
		free_ivector(dp->paths);
		dp = up->kinp;		
		free(up);
		free(dp);
	}
	free_ivector(tr->bturn);
	free(tr->ibrnchp);
	free(tr->ebrnchp);
	free(tr);
}
