/* ----------------------------------------------------------
%   (C)1993,1994,1995 Institute for New Generation Computer Technology
%       (Read COPYRIGHT for detailed information.)
%   (C)1996, 1997 Japan Information Processing Development Center
%       (Read COPYRIGHT-JIPDEC for detailed information.)
%   (C)1998, Takashi Chikayama and Takahide Yoshikawa
----------------------------------------------------------- */
#include <klic/basic.h>
#include <klic/struct.h>
#include <klic/primitives.h>
#include <klic/timing.h>
#include <stdio.h>
#include <klic/functorstuffs.h>
#include <klic/gobj.h>
#include <klic/susp.h>

#ifdef DIST
#include <klic/interpe.h>
#endif
#ifdef SHM
#include <klic/shm.h>
/* a following line is for debugging of reverse pointer problem. */
static int hirata_bug1;

#define push_shm_stack(addr,sp,max)                     \
{                                                       \
   if ( (sp) == max )  {                                \
    (sp) = make_shm_larger_stack(sp);                   \
    max = shm_gcmax;                                    \
  }                                                     \
  *(sp)++ = (q*)(addr);                                 \
}

#endif

extern char *malloc(), *malloc_check(), *realloc_check();
extern struct goalrec goal_queue_tail;

#ifdef GGC2 
int no_ggc_flag;
static q **new_rmset;
static q **new_rmsp;
static q **new_rmsmax;
#endif /* GGC2 */

#ifdef GGC2
static Inline void flip_new_spaces()
{
  declare_globals;
  q *temptp = new_new_space_top;
  q *tempap = new_new_space_heapp;
  unsigned long temps = new_new_space_size;
  unsigned long tempb = new_new_space_bytesize;

  new_new_space_top      = new_old_space_top;
  new_new_space_heapp    = new_old_space_top;
  /*
  new_new_space_heapp    = new_old_space_heapp;
  */
  new_new_space_size     = new_old_space_size;
  new_new_space_bytesize = new_old_space_bytesize;

  new_old_space_top      = temptp;
  new_old_space_heapp    = tempap;
  new_old_space_size     = temps;
  new_old_space_bytesize = tempb;
}
#else /* GGC2 */
static Inline void flip_spaces()
{
  declare_globals;
  q *tempp = new_space_top;
  unsigned long temps = new_space_size;
  new_space_top = old_space_top;
  new_space_size = old_space_size;
  old_space_top = tempp;
  old_space_size = temps;
}
#endif /* GGC2 */

static struct goalrec *collect_garbage();

struct goalrec *klic_gc(qp)
     struct goalrec *qp;
{
  timerstruct before, after;
  declare_globals;
#ifdef GGC2
  q *new_oldp;
  q *new_new_new_space_top;
  static old_space_dangerous = 0;
  static new_space_dangerous = 0;
  static int make_old_space_larger = 0;
  static int make_new_space_larger = 0;
#else  /* GGC2 */
  q *new_new_space_top;
  static lastgc_dangerous = 0;
  static int make_heap_larger = 0; /* make heap larger in the next GC */
#endif /* GGC2 */
  unsigned long bytesize;
  int k;
  if (measure_gc) measure(before);
#ifdef GGC2

  if(no_ggc_flag){
    new_new_space_heapp = new_new_space_top;
  }

  if((old_space_heapp - old_space_top
       + new_new_space_heapp - new_new_space_top > old_space_size))
    fatalf("Old Space is too small ! \n");
  
  /* rememberset becomes gcstack in GGC */
  gcstack      = rmset;
  gcsp         = rmsp;
  gcmax        = rmsmax;
  gcstack_size = rmset_size;

  /***** Template for use LOCK and UNLOCK *****
  UNLOCK_OLDSPACE();
  *(old_space_top+3)= makeref(old_space_top+3);
  LOCK_OLDSPACE();
  ********************************************/


  /* This is for statistics. */
  new_oldp = heapp;

 gc_again:
  if (make_old_space_larger) {
    klic_fprintf(stderr,
         "Old Generation's Heapsize should enlarge. (Not Implememted.)\n");
  }
  if (old_space_dangerous) {
    fatal("Old Generation's Heapsize is too small.\n");
  }

  if (make_new_space_larger){
    q *new_new_old_space_top;    
    heapsize *= 2;
    if (heapsize > maxheapsize) heapsize = maxheapsize;
    bytesize = (heapsize+incrementsize)*sizeof(q);
    new_new_old_space_top = (q *)malloc(bytesize);
    if (new_new_old_space_top != 0) {
      new_new_new_space_top = (q *)malloc(bytesize);
      if (new_new_new_space_top != 0) {
	free(new_old_space_top);
	new_old_space_top      = new_new_old_space_top;
	new_old_space_size     = heapsize;
	new_old_space_bytesize = bytesize;
      } else {
	free(new_new_old_space_top);
	new_new_new_space_top  = new_new_space_top;
	if(new_space_dangerous){	
	  /* If NewSpace is too small for request, give up. */
	  fatal("I cannot enlarge New Generation's Heapsize(new_new_space).");
	}
      }
    } else {
      new_new_new_space_top  = new_new_space_top;
      if(new_space_dangerous){	
	fatal("I cannot enlarge New Generation's Heapsize(new_old_space).");
      }
    }
  } else if(new_space_dangerous){
    fatalf("Maximum heap size specified (%u words) has been used up",
           maxheapsize);
  }

  flip_new_spaces();
#ifdef GGCDEBUG
  printf("GC %d oldspace %x  new_new_space %x new_old_space %x\n new_new-new_old %x, old-new_new %x\n gcset %x gcmax %x gcsp %x\n"
               ,gctimes,old_space_top,new_new_space_top,new_old_space_top
               ,new_new_space_top - new_old_space_top
               ,old_space_top - new_new_space_top,gcstack,gcmax,gcsp);
#endif /* GGCDEBUG */

  copied_susp = 0;		/* for perpetual suspension detection */
  qp = collect_garbage(qp);

  new_new_space_heapp = heapp;

#ifdef GGCDEBUG
  printf("new_old %x/%x, Border %x , new_new %x/%x  , old %x/%x \n",
    (unsigned long)new_oldp - (unsigned long)new_old_space_top,
    new_old_space_bytesize,new_old_space_heapp,
    (unsigned long)new_new_space_heapp - (unsigned long)new_new_space_top,
    new_new_space_bytesize,
    (unsigned long)old_space_heapp - (unsigned long)old_space_top,
    old_space_bytesize
  );
#endif /* GGCDEBUG */


  if (make_new_space_larger) {
    free(new_old_space_top);
    new_old_space_top      = new_new_new_space_top;
    new_old_space_size     = heapsize;
    new_old_space_bytesize = bytesize;
  }

  make_old_space_larger =
    (old_space_heapp - old_space_top > old_space_size * oldactiveratio);
  old_space_dangerous   =
    (old_space_heapp - old_space_top
       + new_new_space_heapp - new_new_space_top > old_space_size);

  make_new_space_larger  =
     (new_new_space_heapp - new_new_space_top + this_more_space 
                                  > new_new_space_size * newactiveratio &&
      new_new_space_size + incrementsize  < maxheapsize );
  if(new_space_dangerous = 
          (real_heaplimit < new_new_space_heapp+this_more_space)) {
    goto gc_again;
  }

#else /* GGC2 */
 gc_again:
  if (make_heap_larger) {
    q *new_old_space_top;
    heapsize *= 2;
    if (heapsize > maxheapsize) heapsize = maxheapsize;
    bytesize = (heapsize+incrementsize)*sizeof(q);
    new_old_space_top = (q *)malloc(bytesize);
    if (new_old_space_top != 0) {
      new_new_space_top = (q *)malloc(bytesize);
      if (new_new_space_top != 0) {
	free(old_space_top);
	old_space_top = new_old_space_top;
	old_space_size = bytesize;
      } else {
	free(new_old_space_top);
	if (lastgc_dangerous) {
	  fatal("Not enough space collected and can't make heap larger");
	}
      }
    }
  } else if (lastgc_dangerous) {
    fatalf("Maximum heap size specified (%u words) has been used up",
	   maxheapsize);
  }
  flip_spaces();
  copied_susp = 0;		/* for perpetual suspension detection */
  qp = collect_garbage(qp);
  if (make_heap_larger) {
    free(old_space_top);
    old_space_top = new_new_space_top;
    old_space_size = bytesize;
  }
  make_heap_larger =
    (heapp-new_space_top+this_more_space > heapsize*maxactiveratio &&
     heapsize < maxheapsize);
  if (lastgc_dangerous = (real_heaplimit < heapp+this_more_space)) {
    goto gc_again;
  }
#endif /* GGC2 */
  this_more_space = 0;
  gctimes++;
#ifdef GGC2
  heaptop = new_new_space_top;
  heapp   = new_new_space_heapp;

  free(rmset);
  rmset      = new_rmset;
  rmsp       = new_rmsp;
  rmsmax     = new_rmsmax;
  rmset_size = gcstack_size;

  /*
  printf("rmset %x rmsmax %x rmsp %x\n\n",rmset,rmsmax,rmsp);
  */

#endif /* GGC2 */

#ifdef SHM
    if ( F_shm_gc ) qp = shm_gc(qp);
#endif
  if (measure_gc) {
    measure(after);
#ifdef GETRUSAGE
    gcums += diff_usec(ru_utime)/1000;
    gcsms += diff_usec(ru_stime)/1000;
#else
    gcums += (int) tick2msec(field_diff(tms_utime));
    gcsms += (int) tick2msec(field_diff(tms_stime));
#endif
  }
  return qp;
}


q**
make_larger_stack(sp)
     q**sp;
{
  declare_globals;
  q **newstack;
  gcstack_size *= 2;
  newstack = (q**)realloc_check(gcstack, gcstack_size*sizeof(q*));
#ifdef GGC2
  free(gcstack);
#endif /* GGC2 */
  sp = newstack+(sp-gcstack);
  gcstack = newstack;
  gcmax = newstack+gcstack_size;
  return sp;
}

#ifdef SHM
q** make_shm_larger_stack(sp)
     q**sp;
{
  declare_globals;
  q **newstack;
  shm_gcstack_size *= 2;
  newstack = (q**)realloc_check(shm_gcstack, shm_gcstack_size*sizeof(q*));
  sp = newstack+(sp-shm_gcstack);
  shm_gcstack = newstack;
  shm_gcmax = newstack+shm_gcstack_size;
  return sp;
}
#endif

#ifdef GGC2

#define within_to_space(x)	\
( (unsigned long)(x) - (unsigned long)nntop < nnsize)
#define within_from_space(x)	\
( (unsigned long)(x) - (unsigned long)notop < nosize)

#define within_old_space(x)     \
( (unsigned long)(x) - (unsigned long)otop  < osize)

#define copied_to_old_space(x)     \
( (unsigned long)(x) - (unsigned long)copied_cons_base < osize )

#define is_oldspace_hook(x)     \
( (unsigned long)(x) - (unsigned long)oldspace_hook_base < osize )


#define within_expd_space(x)    \
( (unsigned long)(x) - (unsigned long)notop < expd_size)

/*
#define within_noexpd_space(x) \
(within_from_space(x) && !within_expd_space(x))
*/

#else  /* GGC2 */
#define within_new_space(x)	\
( (unsigned long)(x) - (unsigned long)ntop < nsize)

#define within_old_space(x)	\
( (unsigned long)(x) - (unsigned long)otop < osize)
#endif /* GGC2 */

#ifdef GGC2
#define gc_push_rmset(addr)         			                     \
{							                     \
  if ((new_rmsp) == new_rmsmax) {			                     \
    gc_make_larger_rmset();        	                                     \
  }							                     \
  if(!isatomic(*addr) && within_old_space(addr) && within_to_space(*addr)){  \
    *(new_rmsp)++ = (addr);				                     \
    /*                                                                       \
    printf("gc_push rmsp %x max %x\n",new_rmsp,new_rmsmax);                  \
    printf("gc_push addr %x *addr %x\n",addr,*addr);                         \
    */                                                                       \
  /*                                                                         \
  }else{                                                                     \
    fatalf("Not old_space_obj %x is pushed into RMSET \n",addr);             \
  */                                                                         \
  }                                                                          \
}

#define gc_make_larger_rmset()                                           \
{                                                                        \
  q **tmp_newrmset;                                                      \
  rmset_size  *= 2;                                                      \
  /*                                                                     \
  printf("Make rmset larger(GC) rmset_size %d\n",rmset_size);            \
  */                                                                     \
  tmp_newrmset = (q**)realloc(new_rmset, rmset_size*sizeof(q*));         \
  if(tmp_newrmset == 0){                                                 \
    fatalf("No more memory available for realloc rmset (%d bytes)\n",    \
	      rmset_size);                                               \
  }                                                                      \
  free(new_rmset);                                                       \
  new_rmsp     = tmp_newrmset+(new_rmsp-new_rmset);                      \
  new_rmset    = tmp_newrmset;                                           \
  new_rmsmax   = new_rmset + rmset_size;                                 \
}

#endif /* GGC2 */

#define push_gc_stack(addr, sp, max)			\
{							\
  if ((sp) == max) {					\
    (sp) = make_larger_stack(sp);			\
    max = gcmax;					\
  }							\
  *(sp)++ = (addr);					\
/*                                                      \
  printf("PUSH *addr %x  addr %x \n",*addr,addr);       \
  printf("PUSH *addr %x \n",*addr);                     \
*/                                                      \
}

#ifdef SHM
#define reserve_copy(from, to, sp, max)                 \
if (from == makeref(&from)) {                           \
  to = from = makeref(&to);                             \
} else {                                                \
  to = from;                                            \
  if (!isatomic(from)) {                                \
    if ( is_shma(from) ) {                              \
       push_shm_stack(&to,shm_sp,shm_gcmax);            \
    } else if ( within_old_space(from )) {              \
       from = makeref(&to);                             \
       push_gc_stack(&to, sp, max);                     \
    }                                                   \
  }                                                     \
}
#else
#ifdef GGC2
#define reserve_copy(from, to, sp, max)			    \
  /*                                                    \
printf("RESERVE from %x to %x,f+no %x f+nn %x toto %d toold %d \n",from,to  \
         ,(q)((unsigned long)from+(unsigned long)notop)     \
         ,(q)((unsigned long)from+(unsigned long)nntop)     \
      ,copied_to_to_space(from),copied_to_old_space(from)); \
  */                                                    \
if (from == makeref(&from)) {				    \
    to = from = makeref(&to);				    \
} else {						    \
  to = from;						    \
  if ( (!isatomic(from) && within_from_space(from)) ||      \
       ( iscons(from) && copied_to_old_space(from)) ) {     \
    from = makeref(&to);				    \
    push_gc_stack(&to, sp, max);			    \
/*                                                          \
  } else if(!isatomic(from) && within_old_space(to)){       \
    gc_push_rmset(to);                                      \
*/                                                          \
  }                                                         \
}
#define reserve_copy2(to, sp, max)			    \
  /*                                                    \
printf("RESERVE2  to %x toto %d toold %d \n",to             \
         ,copied_to_to_space(to),copied_to_old_space(to));  \
  */                                                    \
if (to != makeref(&to)){                                    \
  if ( (!isatomic(to) && within_from_space(to)) ||          \
       ( iscons(to) && copied_to_old_space(to))){           \
    push_gc_stack(&to, sp, max);			    \
/*                                                          \
  } else if(!isatomic(from) && within_old_space(to)){       \
    gc_push_rmset(to);                                      \
*/                                                          \
  }                                                         \
}
#else  /* GGC2 */
#define reserve_copy(from, to, sp, max)			\
if (from == makeref(&from)) {				\
  to = from = makeref(&to);				\
} else {						\
  to = from;						\
  if (!isatomic(from) && within_old_space(from)) {	\
    from = makeref(&to);				\
    push_gc_stack(&to, sp, max);			\
  }							\
}
#endif /* GGC2 */
#endif /* SHM  */
#ifdef GGC2
#define copy_one_goal(goal, sp, max, susp)		     \
{							     \
  struct goalrec *og=(goal);				     \
  int n = (og)->pred->arity;				     \
  struct goalrec *ng;                                        \
  unsigned long  expd_size = (unsigned long)new_old_space_heapp \
                   - (unsigned long)new_old_space_top;          \
  if(within_old_space(og)) {                                 \
    /*                                                       \
    printf("O %x OP %x ON %x \n",og,og->pred, og->next);     \
    */                                                       \
    /*                                                       \
    while(--n >= 0){                                         \
      reserve_copy2(og->args[n],(sp),(max));                 \
    }                                                        \
    */                                                       \
  } else if(within_expd_space(og)) {                         \
    ng = (struct goalrec *)old_space_heapp;                  \
    UNLOCK_OLDSPACE();					     \
    old_space_heapp += n + 2;                                \
    ng->next = og->next;				     \
    og->next = ng;					     \
    ng->pred = og->pred;				     \
    og->pred = 0;					     \
    /*                                                       \
    printf("Fe %x FeP %x FeN %x ",ng,ng->pred, ng->next);  \
    printf("OFe %x OFeP %x OFeN %x \n",og,og->pred, og->next);  \
    */                                                       \
    while (--n >= 0) {				             \
      reserve_copy(og->args[n], ng->args[n], (sp), (max));   \
    /*                                                       \
      printf("og%x ng%x ",og->args[n], ng->args[n]);      \
    */                                                       \
    }							     \
    (goal) = ng;					     \
    /*                                                       \
    printf("\n");                                            \
    */                                                       \
    LOCK_OLDSPACE();					     \
    if (susp) copied_susp++;				     \
  } else if(within_from_space(og)) {                         \
    ng = (struct goalrec *)hp;                               \
    hp += n + 2;                                             \
    ng->next = og->next;				     \
    og->next = ng;					     \
    ng->pred = og->pred;				     \
    og->pred = 0;					     \
    /*                                                       \
    printf("Fn %x FnP %x FnN %x ",ng,ng->pred, ng->next);  \
    printf("OFn %x OFnP %x OFnN %x \n",og,og->pred, og->next);  \
    */                                                       \
    while (--n >= 0) {					     \
      reserve_copy(og->args[n], ng->args[n], (sp), (max));   \
    /*                                                       \
      printf("og%x ng%x ",og->args[n], ng->args[n]);      \
    */                                                       \
    }							     \
    (goal) = ng;					     \
    /*                                                       \
    printf("\n");                                            \
    */                                                       \
    if (susp) copied_susp++;				     \
  } else if(within_to_space(og)){                            \
  } else {                                                   \
    fatalf( "Unknown Status Occurred OG %x \n",og);          \
  }                                                          \
}
#else  /* GGC2 */
#define copy_one_goal(goal, sp, max, susp)		\
{							\
  struct goalrec *og=(goal);				\
  int n = (og)->pred->arity;				\
  struct goalrec *ng = (struct goalrec *)hp;		\
  hp += n + 2;						\
  ng->next = og->next;					\
  og->next = ng;					\
  ng->pred = og->pred;					\
  og->pred = 0;						\
  while (--n >= 0) {					\
    reserve_copy(og->args[n], ng->args[n], (sp), (max)); \
  }							\
  (goal) = ng;						\
  if (susp) copied_susp++;				\
}
#endif /* GGC2 */

#ifdef GGC2
static q *
copy_terms(hp, nntop, notop, nnsize, nosize, sp, max)
     q *hp;
     q *nntop, *notop;
     unsigned long nnsize, nosize;
     q **sp, **max;
{
  declare_globals;
  unsigned long osize,expd_size;
  q *otop;

  otop      = old_space_top;
  osize     = old_space_bytesize;
  expd_size = (unsigned long)new_old_space_heapp 
                  - (unsigned long)new_old_space_top;

  while (sp > gcstack) {
    q *addr = *--sp;
    q obj;

#ifdef  REMEMBER_HOOK
	if(is_oldspace_hook(addr)){
	  /* obj is OLD SPACE's hook .*/
	  struct hook *entry_hook 
             = (struct hook *)((unsigned long)addr + (unsigned long)otop 
                                  - (unsigned long)oldspace_hook_base);
	  struct hook *lasth      = entry_hook;
	  struct hook *last_lasth = entry_hook;
	  struct hook *h          = entry_hook->next;
#ifdef GGCDEBUG
	  printf("OLDSPACE HOOK %x\n",entry_hook);
#endif /* GGCDEBUG */
	  do {
	    union goal_or_consumer u;
	    union goal_or_consumer nu;
	    struct hook *nh;
	    u = h->u;
	    if(within_from_space(h)){
	      if(!is_consumer_hook(u)){
		/* Suspended Goal */
		if(u.g->pred == 0){
		  /* Already Copied */
		  nu.g = u.g->next;
		} else if(!isref(u.g->next)){
		  nu.g = u.g;
		  if(!within_old_space(u.g)){
		    copy_one_goal(nu.g,sp,max,1);
		  } else {
		    printf("Illegal Hook is detected. Hook %x Goal \n",h,u.g);
		  }
		} else {
		  /* Already Resumed */
		  nh = h->next;
		  if(!within_old_space(h)){
		    h->next = last_lasth;
		    h->u.l  = 0x10;
		  }		
		  h = nh;
		  goto invalid_hook2;
		}
	      } else {
		/* Consumer Obj. */
		q newplace = (q)(untag_consumer_hook(u.o)->method_table);
		if (isstruct(newplace)) {
		  nu.o = tag_consumer_hook(functorp(newplace));
		} else {
		  struct consumer_object *newobj =
		    (struct consumer_object *)
		       generic_gc(untag_consumer_hook(u.o), hp, sp);
		  sp = gcsp;
		  hp = heapp;
		  untag_consumer_hook(u.o)->method_table =
		    (struct consumer_object_method_table *)
		       makefunctor(newobj);
		  nu.o = tag_consumer_hook(newobj);
		}
	      }
	      
	      if(within_old_space(nu.g)){
		nh = (struct hook *)old_space_heapp;
		old_space_heapp += sizeof(struct hook)/sizeof(q);
	      } else {
		nh = (struct hook *)hp;
		hp += sizeof(struct hook)/sizeof(q);
	      }
	      nh->u    = nu;
	      nh->next = h->next;
	      lasth->next = nh;
	      
	      /*
	      if(!within_old_space(h)){
	      */
		/* A copied hook is marked and change next_field
		   into the previous hook. */
		h->u.l  = 0x10;
		h->next = lasth;
		/*
	      }
	      */

	      if(within_old_space(lasth)&&within_to_space(nh)){
		if ((new_rmsp) == new_rmsmax) {
		  gc_make_larger_rmset();
		}
		*(new_rmsp)++ = (q *)((unsigned long)lasth 
		     - (unsigned long)otop+(unsigned long)oldspace_hook_base);
	      }
	    } else {
	      lasth->next = h;
	      break;
	    }

	    last_lasth = lasth;
	    lasth = nh;
	    h = nh->next;
	    
	  invalid_hook2:
	  } while (h != entry_hook&&within_from_space(h));

	  if(h == entry_hook){
	    lasth->next = entry_hook;
	  }
	  break;
	}
#endif /* REMEMBER_HOOK */

	obj = *addr;
    /*    printf("addr %x obj %x\n",addr,obj); */
  loop:
#ifdef SHM
          if ( is_shma(obj) ) {
            *addr = obj;
            if ( ptagof(obj) != ATOMIC ) {
              push_shm_stack(addr,shm_sp,shm_gcmax);
            }
            continue;
          }
#endif

/*
    if(within_old_space(*addr)){
      if(within_old_space(obj)){
        break;
      } else if(within_noexpd_space(*addr)){
        gc_push_rmset(addr);
      }
    }
    printf("addr %x obj %x\n",addr,obj);
*/

    /*
    if(!isatomic(obj) && within_old_space(obj)) {
      printf("SKIP addr %x obj %x\n",addr,obj);
      continue;
    }
    */

    switch (ptagof(obj)) {
    case ATOMIC:
      UNLOCK_OLDSPACE();
      *addr = obj;
      LOCK_OLDSPACE();
      break;
    case VARREF:
      {
	q value;

      deref:
	/*
	if(within_old_space(obj)){
	  UNLOCK_OLDSPACE();
	  *addr = obj;
	  LOCK_OLDSPACE();
	  break;
	}
	*/
	value = derefone(obj);
	switch (ptagof(value)) {
	case VARREF:
	  if (derefone(value) == obj) {
	    if (value == obj) {

	      /* UNDEF Var. within_old_space(addr) is necessary */
	      if(within_expd_space(obj)){
		UNLOCK_OLDSPACE();
		*addr = derefone(obj) = *old_space_heapp
 		                      = makeref(old_space_heapp);
		LOCK_OLDSPACE();
		old_space_heapp++;
	      } else if(!within_old_space(obj)){
		  UNLOCK_OLDSPACE();
		  *addr = derefone(obj) = *hp
		                        = makeref(hp);
		  LOCK_OLDSPACE();
		  hp++;
		  /*
		  if(within_old_space(addr)) gc_push_rmset(addr);
		  */
	      } else {
		/* obj is in old_space. */
		UNLOCK_OLDSPACE();
		*addr = obj;
		LOCK_OLDSPACE();
	      }
	    } else {
	      struct susprec *s;

	      s = suspp(value);
	      if (is_generator_susp(s->u)) {
		struct generator_susp *gsusp = generator_suspp(s);
		q newvar = *addr = derefone(obj) = makeref(hp);
		hp++;
		/*
		printf("GENEREATOR \n");

		if(within_old_space(addr))   printf("GE addr %x\n",addr);
		if(within_old_space(obj))    printf("GE obj  %x\n",obj);
		if(within_old_space(value))  printf("GE val  %x\n",value);
		*/

		{
		  struct generator_susp *newgsusp = generator_suspp(hp);
		  hp += sizeof(struct generator_susp) / sizeof(q);
		  derefone(newvar) = makeref(newgsusp);
		  newgsusp->backpt = makeref(newvar);
		  {
		    struct generator_object *oldobj =
		      untag_generator_susp(gsusp->u.o);
		    q newplace = (q)(oldobj->method_table);
		    if(!isstruct(newplace)) {
		      /* not yet copied */
		      struct generator_object *newobj
			= (struct generator_object *)
			  generic_gc(oldobj, hp, sp);
		      sp = gcsp;
		      hp = heapp;
		      oldobj->method_table = 
			(struct generator_object_method_table *)
			  makefunctor(newobj);
		      newgsusp->u.o = tag_generator_susp(newobj);
		    } else {
		      /* already copied */
		      newgsusp->u.o =
			tag_generator_susp(functorp(newplace));
		    }
		  }
		}
	      } else {
		struct hook *second_hook = s->u.first_hook.next;
		struct hook *h = second_hook;
		struct hook dummy;
		struct hook *last = &dummy;
		struct hook *lasth = &s->u.first_hook;
		union goal_or_consumer lastu;
		q newvar = 0x0;

#ifdef REMEMBER_HOOK
		if(s->u.first_hook.u.l == 0x10){
		  /* This Hook is already copied. */
		  struct susprec *ns;
		  struct hook *currenth = second_hook->next;
#ifdef GGCDEBUG
		  printf("FH copied %x \n",s);
#endif /* GGCDEBUG */
		  if(within_old_space(currenth->u.g)){
		    ns = (struct susprec *)old_space_heapp;
		    old_space_heapp += sizeof(struct susprec)/sizeof(q);
		  } else {
		    ns = (struct susprec *)hp;
		    hp += sizeof(struct susprec)/sizeof(q);
		  }

		  ns->backpt            = newvar;
		  second_hook->next     = &ns->u.first_hook;
		  ns->u.first_hook.next = currenth->next;
		  ns->u.first_hook.u    = currenth->u;


		  if(within_old_space(ns)&&within_to_space(currenth->next)){
		    if ((new_rmsp) == new_rmsmax) {
		      gc_make_larger_rmset();
		    }
		    *(new_rmsp)++ = (q *)((unsigned long)&ns->u.first_hook
 		     - (unsigned long)otop+(unsigned long)oldspace_hook_base);
		  }

		  if(!within_old_space(currenth)){
		    currenth->u.l  = 0x10; 
		    currenth->next = h; 
		  }

		  break;
		}
#endif /* REMEMBER_HOOK */

		/* First. addr is UNDEF */
		/*
		UNLOCK_OLDSPACE();
		*addr = addr;
		LOCK_OLDSPACE();
		*/
		lastu.l = 0;
		do {
		  union goal_or_consumer u;
		  u = h->u;
		  if (u.l != 0) {
		    union goal_or_consumer nu;
		    nu.l = 0;
		    if (!is_consumer_hook(u)) {
		      /* suspended goal */
		      if (u.g->pred == 0) {
			/* Already Copied */
			nu.g = u.g->next;
		      } else if (!isref(u.g->next)) {
			/* Not Copied Yet */
			nu.g = u.g;
#ifdef REMEMBER_HOOK
			if(!within_old_space(u.g) && !within_to_space(u.g)){
			  copy_one_goal(nu.g, sp, max, 1);
			} else if(newvar != 0x0){
			  struct hook *nh;
			  if(within_old_space(lasth)){
			    nh = lasth;
			  } else {
			    if(within_old_space(lastu.g)){
			      nh = (struct hook *)old_space_heapp;
			      old_space_heapp += sizeof(struct hook)/sizeof(q);
			    } else {
			      nh = (struct hook *)hp;
			      hp += sizeof(struct hook)/sizeof(q);
			    }
			  }
			  nh->u      = lastu;
			  last->next = nh;
			  nh->next   = h;
			  break;
			}
#else /* REMEMBER_HOOK */
			if(!within_old_space(u.g)){
			  copy_one_goal(nu.g, sp, max, 1);
			}
#endif /* REMEMBER_HOOK */
		      } else {
			goto not_a_valid_hook;
		      }
		    } else {
		      /* consumer object */
		      q newplace = (q)(untag_consumer_hook(u.o)->method_table);
		      /*
		      printf("CONSUMER gctimes %x\n",gctimes);
		      */
		      if (isstruct(newplace)) {
			nu.o = tag_consumer_hook(functorp(newplace));
		      } else {
			struct consumer_object *newobj =
			  (struct consumer_object *)
			    generic_gc(untag_consumer_hook(u.o), hp, sp);
			sp = gcsp;
			hp = heapp;
			untag_consumer_hook(u.o)->method_table =
			  (struct consumer_object_method_table *)
			    makefunctor(newobj);
			nu.o = tag_consumer_hook(newobj);
		      }
		    }

		    if (lastu.l != 0) {
		      struct hook *nh;
		      UNLOCK_OLDSPACE();
#ifdef REMEMBER_HOOK
		      if(within_old_space(lasth) || within_to_space(lasth)){
#else  /* REMEMBER_HOOK */
		      if(within_old_space(lasth)){
#endif /* REMEMBER_HOOK */
			nh = lasth;
		      } else {
			if(within_old_space(lastu.g)){
			  nh = (struct hook *)old_space_heapp;
			  old_space_heapp += sizeof(struct hook)/sizeof(q);
			} else {
			  nh = (struct hook *)hp;
			  hp += sizeof(struct hook)/sizeof(q);
			}
		      }
		      nh->u = lastu;
		      last->next = nh;
#ifdef REMEMBER_HOOK
		      if(last != &dummy){
			if(within_old_space(last)&&within_to_space(nh)){
			  if ((new_rmsp) == new_rmsmax) {
			    gc_make_larger_rmset();
			  }
			  *(new_rmsp)++ = (q *)((unsigned long)last 
  		                        - (unsigned long)otop
                                        + (unsigned long)oldspace_hook_base);
			  /*
			  printf("SPACE HOOK last %x -> nh %x \n",last,nh);
			  */
			}
			if(!within_old_space(lasth)){
			  lasth->next = last;
			  lasth->u.l  = 0x10;
			}
		      }
#endif /* REMEMBER_HOOK */
		      last = nh;
		      LOCK_OLDSPACE();
		    }
		    lasth = h;
		    lastu = nu;
		  }
		not_a_valid_hook:
		    h = h->next;
		} while (h != second_hook);

		if (lastu.l != 0) {
		  struct susprec *ns;
		  UNLOCK_OLDSPACE();
	
		  if(within_old_space(s)){
		    ns = s;
		  } else {
		    if(within_old_space(lastu.g)){
		      ns = (struct susprec *)old_space_heapp;
		      old_space_heapp += sizeof(struct susprec)/sizeof(q);
		    } else {
		      ns = (struct susprec *)hp;
		      hp += sizeof(struct susprec)/sizeof(q);
		    }
		  }

		  /* copy "obj" */
		  if(within_old_space(obj)){
		    newvar = obj;
#ifdef GGCDEBUG
		    if(!within_old_space(ns)){
		      printf("obj %x ns %x \n",obj,ns);
		    }
		    if(ns != s){
		      printf("OOO obj %x newvar %x ns %x \n",obj,newvar,ns);
		      printf("s %x ns %x \n",s,ns);
		    }
#endif /* GGCDEBUG */

		  } else {
		    if(within_old_space(ns)){
		      newvar = *addr = derefone(obj) = *old_space_heapp
			= makeref(old_space_heapp);
		      old_space_heapp++;
		      /*
		      newvar = *addr = derefone(obj) = *hp = makeref(hp);
		      hp++;
		      */
		      /*
		      printf("NOO obj %x newvar %x ns %x \n",obj,newvar,ns);
		      */
		    } else {
		      newvar = *addr = derefone(obj) = *hp = makeref(hp);
		      hp++;
		      /*
		      printf("NNN obj %x newvar %x ns %x \n",obj,newvar,ns);
		      */
		    }
		  }
		  
		  /* Old Susp Goal Queue must be checked. */
		  /*
		  if(within_old_space(newvar) && within_old_space(addr)){
		    if ((new_rmsp) == new_rmsmax) {
		      gc_make_larger_rmset();
		    }
		    *(new_rmsp)++ = addr;
		  }
		  */

		  last->next = &ns->u.first_hook;
#ifdef REMEMBER_HOOK
		  if(within_old_space(last)&&within_to_space(ns)){
		    if ((new_rmsp) == new_rmsmax) {
		      gc_make_larger_rmset();
		    }
		    *(new_rmsp)++ = (q *)((unsigned long)last 
		                    - (unsigned long)otop
                                    + (unsigned long)oldspace_hook_base);
		  }
		  if(!within_old_space(lasth)){
		    lasth->next = last;
		    lasth->u.l  = 0x10;
		  }
#endif /* REMEMBER_HOOK */
		  ns->backpt = newvar;
		  ns->u.first_hook.next = dummy.next;
		  ns->u.first_hook.u = lastu;
		  derefone(newvar) = (q)ns;
#ifdef REMEMBER_HOOK
		  if(within_old_space(ns)&&within_to_space(dummy.next)){
		    if ((new_rmsp) == new_rmsmax) {
		      gc_make_larger_rmset();
		    }
		    *(new_rmsp)++ = (q *)((unsigned long)ns
			  + (unsigned long) sizeof(q)
			  - (unsigned long)otop
                          + (unsigned long)oldspace_hook_base);
		  }
#endif /* REMEMBER_HOOK */
		  LOCK_OLDSPACE();

		} else {
		  UNLOCK_OLDSPACE();
		  /* only resumed goals are hooked. */
		  if(within_old_space(obj)){
		    *addr = derefone(obj) = obj;
		  } else if(within_expd_space(obj)){
		    *addr = obj = derefone(obj) = *old_space_heapp 
                                                = makeref(old_space_heapp);
		    old_space_heapp++;
		  } else {
		    *addr = obj = derefone(obj) = *hp
                                                = makeref(hp);
		    hp++;
		  }
		  LOCK_OLDSPACE();
		}
	      }
	    }
	  } else if(within_old_space(obj)){
	    UNLOCK_OLDSPACE();
	    *addr = obj;
	    LOCK_OLDSPACE();
    	  } else if(within_from_space(value)){
	    obj = value;
	    goto deref;
	  }else {
	    UNLOCK_OLDSPACE();
	    *addr = value;
	    LOCK_OLDSPACE();
	  }
	  break;
	case CONS:

	  if(within_old_space(obj)){
	    UNLOCK_OLDSPACE();
	    *addr = obj;
	    LOCK_OLDSPACE();
	    break;
	  }

	  if(within_to_space(value)){
	    /* Already copied to to_space. */
	    UNLOCK_OLDSPACE();
	    *addr = makeref(&cdr_of(value));
	    /*
	    printf("COPIED NEW CONS addr %x *addr %x\n",addr,*addr);
	    */
	    LOCK_OLDSPACE();
	  } else if(copied_to_old_space(value)){
	    /* Already copied to old_space. */
	    UNLOCK_OLDSPACE();
	    *addr=makeref(&cdr_of((unsigned long)value+(unsigned long)otop
				    -(unsigned long)copied_cons_base));
	    /*
	    printf("COPIED OLD CONS addr %x *addr %x\n",addr,*addr);
	    */
	    LOCK_OLDSPACE();
	  } else {
	    /* Not copied yet. */
	    obj = value;
	    goto cons_case;
	  }
	  break;

	case ATOMIC:
	  /*
	  if(within_old_space(obj)){
	    UNLOCK_OLDSPACE();
	    *addr = obj;
	    LOCK_OLDSPACE();
	  } else {
	    UNLOCK_OLDSPACE();
	    *addr = value;
	    LOCK_OLDSPACE();
	  }
	  */
	    UNLOCK_OLDSPACE();
	    *addr = value;
	    LOCK_OLDSPACE();
	  break;
	default: /* FUNCTOR */
	  /*
	  if(within_old_space(obj)){
	    UNLOCK_OLDSPACE();
	    *addr = obj;
	    LOCK_OLDSPACE();
	    break;
	  } else {
	    obj = value;
  	    goto functor_case;
	  }
	  */
	    obj = value;
	    goto functor_case;
	}
      }
      break;

    case CONS:
    cons_case:
        if(within_from_space(obj)){
	q cdr = cdr_of(obj);
	if (iscons(cdr) && within_to_space(cdr)){
	  /* Already copied to to_space. */
	  UNLOCK_OLDSPACE();
	  *addr = cdr;
	  /*
	  printf("COPIED NEW CONS2 addr %x *addr %x \n",addr,*addr);
	  */
	  LOCK_OLDSPACE();
	} else if (iscons(cdr) && copied_to_old_space(cdr)){
	  /* Already copied to old_space. */
	  UNLOCK_OLDSPACE();
	  *addr = (q)((unsigned long)cdr+(unsigned long)otop
		        -(unsigned long)copied_cons_base);
	  /*
	  printf("COPIED OLD CONS2 addr %x *addr %x \n",addr,*addr);
	  */
	  LOCK_OLDSPACE();
	} else {
	  /* Not copied yet. */
	  q newcons;
	  if(within_expd_space(obj)){
	    UNLOCK_OLDSPACE();
	    newcons = makecons(old_space_heapp);
	    old_space_heapp += 2;
	    reserve_copy(car_of(obj), car_of(newcons), sp, max);
	    *addr = newcons;
	    cdr_of(obj) 
                  = (q)((unsigned long)newcons-(unsigned long)otop
                      + (unsigned long)copied_cons_base);
	    /*
	    printf("OLD COPIED  *addr %x cdr %x \n",*addr,cdr_of(obj));
	    */
	    LOCK_OLDSPACE();
	  } else {
	    newcons = makecons(hp);
	    hp += 2;
	    UNLOCK_OLDSPACE();
	    reserve_copy(car_of(obj), car_of(newcons), sp, max);
	    *addr = cdr_of(obj) = newcons;
	    /*
	    printf("NEW COPIED  *addr %x cdr %x \n",*addr,cdr_of(obj));
	    */
	    LOCK_OLDSPACE();
	  }
	  if (isatomic(cdr)) {
	    UNLOCK_OLDSPACE();
	    cdr_of(newcons) = cdr;
	    LOCK_OLDSPACE();
	  } else {
	    if (cdr == makeref(&cdr_of(obj))) {
	      UNLOCK_OLDSPACE();
	      cdr_of(newcons) = makeref(&cdr_of(newcons));
	      LOCK_OLDSPACE();
	    } else {
	      /* Tail Recursion */
	      if(within_old_space(addr)) gc_push_rmset(addr);
	      UNLOCK_OLDSPACE();
	      addr = &cdr_of(newcons);
	      LOCK_OLDSPACE();
	      obj = cdr;
	      goto loop;
	    }
	  }
	}
      } else if(iscons(obj) && copied_to_old_space(obj)) {
	UNLOCK_OLDSPACE();
	*addr = (q)((unsigned long)obj + (unsigned long)otop
                   -(unsigned long)copied_cons_base);
/*
	printf("COPIED OLD CONS3 addr %x *addr %x \n",addr,*addr);
*/
	LOCK_OLDSPACE();
      } else {
	UNLOCK_OLDSPACE();
	*addr = obj;
/*	
	printf("COPIED NEW CONS3 addr %x *addr %x \n",addr,*addr);
*/	
	LOCK_OLDSPACE();
      }
    break;

    default: /* FUNCTOR */
    functor_case:
      if(within_from_space(obj)){
	q f = functor_of(obj);
	if(!isstruct(f)){
	  if(isref(f)) {
	    struct data_object *oldobj
	      = (struct data_object *)functorp(obj);
	    q *newobj;
	    /*
	    if(within_old_space(addr)) printf("DO addr %x\n",addr);
	    if(within_old_space(obj))  printf("DO obj  %x\n",obj);
	    */
#ifdef GENERIC_GGC
	    newobj = generic_ggc(oldobj, hp, sp);
#else  /* GENERIC_GGC */
	    newobj =  generic_gc(oldobj, hp, sp);
#endif /* GENERIC_GGC */
	    sp = gcsp;
	    hp = heapp;
	    UNLOCK_OLDSPACE();
	    *addr = functor_of(obj) = makefunctor(newobj);
	    LOCK_OLDSPACE();
	  } else {
	    q newfunct;
	    int k;
	    if(within_expd_space(obj)) {
	      UNLOCK_OLDSPACE();
	      newfunct = makefunctor(old_space_heapp);
	      k = arityof(f);
	      old_space_heapp += k+1;
	      *addr = functor_of(obj) = newfunct;
	      functor_of(newfunct) = f;
	      LOCK_OLDSPACE();
	    } else {
	      newfunct = makefunctor(hp);
	      k = arityof(f);
	      hp += k+1;
	      UNLOCK_OLDSPACE();
	      *addr = functor_of(obj) = newfunct;
	      LOCK_OLDSPACE();
	      functor_of(newfunct) = f;
	      /*
	      if(within_old_space(addr)){
		gc_push_rmset(addr);
	      }
	      */
	    }
	    do {
	      k--;
	      UNLOCK_OLDSPACE();
	      reserve_copy(arg(obj,k), arg(newfunct,k), sp, max);
	      LOCK_OLDSPACE();
	    } while (k > 0);
	  }
	} else {
	  /*
	  printf("addr %x func %x \n", *addr ,f);
	  */
	  UNLOCK_OLDSPACE();
	  *addr = f;
	  LOCK_OLDSPACE();
        }
      } else {
	UNLOCK_OLDSPACE();
	*addr = obj;
	LOCK_OLDSPACE();
	/*
	if(within_old_space(addr) && within_to_space(obj)){
	  gc_push_rmset(addr);
	}
	*/
      }
      break;
    }
    if(within_old_space(addr))  gc_push_rmset(addr);
  }
  gcsp = sp;
  return hp;
}
#else  /* GGC2 */
static q *
copy_terms(hp, ntop, otop, nsize, osize, sp, max)
     q *hp;
     q *ntop, *otop;
     unsigned long nsize, osize;
     q **sp, **max;
{
  declare_globals;
  while (sp > gcstack) {
    q *addr = *--sp;
    q obj = *addr;
  loop:
#ifdef SHM
          if ( is_shma(obj) ) {
            *addr = obj;
            if ( ptagof(obj) != ATOMIC ) {
              push_shm_stack(addr,shm_sp,shm_gcmax);
            }
            continue;
          }
#endif
    switch (ptagof(obj)) {
    case ATOMIC:
      *addr = obj;
      break;
    case VARREF:
      {
	q value;
      deref:
	value = derefone(obj);
	switch (ptagof(value)) {
	case VARREF:
	  if (derefone(value) == obj) {
	    if (value == obj) {
	      if (within_new_space(addr)) {
		*addr = derefone(obj) = makeref(addr);
	      } else {
		*addr = derefone(obj) = *hp = makeref(hp);
		hp++;
	      }
	    } else {
	      struct susprec *s;
	      /*
	      if(value > obj) {
		s = suspp(value);
	      } else {
		s = suspp(obj);
	      }
	      */
	      s = suspp(value);
	      if (is_generator_susp(s->u)) {
		struct generator_susp *gsusp = generator_suspp(s);
		q newvar = *addr = derefone(obj) = makeref(hp);
		hp++;
		{
		  struct generator_susp *newgsusp = generator_suspp(hp);
		  hp += sizeof(struct generator_susp) / sizeof(q);
		  derefone(newvar) = makeref(newgsusp);
		  newgsusp->backpt = makeref(newvar);
		  {
		    struct generator_object *oldobj =
		      untag_generator_susp(gsusp->u.o);
		    q newplace = (q)(oldobj->method_table);
		    if(!isstruct(newplace)) {
		      /* not yet copied */
		      struct generator_object *newobj
			= (struct generator_object *)
			  generic_gc(oldobj, hp, sp);
		      sp = gcsp;
		      hp = heapp;
		      oldobj->method_table = 
			(struct generator_object_method_table *)
			  makefunctor(newobj);
		      newgsusp->u.o = tag_generator_susp(newobj);
		    } else {
		      /* already copied */
		      newgsusp->u.o =
			tag_generator_susp(functorp(newplace));
		    }
		  }
		}
	      } else {
		struct hook *second_hook = s->u.first_hook.next;
		struct hook *h = second_hook;
		struct hook dummy;
		struct hook *last = &dummy;
		union goal_or_consumer lastu;
		q newvar;

		/* make a new variable, anyway */
		newvar = *addr = derefone(obj) = *hp = makeref(hp);
		hp++;
		lastu.l = 0;

		do {
		  union goal_or_consumer u;
		  u = h->u;
		  if (u.l != 0) {
		    union goal_or_consumer nu;
		    nu.l = 0;
		    if (!is_consumer_hook(u)) {
		      /* suspended goal */
		      if (u.g->pred == 0) {
			nu.g = u.g->next;
		      } else if (!isref(u.g->next)) {
			nu.g = u.g;
			copy_one_goal(nu.g, sp, max, 1);
		      } else {
			goto not_a_valid_hook;
		      }
		    } else {
		      /* consumer object */
		      q newplace = (q)(untag_consumer_hook(u.o)->method_table);
		      if (isstruct(newplace)) {
			nu.o = tag_consumer_hook(functorp(newplace));
		      } else {
			struct consumer_object *newobj =
			  (struct consumer_object *)
			    generic_gc(untag_consumer_hook(u.o), hp, sp);
			sp = gcsp;
			hp = heapp;
			untag_consumer_hook(u.o)->method_table =
			  (struct consumer_object_method_table *)
			    makefunctor(newobj);
			nu.o = tag_consumer_hook(newobj);
		      }
		    }
		    if (lastu.l != 0) {
		      struct hook *nh = (struct hook *)hp;
		      hp += sizeof(struct hook)/sizeof(q);
		      nh->u = lastu;
		      last->next = nh;
		      last = nh;
		    }
		    lastu = nu;
		  }
		not_a_valid_hook:
		  h = h->next;
		} while (h != second_hook);
		if (lastu.l != 0) {
		  struct susprec *ns = (struct susprec *)hp;
		  hp += sizeof(struct susprec)/sizeof(q);
		  last->next = &ns->u.first_hook;
		  ns->backpt = newvar;
		  ns->u.first_hook.next = dummy.next;
		  ns->u.first_hook.u = lastu;
		  derefone(newvar) = (q)ns;
		}
	      }
	    }
	  } else if (within_old_space(value)) {
	    obj = value;
	    goto deref;
	  } else {
	    *addr = value;
#ifdef SHM
	    if ( is_shma(value) ) push_shm_stack(addr,shm_sp,shm_gcmax);
#endif
	  }
	  break;
	case CONS:
	  if (within_new_space(value)) {
	    *addr = makeref(&cdr_of(value));
	  } else {
	    obj = value;
	    goto cons_case;
	  }
	  break;
	case ATOMIC:
	  *addr = value;
	  break;
	default: /* FUNCTOR */
	  obj = value;
	  goto functor_case;
	}
      }
      break;
    case CONS:
    cons_case:
      if (within_old_space(obj)) {
	q cdr = cdr_of(obj);
	if (!isstruct(cdr) || !within_new_space(cdr)) {
	  q newcons = makecons(hp);
	  hp += 2;
	  reserve_copy(car_of(obj), car_of(newcons), sp, max);
	  *addr = cdr_of(obj) = newcons;
	  if (isatomic(cdr)) {
	    cdr_of(newcons) = cdr;
	  } else {
	    if (cdr == makeref(&cdr_of(obj))) {
	      cdr_of(newcons) = makeref(&cdr_of(newcons));
	    } else {
	      addr = &cdr_of(newcons);
	      obj = cdr;
	      goto loop;
	    }
	  }
	} else {
	  *addr = cdr;
	}
      } else {
	*addr = obj;
      }
      break;
    default: /* FUNCTOR */
    functor_case:
      if (within_old_space(obj)) {
	q f = functor_of(obj);
	if(!isstruct(f)){
	  if(isref(f)) {
	    struct data_object *oldobj
	      = (struct data_object *)functorp(obj);
	    q *newobj;
	    newobj = generic_gc(oldobj, hp, sp);
	    sp = gcsp;
	    hp = heapp;
	    *addr = functor_of(obj) = makefunctor(newobj);
	  } else {
	    q newfunct = makefunctor(hp);
	    int k = arityof(f);
	    hp += k+1;
	    *addr = functor_of(obj) = newfunct;
	    functor_of(newfunct) = f;
	    do {
	      k--;
	      reserve_copy(arg(obj,k), arg(newfunct,k), sp, max);
	    } while (k > 0);
	  }
	} else {
	  *addr = f;
	}
      } else {
	*addr = obj;
      }
      break;
    }
  }
  gcsp = sp;
  return hp;
}
#endif /* GGC2 */
#ifdef GGC2
struct goalrec *copy_one_queue(qp, hp, nntop, notop, nnsize, nosize)
     struct goalrec *qp;
     q *hp;
     q *nntop, *notop;
     unsigned long nnsize, nosize;
{
  declare_globals;
  struct goalrec *last, *next;

  unsigned long osize;
  q *otop;

  otop      = old_space_top;
  osize     = old_space_bytesize;

  /* Copy queue in reverse order */
  /* By this, variables will have better chance to be allocated */
  /* within the goal records or structures that'll be read after */
  /* their instantiation */

  /* First, reverse the goal queue */
  for (last=0; qp!=&goal_queue_tail; last=qp, qp=next) {
    next = qp->next;
    UNLOCK_OLDSPACE();
    qp->next = last;
    LOCK_OLDSPACE();
  }
  /* Then copy and rearrange the goal queue */
  qp = last;
  last = &goal_queue_tail;
  for (; qp != 0; qp=next) {
    next=qp->next;
#ifdef SHM
    if ( is_shma(qp) ) {
        qp->next = last;
        last = qp;
        continue;
    }
#endif
    copy_one_goal(qp, gcsp, gcmax, 0);
    hp = copy_terms(hp, nntop, notop, nnsize, nosize, gcsp, gcmax);

    UNLOCK_OLDSPACE();
    qp->next = last;
    LOCK_OLDSPACE();
    last = qp;
  }

  heapp = hp;

  return last;
}
#else  /* GGC2 */
struct goalrec *copy_one_queue(qp, hp, ntop, otop, nsize, osize)
     struct goalrec *qp;
     q *hp;
     q *ntop, *otop;
     unsigned long nsize, osize;
{
  declare_globals;
  struct goalrec *last, *next;

  /* Copy queue in reverse order */
  /* By this, variables will have better chance to be allocated */
  /* within the goal records or structures that'll be read after */
  /* their instantiation */

  /* First, reverse the goal queue */
  for (last=0; qp!=&goal_queue_tail; last=qp, qp=next) {
    next = qp->next;
    qp->next = last;
  }
  /* Then copy and rearrange the goal queue */
  qp = last;
  last = &goal_queue_tail;
  for (; qp != 0; qp=next) {
    next=qp->next;
#ifdef SHM
    if ( is_shma(qp) ) {
        qp->next = last;
        last = qp;
        continue;
    }
#endif
    copy_one_goal(qp, gcsp, gcmax, 0);
    hp = copy_terms(hp, ntop, otop, nsize, osize, gcsp, gcmax);
    qp->next = last;
    last = qp;
  }
  heapp = hp;
  return last;
}
#endif /* GGC2 */

static struct goalrec *collect_garbage(qp)
     struct goalrec *qp;
{
  declare_globals;
  int k;

#ifdef GGC2
  q *allocp, *notop, *nntop;
  unsigned long nosize, nnsize;
#else  /* GGC2 */
  q *allocp, *ntop, *otop;
  unsigned long nsize, osize;
#endif /* GGC2 */
  struct prioqrec *pq = prioq.next;

#ifdef GGC2
  unsigned long osize;
  q *otop;

  otop      = old_space_top;
  osize     = old_space_bytesize;
#endif /* GGC2 */

#ifdef DIST
  if (node_wtc == 0) {
    fatal("invalid WTC in gc");
  }
#endif

  if (gctimes==0) {
    /* allocate GC stack on first GC */
    gcstack_size = GCSTACKSIZE;
    gcstack      = (q**)malloc_check(gcstack_size*sizeof(q*));
    gcsp         = gcstack;
    gcmax        = gcstack+gcstack_size;
#ifdef SHM
    shm_gcstack_size = GCSTACKSIZE;
    shm_gcstack = (q**)malloc(shm_gcstack_size*sizeof(q*));
    shm_sp = shm_gcstack;
    shm_gcmax = shm_gcstack+shm_gcstack_size;
  } else {
    shm_sp = shm_gcstack;
#endif
  }

#ifdef GGC2
    rmset_size  = gcstack_size;
    new_rmset   = (q**)malloc_check(rmset_size*sizeof(q*));
    new_rmsp    = new_rmset;
    new_rmsmax  = new_rmset + rmset_size;
#endif /* GGC2 */


#ifdef SHM
  /* copy into Shared-memory Generator hook data */
  {
    TADDRtbl* sptr = &ADDRtbl;
    TADDRtbl* nptr;
    sptr = &ADDRtbl;
    for(sptr=sptr->next;sptr!=&ADDRtbl;sptr=nptr) {
      nptr = sptr->next;
      switch(ptagof(sptr->localA)) {
      case CONS:
      case FUNCTOR: { /* generator hook */
	struct generator_object* addi;
	Shvar* objp;
	q temp;
  Re_try:
	temp = derefone(sptr->globalA);
	if ( !isref(temp) ) { break; }
	if ( derefone(temp) != (q)sptr->globalA ) {
	  sptr->globalA = (q*)temp; goto Re_try;
	}
	addi = n_lock(((q)sptr->globalA),temp);
	if ( derefone(sptr->globalA) != temp ) { goto Re_try; }
	objp = (Shvar*)untag_generator_susp(addi);
	if ( is_genhook(objp->chain)) {
	  q tempg;
	  shm_arg_copy(&sptr->localA,&tempg);
	  klic_barrier();
	  *(sptr->globalA) = tempg;
	  free_local_tbl(sptr);
	} else {
	  n_unlock(temp,addi);
	}
      }
      }
    }
  }
#endif
#ifdef GGC2
  allocp = nntop = heapp = heaptop = new_new_space_top;
  notop  = new_old_space_top;
  real_heapbytesize = nnsize = new_new_space_bytesize;
  nosize = new_old_space_bytesize;
  real_heaplimit = allocp + new_new_space_size;

  if (interrupt_off) heaplimit = real_heaplimit;
  else heaplimit = 0;
  heapbottom = real_heaplimit+incrementsize;

  for (k=0; k<num_gc_hooks; k++) {
    allocp = gc_hook_table[k](allocp, nntop, notop, nnsize, nosize);
  }

  for(; pq->prio >= 0; pq = pq->next) {
    pq->q = copy_one_queue(pq->q, allocp, nntop, notop, nnsize, nosize);
    allocp = heapp;
  }
  qp = copy_one_queue(qp, allocp, nntop, notop, nnsize, nosize);
  /*
  printf("CP %d , SUSP %d , RES %d\n",copied_susp,suspensions,resumes);
  */
#else  /* GGC2 */
  allocp = ntop = new_space_top;
  otop = old_space_top;
  real_heapbytesize = nsize = new_space_size;
  osize = old_space_size;
  real_heaplimit = allocp+heapsize;
  if (interrupt_off) heaplimit = real_heaplimit;
  else heaplimit = 0;
  heapbottom = real_heaplimit+incrementsize;

  for (k=0; k<num_gc_hooks; k++) {
    allocp = gc_hook_table[k](allocp, ntop, otop, nsize, osize);
  }

  for(; pq->prio >= 0; pq = pq->next) {
    pq->q = copy_one_queue(pq->q, allocp, ntop, otop, nsize, osize);
    allocp = heapp;
  }
  qp = copy_one_queue(qp, allocp, ntop, otop, nsize, osize);

#endif /* GGC2 */

#ifdef SHM
  {
    TADDRtbl* sptr = &ADDRtbl;
    TADDRtbl* nptr;
    q *hp = heapp;
    sptr = &ADDRtbl;
    for(sptr=sptr->next;sptr!=&ADDRtbl;sptr=nptr) {
      nptr = sptr->next;
      switch(ptagof(sptr->localA)) {
      case CONS:
      case FUNCTOR: { /* generator hook but anybody reqested */
        push_gc_stack((q*)&sptr->localA,gcsp,gcmax);
        hp = copy_terms(hp, ntop, otop, nsize, osize, gcsp, gcmax);
        push_shm_stack(&sptr->globalA,shm_sp,shm_gcmax);
        break;
      }
      case ATOMIC: { /* genarator object (distributed interface) */
	q wk = (q)untag_local(sptr->localA);
	if ( !derefone(wk) ) { /* consumer */
	  q top = (q)&(sptr->localA);
	  derefone(wk) = top;
	  derefone(top) = wk;
	  push_gc_stack(&top,gcsp,gcmax);
/* patch for debugging of hirata problem */
	  hirata_bug1 = 1;
	  hp = copy_terms(hp, ntop, otop, nsize, osize, gcsp, gcmax);
	  hirata_bug1 = 0;
	  wk = derefone(top);
	  if ( wk != top ) {
	    sptr->localA = (q*)tag_local(wk);
	    derefone(wk) = 0;
            push_shm_stack(&sptr->globalA,shm_sp,shm_gcmax);
          } else goto REM_HOOK;
	  break;
	} else { /* generator */
	  push_gc_stack(&wk,gcsp,gcmax);
	  hp = copy_terms(hp, ntop, otop, nsize, osize, gcsp, gcmax);
	  sptr->localA = (q*)tag_local(wk);
          push_shm_stack(&sptr->globalA,shm_sp,shm_gcmax);
	  break;
	}
      }
      default: { /* normal goal */
	struct goalrec* wqp = (struct goalrec*)sptr->localA;
	if ( !wqp ) { /* skip */
	} else if ( !wqp->pred ) {
	  sptr->localA = (q*)wqp->next;
	} else if ( isint(wqp->next) ) {
	  copy_one_goal(wqp, gcsp, gcmax,1);
	  sptr->localA = (q*)wqp;
	  hp = copy_terms(hp, ntop, otop, nsize, osize, gcsp, gcmax);
	  if ( isref(sptr->globalA) ) {
	    q ww;
	    while (1) {
	      ww = derefone(sptr->globalA);
	      if ( isref(ww) ) {
		if ( (q)sptr->globalA == derefone(ww) ) break;
		else {
		  sptr->globalA = (q*)ww;
		}
	      } else break;
	    }
	  }
	  push_shm_stack(&sptr->globalA,shm_sp,shm_gcmax);
	} else {
	REM_HOOK:
	  sptr->localA = 0;
          /* removes a hook record */
	  {
	    struct generator_object* addi;
	    q sv;
	    Shvar* objp;
	    Sinfo *hk,*bsi,*si;
	    q var = (q)sptr->globalA;
	    sv = derefone(var);
	    if ( !isref(sv) || derefone(sv) != var )  { goto REM_skip; }
	    addi = n_lock(var,sv);
	    if ( derefone(var) != sv ) goto REM_skip;
	    objp = (Shvar*)untag_generator_susp(addi);
	    hk = objp->chain;
	    if ( hk->indp == sptr ) {
	      objp->chain = hk->next;
		  free_local_tbl(sptr);
	    } else {
	      for(bsi=hk,si=bsi->next;(si);bsi=si,si=si->next) {
		if ( si->indp == sptr ) {
		  bsi->next = si->next;
		  free_local_tbl(sptr);
		  break; }
	      }
	    }
	    n_unlock(sv,addi);
	  REM_skip:
	    ;
	  }
	}
      }
      }
    }
    heapp = hp;
  }
#endif

#ifdef GGC2
  /* THIS IS FOR TEMPORARY GGC EXPERIMENTS. 
     Must use old_suspensions and old_resumes. */
  copied_susp = suspensions-resumes;
#endif /* GGC2 */

#ifdef DEBUGLIB
  {
    struct suspended_goal_rec *sgl = suspended_goal_list;
    struct suspended_goal_rec **sgl_tail = &suspended_goal_list;
    struct goalrec *dead_goal = 0;

    q *hp = heapp;

    if (copied_susp != suspensions-resumes) {
      klic_fprintf(stderr,
		   "%d perpetually suspending goals found\n",
		   suspensions-resumes-copied_susp);
    }
    /* First, we will copy the surface of suspended goal list.
       This is needed to distinguish resumed goals and
       goals copied while copying other goals in this list */
    while (sgl != 0) {
      if (sgl->goal->pred == 0 ||
	  /* already copied */
	  !isref(sgl->goal->next)
	  /* or not resumed yet */
	  ) {
	struct suspended_goal_rec *newsgr =
	  (struct suspended_goal_rec *)hp;
	hp += sizeof(struct suspended_goal_rec)/sizeof(q);
	*sgl_tail = newsgr;
	newsgr->goal = sgl->goal;
	sgl_tail = &newsgr->next;
      }
      sgl = sgl->next;
    }
    *sgl_tail = 0;
    /* Next, we will copy the suspended goals */
    sgl = suspended_goal_list;
    while (sgl != 0) {
#ifdef GGC2
      if (within_old_space(sgl->goal) && sgl->goal->pred !=0 ) {
	/* OLD SPACE */

      } else  if (sgl->goal->pred != 0) {
	/* not copied yet */
	copy_one_goal(sgl->goal, gcsp, gcmax, 0);
	hp = copy_terms(hp, nntop, notop, nnsize, nosize, gcsp, gcmax);
	dead_goal = sgl->goal;
      } else {
	sgl->goal = sgl->goal->next;
      }
      sgl = sgl->next;
#else  /* GGC2 */
      if (sgl->goal->pred != 0) {
	/* not copied yet */
	copy_one_goal(sgl->goal, gcsp, gcmax, 0);
	hp = copy_terms(hp, ntop, otop, nsize, osize, gcsp, gcmax);
	dead_goal = sgl->goal;
      } else {
	sgl->goal = sgl->goal->next;
      }
      sgl = sgl->next;
#endif /* GGC2 */
    }
    if (dead_goal != 0) {
      /* we have to make the dead goal look like a normal ready queue */
      extern Const struct predicate queue_empty_pred;
      ((struct goalrec *)hp)->pred = &queue_empty_pred;
      UNLOCK_OLDSPACE();
      dead_goal->next = (struct goalrec *)hp;
      LOCK_OLDSPACE();
      hp += sizeof(struct goalrec)/sizeof(q);
      /*
      printf("TRACE DEADLOCK\n");
      printf("DEAD_GOAL %x \n",*dead_goal);
      */
      trace_deadlock(dead_goal);
    }
    heapp = hp;
  }

#endif

  if (copied_susp != suspensions-resumes) {
    fatal("Perpetually suspending goal(s) found during GC");
  }

  for (k=0; k<num_after_gc_hooks; k++) {
    heapp = after_gc_hook_table[k](heapp);
  }
  return qp;
}

/*
  interface routine for copying one term
*/

#ifdef GGC2
q* copy_one_term(term, allocp, nntop, notop, nnsize, nosize)
     q *term;
     q *allocp, *nntop, *notop;
     unsigned long nnsize, nosize;
{
  declare_globals;
  push_gc_stack(term, gcsp, gcmax);
  return
    copy_terms(allocp, nntop, notop, nnsize, nosize, gcsp, gcmax);
}
#else  /* GGC2 */
q* copy_one_term(term, allocp, ntop, otop, nsize, osize)
     q *term;
     q *allocp, *ntop, *otop;
     unsigned long nsize, osize;
{
  declare_globals;
  push_gc_stack(term, gcsp, gcmax);
  return
    copy_terms(allocp, ntop, otop, nsize, osize, gcsp, gcmax);
}
#endif /* GGC2 */
/*
  for generic object
*/
q
general_gc(term, allocp, sp)
     q *term;
     q *allocp;
     q **sp;
{
  declare_globals;

  push_gc_stack(term, sp, gcmax);
#ifdef GGC2
  heapp = copy_terms(allocp, 
                                   new_new_space_top , new_old_space_top,
                                   new_new_space_size, new_old_space_size,
		                   sp, gcmax);
#else  /* GGC2 */
  heapp = copy_terms(allocp, new_space_top, old_space_top,
		     new_space_size, old_space_size,
		     sp, gcmax);
#endif /* GGC2 */
  return *term;
}
