/**********************************************************************/
/*                                                                    */
/*      program of utility.c                                          */
/*      Nomad200 utilities                                            */
/*                                                                    */
/*    Copyright (c) 1999  Fumio Mizoguchi                             */
/*                                                                    */
/**********************************************************************/
#include <stdio.h>
#include <math.h>
#include "Nclient.h"

#define Robot_radius 100
#define Panic_range 100
#define Goal_range 100


/* this table is used to convert infrared reading to unit of 1/10 inch */
static int Infrared_table[17] = {0, 20, 40, 60, 80, 100, 120, 140, 160, 180,
                                 200, 220, 240, 260, 280, 300, 320};

/* this is where we store the converted, fused sensor data */
/*static int Abs_sensor[16];*/

/* these varialbes are used to determine whether a subgoal/the goal is
   blocked */
static int old_x, old_y, old_th, oldt_v = 0, olds_v = 0;
static int total_turned = 0;
static int total_traveled = 0;
static int num_turned = 0;


/***** TURN_SENSOR_CONF_ON FUNCTION ***********************************/
void turn_sensor_conf_on (int which_sensor)
{
    /***** INTERNALDATA *****/
    int i;
    int sn_on[16] = {0,8,1,9,2,10,3,11,4,12,5,13,6,14,7,15};
    int sn_off[16] = {255,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
    int ir_on[16] = {0,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15};
    int ir_off[16] = {255,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
    

    /***** PROCESS *****/
    ac (200, 200, 0);
    if ((which_sensor == 1) || (which_sensor == 2)){
	conf_sn(1, sn_on);  
    }
    else{ 
	conf_sn(1, sn_off);
    }
    if ((which_sensor == 0) || (which_sensor == 2)){
	conf_ir(0, ir_on); 
    }
    else{
	conf_ir(0, ir_off);
    }

    /* set communication mask */
    /* first set all of them to zero */
    for (i=0; i<43; i++) {
	Smask[i] = 0;
    }
    
    if ((which_sensor == 1) || (which_sensor == 2)) {
	/* set the mask for front SN */
	for (i=17; i<=21; i++) {
	    Smask[i] = 1;
	}
	for (i=21; i<=32; i++) { /* i=29 if only the front ones */
	    Smask[i] = 1;
	}
    }
    
    if ((which_sensor == 0) || (which_sensor == 2)) {
	/* set the mask for all IR */
	for (i=1; i<=16; i++) {
	    Smask[i] = 1;
	}
    }
    
    /* then set the mask for the x, y, th, tu */
    for (i=34; i<38; i++) {
	Smask[i] = 1;
    }
    ct();
}
/***** TURN_SENSOR_CONF_ON FUNCTION ***********************************/


/***** TURN_SENSOR_CONF_OFF FUNCTION **********************************/
void turn_sensor_conf_off (void)
{
    /***** INTERNALDATA *****/
    int i;
    int sn_on[16] = {0,8,1,9,2,10,3,11,4,12,5,13,6,14,7,15};
    int sn_off[16] = {255,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
    int ir_on[16] = {0,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15};
    int ir_off[16] = {255,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
    

    /***** PROCESS *****/
    conf_sn(1, sn_off);
}
/***** TURN_SENSOR_CONF_OFF FUNCTION **********************************/


/***** UPDATE_SENSOR FUNCTION *****************************************/
void update_sensor (int which_sensor, int abs_sensor[16])
{
    int i, ir_dist;
    
    switch (which_sensor) {
    case 0: /* infrared sensor only */
	for (i=1; i<=16; i++) {
	    abs_sensor[i-1] = (int)((Infrared_table[State[i]]
				     +Infrared_table[State[i]+1])/2.0);
	}
	break;
    case 1: /* sonar sensor only */
	for (i=1; i<=16; i++) {
	    abs_sensor[i-1] = (int)(State[i+16]*10);
	}
	break;
    default: /* fusing infrared and sonar */
	for (i=1; i<=16; i++) {
	    if (State[i] < 14) { 
		/* infrared reading is not very reliable when is
		   reading 14 or 15 (max) */
		ir_dist = (int)((Infrared_table[State[i]]
				 +Infrared_table[State[i]+1])/2.0);
		if (ir_dist < State[i+16]*10){
		    abs_sensor[i-1] = ir_dist;
		}
		else{
		    abs_sensor[i-1] = (int)(State[i+16]*10);
		}
	    }
	    else{
		abs_sensor[i-1] = (int)(State[i+16]*10);
	    }
	}
	break;
    }
}
/***** END OF UPDATE_SENSOR FUNCTION **********************************/


/***** UPDATE_SENSOR2 FUNCTION ****************************************/
void update_sensor2(int which_sensor, int abs_sensor[16],
		    int abs_sensor2[16])
{
    /***** INTENRALDATA *****/
    int i, ir_dist, front;
    

    /***** PROCESS *****/
    switch (which_sensor) {
    case 0: /* infrared sensor only */
	for (i=1; i<=16; i++) {
	    abs_sensor[i-1] = (int)((Infrared_table[State[i]]
				 +Infrared_table[State[i]+1])/2.0);
	}
	break;
    case 1: /* sonar sensor only */
	for (i=1; i<=16; i++) {
	    abs_sensor[i-1] = (int)(State[i+16]*10);
	}
	break;
    default: /* fusing infrared and sonar */
	for (i=1; i<=16; i++) {
	    if (State[i] < 14) { 
		/* infrared reading is not very reliable when is
		   reading 14 or 15 (max) */
		ir_dist = (int)((Infrared_table[State[i]]
				 +Infrared_table[State[i]+1])/2.0);
		if (ir_dist < State[i+16]*10){
		    abs_sensor[i-1] = ir_dist;
		}
		else{
		    abs_sensor[i-1] = (int)(State[i+16]*10);
		}
	    }
	    else{
		abs_sensor[i-1] = (int)(State[i+16]*10);
	    }
	}
	break;
    }
    
    front = (State[36]-State[37])/225;
    if(front<0){
        front = front+16;
    }

    for(i=0; i<16; i++){
	abs_sensor2[i] = abs_sensor[(i+front)%16];
    }
}
/***** END OF UPDATE_SENSOR2 FUNCTION *********************************/


/***** BLOCKED_GOAL FUNCTION ******************************************/
int blocked_goal (int min_dist, int max_turning, int max_num_turn)
{
    
    total_traveled = abs(old_x-State[34])+abs(old_y-State[35]) 
      + total_traveled;
    total_turned = abs(old_th - State[36]) + total_turned;
    old_x = State[34];
    old_y = State[35];
    old_th = State[36];
    
    if (total_traveled >= min_dist) {
	total_traveled = 0;
    total_turned = 0;
	num_turned = 0;
	return(0);
    }
    else {
	if ((total_turned > max_turning) && 
	    (num_turned > max_num_turn)){
	    total_traveled = 0;
	    total_turned = 0;
	    num_turned = 0;
	    return(1);
	}
	else {
	    return(0);
	}
    }
}
/***** END OF BLOCKED_GOAL FUNCTION ***********************************/
