/***
    $B%f!<%6%$%s%?%U%'!<%9%7%9%F%`%5!<%P$G;HMQ$5$l$k(B
     $BBP(BKLIC$B@\B3MQ%W%m%0%i%`MQ%W%m%0%i%`!JAw?.MQ!K(B
        Copyright (c) 1999  Fumio Mizoguchi 
***/

/*KLIC$BMQ$N%5!<%P%W%m%0%i%`(B*/
import java.io.*;
import java.net.*;

class KlicSender implements Runnable{
    final int MAX_CHANNELS = 256; // $B:GBg%A%c%M%k?t(B
    KlicChannel channel[] = new KlicChannel[MAX_CHANNELS];  
    ServerSocket serversocket;
    Server server;
    Thread thread = null;
    int port = 17322;

    KlicSender(Server s){
	server = s;
	start();
    }

    public void start() {
        if (thread == null) {
            thread = new Thread(this);
            thread.start();
        }
    }
    
    public void stop() {
        if (thread != null) {
            thread.stop();
            thread = null;
        }
    }

    public void sendMessage(String message){
	int i;
        for (i = 1; i < MAX_CHANNELS; i++) {
            if (channel[i] != null && channel[i].socket != null) {
                channel[i].write(message);
            }
        }
    }

    public void run() {
	int i;
        try {
	    System.out.println("start klicSender "+port);
            serversocket = new ServerSocket(port);   // $B%a%$%s%5!<%P!<3+J|(B
            while (true) {                     // $B6u$$$F$$$k%A%c%M%k$rC5$9(B
                for (i = 1; i < MAX_CHANNELS; i++) {
                    if (channel[i] == null || channel[i].thread == null) {
                        break;
                    }
                }
                if (i == MAX_CHANNELS)      // $B:GBg$N%/%i%$%"%s%H?t$J$i=*N;(B
                  return;
                Socket socket = serversocket.accept();    // $B@\B3BT$A(B
                channel[i] = new KlicChannel(socket, this);// $B?7%A%c%M%k:n@.(B
            }
        } catch(IOException e) {
            System.out.println("Server Err!");
            return;
        }
    }

}
