/***
    $B%f!<%6%$%s%?%U%'!<%9%7%9%F%`%5!<%P$G;HMQ$5$l$k(B
       $BBP(BJava$B%W%m%0%i%`MQDL?.%W%m%0%i%`(B
        Copyright (c) 1999  Fumio Mizoguchi 
***/

/*$B3F%A%c%M%kMQ$N%5!<%P%W%m%0%i%`(B*/
import java.io.*;
import java.net.*;
import java.util.*;

public class Channel implements Runnable {
    Server server;             // $B%A%c%C%H%5!<%PK\BN(B
    Socket socket = null;      // $B%=%1%C%H(B
    BufferedReader input;      // $BF~NOMQ%9%H%j!<%`(B
    OutputStreamWriter output; // $B=PNOMQ%9%H%j!<%`(B
    public Thread thread;      // $B%A%c%M%k$r6nF0$9$k$?$a$N%9%l%C%I(B
    String handle;             // $B%/%i%$%"%s%H$N%O%s%I%k(B
    int id;

    // $B0z?t$O%A%c%M%kHV9f!"%=%1%C%H!"(BServer.
    Channel(Socket s, Server cs, int i) {
	server = cs;
	socket = s;
        id = i;
	start();
    }
    
    public void start() {
	thread = new Thread(this);
	thread.start();
    }
	
    public void stop() {
	thread = null;
    }

    // $B%/%i%$%"%s%H$XJ8;zNs$r=PNO$9$k(B
    synchronized void write(String s) {
	try {
	    output.write(s + "\0");
	    output.flush();
	} catch (IOException e) {
	    System.out.println("Write Err");
	    close(); // $B%(%i!<$r5/$3$7$?$i!"@\B3$r@ZCG$9$k(B
	}
    }
    synchronized void write2(String s) {
	try {
	    output.write(s);
	    output.flush();
	} catch (IOException e) {
	    System.out.println("Write Err");
	    close(); // $B%(%i!<$r5/$3$7$?$i!"@\B3$r@ZCG$9$k(B
	}
    }

    
    /*
     *  $B%A%c%M%k$N%a%$%s%k!<%A%s!#(B
     *  $B%/%i%$%"%s%H$+$i$NF~NO$r<u$1IU$1$k(B
     */
    public void run() {
	String s;
	try {
	    // $B%=%1%C%H$+$iF~=PNO%9%H%j!<%`$rF@$k(B
	    input = new BufferedReader(
                        new InputStreamReader(socket.getInputStream()));
	    output = new OutputStreamWriter(socket.getOutputStream());
	    // write("# $B$h$&$3$=!*(B Chat$B%5!<%P!<$X!%(B");   // $B4?7^$N0';"(B 
	    // write("# $B8fL>A0$rF~NO$7$F2<$5$$!%(B");      // $B%O%s%I%kL>EPO?(B
	    // handle = input.readLine();
	    // write("# $BEPO?CW$7$^$7$?!$(B"+ handle + "$BMM!%(B");
	    
	    while (thread != null) {    // $BF~NOBT$A$N%k!<%W(B 
		s = input.readLine();  // $BJ8;zNsF~NO$rBT$D(B
		if (s == null)  close();
                else {
		    // $BA4%/%i%$%"%s%H$K%V%m!<%I%-%c%9%H$9$k(B
		    // server.message(handle);
		    String time = getTime();
		    System.out.println(time + " , Channel Read Message "+s);
		    server.message(id,s);
		}
	    }
	} catch(IOException e) {
	    close(); // $B%(%i!<$r5/$3$7$?$i!"@\B3$r@ZCG$9$k(B
	}
    }
    
    
    // $B@\B3$r@ZCG$9$k(B
    public void close() {
	try {
	    input.close();     // $B%9%H%j!<%`$rJD$8$k(B
	    output.close();
	    socket.close();    // $B%=%1%C%H$rJD$8$k(B
	    socket = null;
//	    server.broadcast("# $B2s@~@ZCG(B :" + handle);
  	    stop();
	} catch(IOException e) {
	    System.out.println("Close Err");
	}
    }
    public String getTime() {
        Calendar now = Calendar.getInstance(TimeZone.getTimeZone("JST"));
	int hour = now.get(Calendar.HOUR);
	int min = now.get(Calendar.MINUTE);
	int sec = now.get(Calendar.SECOND);
	String s = hour+":"+min+":"+sec;
	return s;
    }
}








