/***
            $B@V30@~%;%s%54IM}%7%9%F%`(B
        Copyright (c) 1999  Fumio Mizoguchi 
***/

import java.awt.*;
import java.awt.event.*;
import java.io.*;
import java.net.*;
import java.util.*;

public class SensorChangeServer extends Frame implements Runnable
{
	private Thread heart;
	private Sensor sensor;
	private Acceptor acceptor;
	private Vector commList = new Vector();
	private SensorLabel[] sensors = new SensorLabel[ 42 ];
	private Object stopping = new Object();

	public static void main( String[] args )
	{
		try
		{
			Sensor sensor = new Sensor();
			SensorChangeServer server = new SensorChangeServer( sensor );
			server.start();
			server.setVisible( true );
		}
		catch( Exception ex )
		{
			ex.printStackTrace();
		}
	}

	protected class SensorLabel extends Label
	{
		private boolean activated = false;

		public SensorLabel( int number )
		{
			super( String.valueOf( number ), CENTER );
			setFont( new Font( "TimesRoman", Font.BOLD, 20 ) );
			setForeground( Color.white );
			setBackground( Color.black );
		}

		public void setValue( int value )
		{
			if ( value != 0 )
			{
				setForeground( Color.black );
				setBackground( Color.yellow );
			}
			else
			{
				setForeground( Color.white );
				setBackground( Color.black );
			}
		}
	}

	protected class Acceptor implements Runnable
	{
		private ServerSocket server;
		private Thread acceptor;
		private Object stopping = new Object();

		public Acceptor() throws IOException
		{
			server = new ServerSocket( 14142 );
		}

		public void close() throws IOException
		{
			server.close();
		}

		public void start()
		{
			if ( acceptor == null )
			{
				acceptor = new Thread( this );
				acceptor.start();
			}
		}

		public void stop()
		{
			synchronized( stopping )
			{
				acceptor.interrupt();
				try
				{
					stopping.wait();
				}
				catch( InterruptedException ex )
				{
					ex.printStackTrace();
				}
				acceptor = null;
				stopping.notifyAll();
			}
		}

		public void run()
		{
			while( acceptor != null && acceptor.isAlive() )
			{
				try
				{
					Thread.sleep( 100 );
					Socket socket = server.accept();
					SensorChangeServer.this.addCommunicator( new Communicator( socket ) );
				}
				catch( InterruptedException ex )
				{
					synchronized( stopping )
					{
						stopping.notifyAll();
						try
						{
							stopping.wait();
						}
						catch( InterruptedException ex2 )
						{
							ex2.printStackTrace();
						}
					}
				}
				catch( Exception ex )
				{
					ex.printStackTrace();
				}
			}
		}
	}

	protected class Communicator
	{
		private Socket socket;
		private BufferedOutputStream output;

		public Communicator( Socket socket ) throws IOException
		{
			this.socket = socket;
			output = new BufferedOutputStream( socket.getOutputStream() );
		}

		public void close() throws IOException
		{
			output.close();
			socket.close();
		}

		public void sendTagNumber( int number ) throws IOException
		{
			byte[] buffer = String.valueOf( number ).getBytes();
			output.write( buffer );
			output.write(0);
			output.flush();
		}
		public void sendTagNumber( int number , int value) throws IOException
		{
      		        String Message = "p "+number+" "+value;
			byte[] buffer = Message.getBytes();
			output.write( buffer );
			output.write(0);
			output.flush();
		}
	}

	public SensorChangeServer( Sensor sensor ) throws IOException
	{
		this.sensor = sensor;
		acceptor = new Acceptor();
		Panel p = new Panel();
		p.setLayout( new GridLayout( 21, 2 ) );
		for( int i = 0 ; i < sensors.length ; ++i )
		{
			sensors[i] = new SensorLabel(i);
			p.add( sensors[i] );
		}
		add( "Center", p );
		pack();
		WindowListener windowListener = new WindowAdapter()
		{
			public void windowClosing( WindowEvent ev )
			{
				try
				{
					SensorChangeServer.this.setVisible( false );
					SensorChangeServer.this.close();
				}
				catch( Exception ex )
				{
					ex.printStackTrace();
				}
			}
		};
		addWindowListener( windowListener );
	}

	public void close() throws IOException
	{
		stop();
		acceptor.close();
		Enumeration e = commList.elements();
		while( e.hasMoreElements() )
		{
			( ( Communicator )e.nextElement() ).close();
		}
	}


	public void restart() {
	    try {
		Sensor sensor = new Sensor();
		this.sensor = sensor;
		this.sensor.start();
		System.out.println("Restart start!");
	    }
	    catch( Exception ex )
	      {
		  System.out.println("Restart missed!!");
		  ex.printStackTrace();
	      }	
	}
	    
	public void start()
	{
		sensor.start();
		acceptor.start();
		if ( heart == null )
		{
			heart = new Thread( this );
			heart.start();
		}
	}

	public void stop()
	{
		synchronized( stopping )
		{
			heart.interrupt();
			try
			{
				stopping.wait();
			}
			catch( InterruptedException ex )
			{
				ex.printStackTrace();
			}
			heart = null;
			stopping.notifyAll();
		}
	}

	public void addCommunicator( Communicator comm )
	{
		commList.addElement( comm );
	}

	public void removeCommunicator( Communicator comm )
	{
		commList.removeElement( comm );
	}

	protected void sendTagNumber( int number ) throws IOException
	{
		Enumeration e = ( ( Vector )commList.clone() ).elements();
		while( e.hasMoreElements() )
		{
			Communicator comm = ( Communicator )e.nextElement();
			try
			{
				comm.sendTagNumber( number );
			}
			catch( IOException ex )
			{
				removeCommunicator( comm );
				comm.close();
			}
		}
	}

	protected void sendTagNumber( int number, int value ) throws IOException
	{
		Enumeration e = ( ( Vector )commList.clone() ).elements();
		while( e.hasMoreElements() )
		{
			Communicator comm = ( Communicator )e.nextElement();
			try
			{
				comm.sendTagNumber( number, value );
			}
			catch( IOException ex )
			{
				removeCommunicator( comm );
				comm.close();
			}
		}
	}

	public void run()
	{
		int[] values = new int[ sensors.length ];
		System.out.println(sensors.length);
		while( heart != null && heart.isAlive() )
		{
			try
			{
				Thread.sleep( 100 );
				if(sensor.err) {
				    restart();
				    Thread.sleep( 2000 );
				}
				for( int i = 0 ; i < values.length ; ++i )
				{
					int newValue = sensor.getValue(i);
					// System.out.println("check "+i+"  "+newValue);
					if ( values[i] != newValue )
					{
					    if(i>=40){
						sendTagNumber(i,newValue);
					    }
					    else if ( values[i] == 0 )
					      {
						  sendTagNumber(i);
					      }
					    sensors[i].setValue( newValue );
					}
					values[i] = newValue;
				}
			}
			catch( InterruptedException ex )
			{
				synchronized( stopping )
				{
					stopping.notifyAll();
					try
					{
						stopping.wait();
					}
					catch( InterruptedException ex2 )
					{
						ex2.printStackTrace();
					}
				}
			}
			catch( Exception ex )
			{
				ex.printStackTrace();
			}
		}
	}
}
