/***
             WebIO$B@\B3MQ%W%m%0%i%`(B
        Copyright (c) 1999  Fumio Mizoguchi 
***/
import java.net.*;
import java.io.*;

public class Sensor implements Runnable
{
	private Thread heart;
	protected int[] values;
	private Socket socket;
	private DataInputStream input;
	private DataOutputStream output;
	private Object stopping = new Object();
	public boolean err = false;

	public Sensor() throws IOException
	{
		socket = new Socket( "192.168.1.53", 2042 );
		input = new DataInputStream( socket.getInputStream() );
		output = new DataOutputStream( socket.getOutputStream() );
	}

	public void close() throws IOException
	{
		stop();
		output.close();
		input.close();
		socket.close();
	}

	public void start()
	{
		if ( heart == null )
		{
			heart = new Thread( this );
			heart.start();
		}
	}

	public void stop()
	{
		synchronized( stopping )
		{
			heart.interrupt();
			try
			{
				stopping.wait();
			}
			catch( InterruptedException ex )
			{
				ex.printStackTrace();
			}
			heart = null;
			stopping.notifyAll();
		}
	}

	public int getValue( int number )
	{
		return( values != null ? values[ number ] : 0 );
	}

	private int readValue() throws IOException
	{
		int length = input.readUnsignedByte();
		switch( length )
		{
		case 1:
			return( ( int )input.readByte() );
		case 2:
			return( ( int )input.readShort() );
		default:
			byte[] empty = new byte[ length ];
			input.read( empty );
			return(0);
		}
	}

	public void run()
	{
		byte[] request = { -6, 6, 63, -6, 4 };
		while( heart != null && heart.isAlive() && err == false )
		{
			try
			{
				Thread.sleep( 200 );
				output.write( request );
				output.flush();
				input.readByte();
				input.readByte();
				int length = input.readUnsignedShort();
				if ( values == null )
				{
					values = new int[ length ];
				}
				for( int i = 0 ; i < length ; ++i )
				{
					values[i] = readValue();
					//System.out.println("length = "+length+" ; values["+i+"] = "+values[i]);
					//if(values[i] > 0)  stop();
				}
				input.readByte();
				input.readByte();
			}
			catch( InterruptedException ex )
			{
			    System.out.println("err 1");
			    err = true;
				synchronized( stopping )
				{
					stopping.notifyAll();
					try
					{
						stopping.wait();
					}
					catch( InterruptedException ex2 )
					{
						ex2.printStackTrace();
					}
				}
			}
			catch( Exception ex )
			{
				ex.printStackTrace();
			    System.out.println("err 2");
			    err = true;
			}
		}
	}
}
