/* %%%                                      %%%
 * %%%   scoutctrl_scout.c                  %%%
 * %%%   Copyright (C) 1999 Fumio Mizoguchi %%%
 * %%%                                      %%%
 */

#include <math.h>
#include <sys/times.h>
#include "Nclient.h"
#include "scoutctrl_extern.h"

/*   for scout  */
#define Scout_RIGHT(trans, steer)  (trans+(int)((double)steer*368.61/3600.0))
#define Scout_LEFT(trans, steer)   (trans-(int)((double)steer*368.61/3600.0))
#define scout_vm(trans, steer) vm(Scout_RIGHT(trans, steer), Scout_LEFT(trans, steer), 0)

#define PI 3.1415926

extern FILE *fp;
int bblin = 0;

void nomad_setup(void)
{
#ifdef DIRECT
    strcpy(ROBOT_MACHINE_NAME,globals.Nserv);
#else
//    SERV_TCP_PORT = globals.nport;
    SERV_TCP_PORT = Nserver.port;
    strcpy(SERVER_MACHINE_NAME, globals.Nserv);
#endif


    connect_robot(1, MODEL_SCOUT, "/dev/ttya", 9600);

//    connect_robot(1);


    sleep(1);

    turn_sonar_on();

    mask_set();

}

void scout_move(int velocity_v, int velocity_t)
{

    scout_vm(velocity_v,velocity_t);
}

void show_status(void)
{
    int i;
//    gs();
    fprintf(stderr,"Sonar state : ");
    for(i=17; i<=32; i++){
	fprintf(stderr,"%d ",State[i]);
    }
    fprintf(stderr,"\n");
    fprintf(stderr,"Power state : %x\n",State[41]);

    

}


void turn_sonar_on(void)
{
    int i, sn_order[16];

    for(i=0;i<16;i++)   sn_order[i] = i;
    sn_order[16] = 255;

    conf_sn(1, sn_order);
}

void mask_set(void)
{
    int i;

    Smask[0] = 3;

    for(i=1; i<43; i++)    Smask[i] = 0;

    for(i=17; i<33; i++)   Smask[i] = 1;
    for(i=34; i<38; i++)   Smask[i] = 1;
    ct();
}











