/* %%%                                      %%%
 * %%%   scoutctrl_main.c                   %%%
 * %%%   Copyright (C) 1999 Fumio Mizoguchi %%%
 * %%%                                      %%%
 */

#include "scoutctrl_extern.h"
#include "Nclient.h"

typedef struct tcp_server_data Tcp_Server_Data;

void main(void)
{
    Tcp_Server_Data tcp_serv;
    opt_ZERO();
    getdata(globals.file);
    nomad_setup();

    if(tcp_server_init(scout.port,&tcp_serv)){
	comm(&tcp_serv);
    }
}

void opt_ZERO(void)
{
    globals.port = 20000;
    globals.verbose = FALSE;
    globals.host = NULL;
    globals.file = "../communication.dat";
    globals.nomad = TRUE;
    globals.nport = DEFAULT_NPORT;
    globals.Nserv = "192.168.1.24";
}



void getdata(char *filename)
{
    FILE *fp;
    char buff[256],*ap,*pp;
    int  i;

    if((fp = fopen(filename,"r")) == NULL){
	fprintf(stderr, "file cannot open. [%s]\n",filename);
	exit(1);
    }
    
    
    while(fgets(buff,256,fp) != NULL){
	if((ap = strchr(buff,':')) == NULL) continue; 
	*ap = '\0';
	ap++;
	if((pp = strchr(ap,':')) == NULL) continue;
	*pp = '\0';
	pp++;

	if(streq(buff,"scout")){
	    strcpy(scout.label,buff);
	    strcpy(scout.IP,ap);
	    scout.port = atoi(pp);
	}
	else if(streq(buff,"image")){
	    strcpy(image.label,buff);
	    strcpy(image.IP,ap);
	    image.port = atoi(pp);
	}
	else if(streq(buff,"hoge_read")){
	    strcpy(hoge_read.label,buff);
	    strcpy(hoge_read.IP,ap);
	    hoge_read.port = atoi(pp);
	}
	else if(streq(buff,"hoge_write")){
	    strcpy(hoge_write.label,buff);
	    strcpy(hoge_write.IP,ap);
	    hoge_write.port = atoi(pp);
	}
	else if(streq(buff,"Nserver")){
	    strcpy(Nserver.label,buff);
	    strcpy(Nserver.IP,ap);
	    Nserver.port = atoi(pp);
	}
	for(i=0; i<256; i++) buff[i] = '\0';
    }

}


