/* %%%                                      %%%
 * %%%   scoutctrl_extern.h                 %%%
 * %%%   Copyright (C) 1999 Fumio Mizoguchi %%%
 * %%%                                      %%%
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/types.h>
#include "socket.h"

/*** definition of macro ***/
#define DEFAULT_PORT 20000
#define DEFAULT_CONF "comm.dat"
#define DEFAULT_NPORT 7020
#define TRUE         1
#define FALSE        0
#define SKIP         3

#define NOMAD_LIMIT 10

#define LEFT_FWD   0
#define LEFT       1
#define LEFT_BCK   2
#define FORWARD    3
#define BACK       4
#define RIGHT_FWD  5
#define RIGHT      6
#define RIGHT_BCK  7
#define MIN_DIST   10
#define SP         2

#define streq(a,b) (!strcmp(a,b))

/* protocol */
#define GO    1
#define DATA  2
#define FAIL  3
#define FIN   4
#define STOP  5
#define OK    6
#define END   7
#define START 8
#define EXIT  9
#define INIT  10

/*** definition of struct ***/
struct p_data{
    int x;         /* $B:BI8(Bx */
    int y;         /* $B:BI8(By */
    int scale;     /* $B2hA|$NBg$-$5(B */
    char *label;   /* $B9T$-@h%i%Y%k(B */
    int flag;      /* $BF0:n$NM-L5%U%i%0(B */
};

struct globe{
    int verbose;
    int port;
    int nport;
    int nomad;
    char *host;
    char *file;
    char *Nserv;
};

struct conf_data{
    char label[10];
    char hostname[64];
    int  port;
    struct conf_data *next;
    struct conf_data *prev;
};

struct conf_data2{
    char *label;
    char *hostname;
    int port;
};

struct command_data{
    char *cmd;
    int param[5];
};

struct Point{
    int x;
    int y;
};

typedef struct{
    char label[32];
    char IP[16];
    int  port;
}Comm_Data;


/*** definition of global valueable ***/
int n_node;
int c_node;

struct globe globals;
struct conf_data *conf_start;
char   *path[BUFSIZ]; /* $BM6F3$5$;$k%+%a%i$N=gHV!JJ8;zNs!K(B */
                      /* current_node$B$,(B0$B$N$H$-$O8=:_$N%N!<%I(B */

/*** definition of the prototype of functions ***/
void option(int,char**);
void opt_ZERO(void);
int read_conf_file(void);
struct conf_data *conf_alloc(struct conf_data*);
struct conf_data2 *conf_lookup(char*,struct conf_data2*);

Comm_Data scout,image,hoge_read,hoge_write,Nserver;

int nomad(struct tcp_client_data*);
void nomad_setup(void);
void mask_set(void);
void turn_sonar_on(void);
int choose_action(int,int);
int direction(struct tcp_client_data*);
int  shortest_sonar(int,int);
int  absv(struct Point*);

void move(int,int,int);

int interpret(char*,struct p_data*);
char *reply_msg(int);
int action(int, struct p_data*);
int search_path(char*);
void getdata(char *);











