/* %%%                                      %%%
 * %%%   scoutctrl_communication.c          %%%
 * %%%   Copyright (C) 1999 Fumio Mizoguchi %%%
 * %%%                                      %%%
 */

#include "Nclient.h"
#include "scoutctrl_extern.h"

typedef struct tcp_server_data Tcp_Server_Data;
typedef struct sockaddr_in Sockaddr_In;
typedef struct command_data Command_Data;

int start_flag = FALSE;
int end_flag = FALSE;

int get_command(char *, int *, int *);
void buf_clr(int, char *);

int msg_process(int sock,char *msg, Command_Data *cmd)
{
    int  i;
    int  velocity_v, velocity_t;
    char *buff[20],tbuff[64],*p;

    //fprintf(stderr, "msg ->%s\n",msg);
    buf_clr(64,tbuff);
    sprintf(tbuff,msg);

    sscanf(msg,"%s\n",msg);
    if(get_command(msg, &velocity_v, &velocity_t) != 1){
	fprintf(stderr, "unknown command.\n");
    }

    if((p = strchr(msg,':'))!=NULL){
	*p = '\0';
	p++; 
    }
/*
    if((buff[0] = strchr(msg,':'))!=NULL){
	*buff[0] = '\0';
	buff[0]++;
    }
*/

    if(streq(msg,"gotohell")){
	//	fprintf(stderr,"gotohell\n");
	scout_move(velocity_v,velocity_t);
//	show_status();
        buf_clr(BUFSIZ,msg);
        sprintf(msg,"%s;",tbuff);
        return(OK);
    }

}

int get_command(char *buff, int *velocity_v, int *velocity_t)
{
    char *p;
    //fprintf(stderr, "get_command\n");
    if((p = strchr(buff,':')) == NULL) return(-1);
    p++;
    *velocity_v = atoi(p);
    if((p = strchr(buff,',')) == NULL) return(-1);
    p++;
    *velocity_t = atoi(p);

    fprintf(stderr, "scout_vm(%d, %d)\n",*velocity_v,*velocity_t);

    return(1);
}

int comm(Tcp_Server_Data *tcp_serv)
{
    int named, fd, i, len, ret;
    char buff[BUFSIZ];
    fd_set rfds1, rfds2;
    Sockaddr_In caddr;
    Command_Data cmd;
    
    FD_ZERO(&rfds1);
    FD_SET(tcp_serv->sock,&rfds1);
    rfds2 = rfds1;

    while(select(FD_SETSIZE, &rfds2, 0,0,0)>0){
	for(i=0;i<BUFSIZ; i++) buff[i] = '\0';
	for(fd=0; fd<FD_SETSIZE; fd++){
	    if(!FD_ISSET(fd,&rfds2)){
		continue;
	    }
	    if(fd == tcp_serv->sock){
		len = sizeof(caddr);
		if((named=accept(fd,(struct sockaddr*)&caddr,&len))<0){
		    perror("accept");
		    return(FALSE);
		}
		FD_SET(named,&rfds1);
	    }
	    else{
		if(ret = read(fd,buff,BUFSIZ)){
		    if(msg_process(fd,buff,&cmd)==EXIT){
			write(fd,"bye.\n",ret);
			FD_CLR(fd,&rfds1);
			close(fd);
			fprintf(stderr, "socket %d  closed.\n",fd);
		    }
		    ret = strlen(buff);
		    write(fd,buff,ret);
		    //fprintf(stderr,"return to view [%s]\n",buff);
		}
		else{
		    FD_CLR(fd,&rfds1);
		    close(fd);
		    fprintf(stderr,"socket %d closed.\n",fd);
		}
	    }
	}
	rfds2 = rfds1;
    }
    perror("select");
    return(FALSE);
}

void buf_clr(int size,char *buff)
{
    int i;

    for(i=0;i<size;i++) buff[i] = '\0';
}
