/* %%%                                      %%%
 * %%%   vision_process.c                   %%%
 * %%%   Copyright (C) 1999 Fumio Mizoguchi %%%
 * %%%                                      %%%
 */

#include "img.h"
#include "Vutility.h"

struct pix_d{
    unsigned char red;
    unsigned char green;
    unsigned char blue;
};

void keisan(int,int,Point*);
void binary(unsigned char*,int,int,int);

void Vision_Process(int red,int blue)
{
    unsigned char *img_data;
    img_data = get_vision_data(globals.scale);
    binary(img_data,globals.scale,red,blue);
    set_vision_data(img_data);
}

void binary(unsigned char *image_data,int scale,int red,int blue)
{
    int i,j;
    int width = 0, height = 0;
    int count_red = 0, count_blue = 0;
    int sum_red_x=0,sum_red_y=0;
    int sum_blue_x=0,sum_blue_y=0;
    Point pnt_red,pnt_blue;
    static GC gc;

    width  = 640/scale;
    height = 480/scale;
    vp_result.x[0] = 0; vp_result.x[1] = 0;
    vp_result.y[0] = 0; vp_result.y[1] = 0;

    /* X$B>e$K2hA|$rI=<($9$k$?$a$N=hM}$N0lIt(B */
    if(gc_flag){
	gc = XCreateGC(xwinparams.xdisplay,xwinparams.xwindow,0,0);
	printf("binary: width %d  height %d\n",width,height);
	gc_flag = FALSE;
    }

    /* $BL\I8NN0h$NI=<((B */
    XDrawArc(xwinparams.xdisplay,xwinparams.xwindow,gc,
	     (width/2)-40/scale,(height/2)-40/scale,
	     80/scale,80/scale,360*64,360*64);
    
    for(i=0; i<width*height;i++){
	j = i*3;

/* $B@V$NCj=P(B */

	if((i>(160*50)) && (*(image_data+(j+2)) > red) && (*(image_data+j) > 200) && (*(image_data+j) < 255)){	
//	if((*(image_data+(j+2)) > red) && (*(image_data+j) > 100) && (*(image_data+j) < 200)){
    

	    /* $B@V$N=hM}(B */
	    keisan(width,i,(Point*)&pnt_red);
	    sum_red_x += pnt_red.x; sum_red_y += pnt_red.y;
	    count_red++;
	    printf("red -> %d,  green -> %d, blue -> %d point ->%d  (%d,%d)\n",*(image_data+(j+2)),*(image_data+j),*(image_data+j+1),i,i%(160),i/(160));
	    keisan(width,i,(Point*)&pnt_blue);
	    /* $B3NG'$N$?$a$N=hM}(B */
	    if(globals.debug){
		*(image_data+j)     = 0;
		*(image_data+(j+1)) = 0;
		*(image_data+(j+2)) = 0;
	    }
	}

/*  $B@D$NCj=P(B  */

	if( (i>(160*50)) && (*(image_data+(j+1))>blue) && (*(image_data+j) > 200) && (*(image_data+j) < 255)){
//	if( (*(image_data+(j+1)) > blue) && (*(image_data+j) > 60) && (*(image_data+j) < 200)){
	    /* $B@D$N=hM}(B */
	    printf("blue -> %d,  green -> %d, red -> %d, point ->%d  (%d,%d)\n",*(image_data+(j+1)),*(image_data+j),*(image_data+j+2),i,i%(160),i/(160));
	    keisan(width,i,(Point*)&pnt_blue);
	    sum_blue_x += pnt_blue.x; sum_blue_y += pnt_blue.y;
	    count_blue++;
	    /* $B3NG'$N$?$a$N=hM}(B */
	    if(globals.debug){
		*(image_data+j)     = 255;
		*(image_data+(j+1)) = 255;
		*(image_data+(j+2)) = 255;
	    }
	}

    }

    /* $B=hM}7k2L$r%&%#%s%I%&>e$KI=<((B */
    if(!count_red || !count_blue){
	/* $BL\0u$,8+$D$+$i$J$$>l9g(B */
	vp_result.x[0] = -1; vp_result.y[0] = -1;
	vp_result.x[1] = -1; vp_result.y[1] = -1;
    }
    else{
	/* vp_result$B$O2hA|Cf$N%m%\%C%H0LCV!J:8>e86E@!K(B*/
	/* $B@V$N=hM}(B */
	XFillRectangle(xwinparams.xdisplay,xwinparams.xwindow,gc,
		       (sum_red_x/count_red)-4,
		       (sum_red_y/count_red)-4,10,10);
	vp_result.x[0] = sum_red_x/count_red;
	vp_result.y[0] = sum_red_y/count_red;
	/* $B@D$N=hM}(B */
	XFillRectangle(xwinparams.xdisplay,xwinparams.xwindow,gc,
		       (sum_blue_x/count_blue)-4,
		       (sum_blue_y/count_blue)-4,10,10);
	vp_result.x[1] = sum_blue_x/count_blue;
	vp_result.y[1] = sum_blue_y/count_blue;
	XDrawLine(xwinparams.xdisplay,xwinparams.xwindow,gc,
		  vp_result.x[0],vp_result.y[0],
		  vp_result.x[1],vp_result.y[1]);
    }
}

void keisan(int width,int pixel,Point *pnt)
{
    pnt->x = pixel % width;
    pnt->y = pixel / width;
}

void XInfo(Display *display,Window win)
{
    int depth = 0;

    depth = DefaultDepth(display,DefaultScreen(display));

    if(globals.verbose){
	printf("\n");
	printf("Vendor %s\n",ServerVendor(display));
	printf("Depth %d\n",depth);
	printf("\n");
    }

    xwinparams.xdisplay = display;
    xwinparams.xwindow  = win;
    xwinparams.display_depth = depth;
}

