/* %%%                                      %%%
 * %%%   socket.h                           %%%
 * %%%   Copyright (C) 1999 Fumio Mizoguchi %%%
 * %%%                                      %%%
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <netdb.h>

#include <sys/time.h>

#define TRUE  1
#define FALSE 0

#define SERVER       0
#define CLIENT       1
#define DEFAULT_PORT 10000
#define DEFAULT_HOST "mizo-chi"
#define DEFAULT_MODE 0

/*** for server socket ***/
struct tcp_server_data{
    int sock;
    int named_sock;
    struct hostent *hp;
    struct sockaddr_in sock_in;
};

struct udp_server_data{
    int sock;
    struct sockaddr_in saddr;
    struct sockaddr_in caddr;
};

/*** for client socket ***/
struct tcp_client_data{
    int sock;
    unsigned long host;
    struct hostent *hp;
    struct sockaddr_in sock_in;
};





/*** for option check ***/
int tcp_server_init(int,struct tcp_server_data*);
int tcp_client_init(char*,int,struct tcp_client_data*);
int udp_server_init(int,struct udp_server_data*);



