/* %%%                                      %%%
 * %%%   server.c                           %%%
 * %%%   Copyright (C) 1999 Fumio Mizoguchi %%%
 * %%%                                      %%%
 */

#include "img.h"
#include "socket.h"

int tcp_server_init(int port,struct tcp_server_data *tcp_serv)
{
    int i;
    char host[64];

    for(i=0;i<64;i++) host[i] = '\0';
    printf("using port #%d\n",image.port);

    gethostname(host,sizeof(host));

    if((tcp_serv->hp = gethostbyname((char*)&host))==NULL){
	fprintf(stderr,"tcp_server_init: host unknown.\n");
	return(FALSE);
    }

    if((tcp_serv->sock = socket(AF_INET,SOCK_STREAM,0))<0){
	perror("server: socket");
	return(FALSE);
    }

    tcp_serv->sock_in.sin_family = AF_INET;
    tcp_serv->sock_in.sin_port   = htons(port);
    tcp_serv->sock_in.sin_addr.s_addr = INADDR_ANY;

    if(bind(tcp_serv->sock,(struct sockaddr*)&(tcp_serv->sock_in),
	    sizeof(tcp_serv->sock_in))<0){
	perror("server: bind");
	return(FALSE);
    }

    if(listen(tcp_serv->sock,5)<0){
	perror("server: listen");
	return(FALSE);
    }

    return(TRUE);
}

/*
int udp_server_init(int port,struct udp_server_data *sock_dat_s)
{
    if((sock_dat_s->sock=socket(PF_INET, SOCK_DGRAM,0))<0){
	perror("socket");
	return(FALSE);
    }

    sock_dat_s.saddr->sin_family = AF_INET;
    sock_dat_s.saddr->sin_addr.s_addr = INADDR_ANY;
    sock_dat_s.saddr->sin_port = htons(globals.bcast);

    printf("waiting for bloadcasting messages on port #%d\n",globals.bcast);
    if(bind(sock_dat_s->sock,(struct sockaddr*)&(sock_dat_s->saddr),
	    sizeof(sock_dat_s->saddr))<0){
	perror("bind");
	return(FALSE);
    }
    return(TRUE);
}
*/
