/* %%%                                      %%%
 * %%%   img.h                              %%%
 * %%%   Copyright (C) 1999 Fumio Mizoguchi %%%
 * %%%                                      %%%
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <math.h>

/*** definition of macro ***/
#define DEFAULT_CONF  "comm.dat"
#define DEFAULT_PORT  10000
#define DEFAULT_SCALE 4
#define TRUE         1
#define FALSE        0

#define RED   -10
#define BLUE  -10
#define PORT  1
#define SCALE 2

#define streq(a,b) (!strcmp(a,b))

/*** protocol number ***/
#define OK        1
#define FAIL      2
#define START     3
#define QUIT      4
#define EXIT      5
#define INIT      6
#define IDENTIFY  7

/*** definition of struct ***/
struct globe{
    int scale;
    int verbose;
    int port;
    int sv_port;
    int noimage;
    int nonomad;
    int debug;
    int red;
    int blue;
    char *file;
    char *device;
    int nocomm;
};

struct conf_data{
    char label[10];
    char hostname[64];
    int  port;
    struct conf_data *next;
    struct conf_data *prev;
};

struct conf_data2{
    char *label;
    char *hostname;
    int port;
};

typedef struct XWIN_PARAM{
    int display_depth;
    Window  xwindow;
    Display *xdisplay;
    XEvent event;
    GC gc;
} Xwin_Params;

typedef struct pd{
    int x;
    int y;
} Point;

typedef struct pd2{
    int x[2];
    int y[2];
} Point2;

typedef struct{
    char label[32];
    char IP[16];
    int  port;
}Comm_Data;



/*** definition of global valueable ***/
struct globe globals;
struct conf_data *conf_start;
Xwin_Params xwinparams;
int gc_flag;
Point2 vp_result;
Comm_Data scout,image,image2,hoge_read,hoge_write;

/*** definition of the prototype of functions ***/
void option(int,char**);
void opt_ZERO(void);
int read_conf_file(void);
struct conf_data  *conf_alloc(struct conf_data*);
struct conf_data2 *conf_lookup(char*,struct conf_data2*);

void Vision_Processing(int,int);
void XInfo(Display*,Window);             




