/* %%%                                      %%%
 * %%%   image_main.c                       %%%
 * %%%   Copyright (C) 1999 Fumio Mizoguchi %%%
 * %%%                                      %%%
 */

#include "img.h"
#include "Vutility.h"
#include "socket.h"

typedef struct tcp_server_data Tcp_Server_Data;

void getdata(char *);

void main(int argc, char **argv)
{
    Tcp_Server_Data tcp_serv;

    opt_ZERO();

    getdata(globals.file);
    gc_flag = TRUE;

    if(tcp_server_init(image.port, &tcp_serv)){
	fprintf(stderr, "vision setting up now...");
	vision_setup(argc, argv, COLOR, globals.scale);
	fprintf(stderr,"ok!\n");
	fprintf(stderr, "threshold -> red %d, blue %d\n",globals.red,globals.blue);
	comm(&tcp_serv);
    }
    else{
	exit(1);
    }
}


void opt_ZERO(void)
{
    globals.scale   = DEFAULT_SCALE;
    globals.port    = DEFAULT_PORT;
    globals.verbose = FALSE;
    globals.file    = "../communication.dat";
    globals.noimage = FALSE;
    globals.nonomad = FALSE;
    globals.nocomm  = FALSE;
    globals.debug   = FALSE;
#ifndef DEBUG
    globals.device  = "/dev/rtvc0";
    globals.sv_port = PORT;
    globals.red     = 160;
    globals.blue    = 150;
#endif
}
/*
struct conf_data2 *conf_lookup(char *key, struct conf_data2* src)
{
    struct conf_data *tmp;

    tmp = conf_start;
    while(1){
	if(!strcmp(key,(char*)&(tmp->label))){
	    src->label    = tmp->label;
	    src->hostname = tmp->hostname;
	    src->port     = tmp->port;
	    return(src);
	}
	if(tmp->next != NULL)    tmp = tmp->next;
	else    break;
    }
    return((struct conf_data2*)NULL);
}

*/

void getdata(char *filename)
{
    FILE *fp;
    char buff[256],*ap,*pp;
    int  i;

    if((fp = fopen(filename,"r")) == NULL){
	fprintf(stderr, "file cannot open. [%s]\n",filename);
	exit(1);
    }
    
    
    while(fgets(buff,256,fp) != NULL){
	if((ap = strchr(buff,':')) == NULL) continue; 
	*ap = '\0';
	ap++;
	if((pp = strchr(ap,':')) != NULL){
	    *pp = '\0';
	    pp++;
	}

	if(streq(buff,"scout")){
	    strcpy(scout.label,buff);
	    strcpy(scout.IP,ap);
	    scout.port = atoi(pp);
	}
	else if(streq(buff,"image")){
	    strcpy(image.label,buff);
	    strcpy(image.IP,ap);
	    image.port = atoi(pp);
	}
	else if(streq(buff, "image2")){
	    strcpy(image2.label,buff);
	    strcpy(image2.IP,ap);
	    image2.port = atoi(pp);
	}
	else if(streq(buff,"hoge_read")){
	    strcpy(hoge_read.label,buff);
	    strcpy(hoge_read.IP,ap);
	    hoge_read.port = atoi(pp);
	}
	else if(streq(buff,"hoge_write")){
	    strcpy(hoge_write.label,buff);
	    strcpy(hoge_write.IP,ap);
	    hoge_write.port = atoi(pp);
	}

	else if(streq(buff,"sreshold_red")){
	    globals.red = atoi(ap);
	}

	else if(streq(buff,"sreshold_blue")){
	    globals.blue = atoi(ap);
	}

	for(i=0; i<256; i++) buff[i] = '\0';
    }

}






