/* %%%                                      %%%
 * %%%   image_communication.c              %%%
 * %%%   Copyright (C) 1999 Fumio Mizoguchi %%%
 * %%%                                      %%%
 */


#include "img.h"
#include "socket.h"

#define separate_char " "

typedef struct tcp_server_data Tcp_Server_Data;
typedef struct sockaddr_in Sockaddr_In;
typedef struct ans_map_data Ans_Map_Data;
typedef struct tcp_client_data Tcp_Client_Data;
typedef struct command_data Command_Data;

int msg_process(char*);
void buf_clr(int, char*);
int order(char *, char **, Command_Data *,int *, int *, char *);

int Open_Socket = 1;

int msg_process(char *msg)
{
    int  i,msg_flag;
    int  velocity_v, velocity_t;
    static int start_flag = FALSE;
    char *buff[32], orderbuff[64],*p;

    msg_flag = get_command(msg, &velocity_v, &velocity_t);

    sscanf(msg,"%s\n",msg);
    fprintf(stderr, "msg -> %s\n",msg);
/*
    if((buff[0] = strchr(msg,':'))!=NULL){
	*buff[0] = '\0';
	buff[0]++;
//	fprintf(stderr,"param: %s\n",buff[0]);
    }
*/
    if((p = strchr(msg,':'))!=NULL){
	*p = '\0';
	p++;
//	fprintf(stderr,"param: %s\n",buff[0]);
    }



    if(streq(msg,"identify")){
	Vision_Process(globals.red, globals.blue);
	fprintf(stderr, "Vision_Process end.\n");
	if(vp_result.x[0]<0 || vp_result.x[1]<0){
	    buf_clr(BUFSIZ,msg);
	    sprintf(msg,"no\n");
	}
	else{
	    buf_clr(BUFSIZ,msg);
	    sprintf(msg,"exit %d,%d\n",(vp_result.x[0]+vp_result.x[1])/2,(vp_result.y[0]+vp_result.y[1])/2);
	}
	return(IDENTIFY);
    }
    else if(streq(msg,"data")){
	Vision_Process(globals.red,globals.blue);
	buf_clr(BUFSIZ,msg);
	if(check_end()){
	    sprintf(msg,"data:%d,%d,%d,%d,%d;\0",vp_result.x[0],vp_result.y[0],vp_result.x[1],vp_result.y[1],globals.scale);
	}
	else{
	    sprintf(msg,"data:%d,%d,%d,%d,%d;\0",vp_result.x[0],vp_result.y[0],vp_result.x[1],vp_result.y[1],globals.scale);
	}
	return(OK);
    }
    else if(streq(msg,"order") && msg_flag){
	order(0,0,0,&velocity_v, &velocity_t, orderbuff);
	buf_clr(BUFSIZ,msg);
	sprintf(msg,"order:%d,%d;\0",velocity_v,velocity_t);
	return(OK);
    }

    else {
	buf_clr(BUFSIZ,msg);
	sprintf(msg,"unknown\0");
	return(OK);
    }


}

int get_command(char *buff, int *velocity_v, int *velocity_t)
{
    char *p,*q;
    fprintf(stderr, "get_command\n");
    if((p = strchr(buff,':')) == NULL) return(-1);
    fprintf(stderr, "check1\n");
    p++;
    if((q = strchr(p,',')) == NULL) return(-1);
    q++;
    *velocity_v = atoi(p);
    *velocity_t = atoi(q);
    fprintf(stderr, "scout_vm(%d, %d)\n",*velocity_v,*velocity_t);

    return(1);
    
}


int order(char *msg, char **buff, Command_Data *cmd,int *v, int *t,char *orderbuff)
{
    int i, j;
    FILE *fp;
    char tbuff[BUFSIZ];
    char msgbuff[10];
    char *tmp[5];
//    Ans_Map_Data ans;
    static Tcp_Client_Data tc;

    buf_clr(64,orderbuff);
    buf_clr(BUFSIZ,tbuff);
    sprintf(orderbuff,"gotohell:%d,%d\0",*v,*t);
    fprintf(stderr,"send to scout [%s]\n",orderbuff);
    if(Open_Socket){
	connect_socket(&scout,&tc);
	Open_Socket = 0;
    }
    write(tc.sock,orderbuff,strlen(orderbuff)+1);
    fprintf(stderr,"send ok.\n");
    while(1){
	fprintf(stderr, "socket -> %d\n",tc.sock);
	if(read(tc.sock,tbuff,sizeof(tbuff)) >= 1) break;
    }
    fprintf(stderr, "receive message from scout_ctrl[%s]\n",tbuff);
    
//    usleep(300000);
//    printf("%s,%d\n",orderbuff,strlen(orderbuff));
}


int check_end(void)
{
    /* Nomad$B$,Cf?4NN0h$K$$$k$+$I$&$+$N%A%'%C%/(B */
    int img_cx,img_cy;
    int rob_x,rob_y; 

    img_cx = 320/globals.scale;
    img_cy = 240/globals.scale;

    rob_x = (vp_result.x[0]+vp_result.x[1])/2;
    rob_y = (vp_result.y[0]+vp_result.y[1])/2;

    if(abs(img_cx - rob_x)<10 && abs(img_cy - rob_y)<10){
	fprintf(stderr, "TRUE\n");
	return(TRUE);
    }
    else{
	fprintf(stderr, "FALSE\n");
	return(FALSE);
    }
}

int comm(Tcp_Server_Data *tcp_serv)
{
    static int fd;
    int named,i,len,ret;
    char buff[BUFSIZ];
    fd_set rfds1, rfds2;
    Sockaddr_In caddr;
    
    FD_ZERO(&rfds1);
    FD_SET(tcp_serv->sock,&rfds1);
    rfds2 = rfds1;

    while(select(FD_SETSIZE,&rfds2,0,0,0)>0){
	for(i=0; i<BUFSIZ; i++) buff[i] = '\0';

	for(fd=0; fd<FD_SETSIZE; fd++){
	    if(!FD_ISSET(fd,&rfds2)){
		continue;
	    }
	    if(fd == tcp_serv->sock){
		len = sizeof(caddr);
		if((named=accept(fd,(struct sockaddr*)&caddr,&len))<0){
		    perror("accept");
		    return(FALSE);
		}
		FD_SET(named,&rfds1);
	    }
	    else{
		buf_clr(BUFSIZ,buff);
		if(ret = read(fd,buff,BUFSIZ)){
		    printf("%s\n",buff);
		    if(msg_process(buff) == EXIT){
			write(fd,"bye.\n",ret);
			FD_CLR(fd,&rfds1);
			close(fd);
			fprintf(stderr,"socket %d closed.\n",fd);
		    }
		    ret = strlen(buff);
		    fprintf(stderr,"return message to hoge",buff);
		    write(fd,buff,ret);
		    fprintf(stderr,"  done.\n");
		}
		else{
		    FD_CLR(fd,&rfds1);
		    close(fd);
		    fprintf(stderr,"socket %d closed\n",fd);
		}
	    }
	}
	rfds2 = rfds1;
    }
    perror("select");
    return(FALSE);
}
	    
void buf_clr(int size, char *buff)
{
    int i;
    for(i=0; i<size; i++) buff[i] = '\0';
}
 










