#include "img.h"
#include "socket.h"

int tcp_client_init(char *host,int port,struct tcp_client_data *tcp_client)
{
    if(host == NULL) return(FALSE);

    printf("server: %s\n",host);
    printf("using port #%d\n",port);

    if((tcp_client->host = inet_addr(host))==-1){
	if((tcp_client->hp = gethostbyname(host))==NULL){
	    fprintf(stderr,"unknown host.\n");
	    return(FALSE);
	}
	tcp_client->host = **(unsigned long**)(tcp_client->hp)->h_addr_list;
    }

    if((tcp_client->sock = socket(AF_INET,SOCK_STREAM,0))<0){
	perror("client: socket");
	return(FALSE);
    }

    tcp_client->sock_in.sin_port = htons(port);
    tcp_client->sock_in.sin_family = AF_INET;
    tcp_client->sock_in.sin_addr.s_addr = tcp_client->host;

    if(connect(tcp_client->sock,(struct sockaddr*)&(tcp_client->sock_in),
	       sizeof(tcp_client->sock_in))<0){
	perror("client: connect");
	return(FALSE);
    }
}
/*
int connect_socket(char *label,struct tcp_client_data *tcp_client)
{
    struct conf_data2 conf;

    if(!conf_lookup(label,(struct conf_data2*)&conf)){
	return(FALSE);
    }
    if(!tcp_client_init(conf.hostname,conf.port,tcp_client)){
	return(FALSE);
    }
    return(TRUE);
}
*/

int connect_socket(Comm_Data *comm_data,struct tcp_client_data *tcp_client)
{
    if(!tcp_client_init(comm_data->IP,comm_data->port,tcp_client)){
	return(FALSE);
    }
    return(TRUE);
}

int send_msg(char *msg,struct tcp_client_data *tcp_client)
{
    int i,len,ret;

    len = strlen(msg);

    if(write(tcp_client->sock,msg,len)==(int)NULL){
	fprintf(stderr,"send_msg: write error\n");
	return(FALSE);
    }
    buf_clr(BUFSIZ,msg);
    ret = read(tcp_client->sock,msg,BUFSIZ);
    return(ret);
}

