/* %%%                                      %%%
 * %%%   deliv_socket.c                     %%%
 * %%%   Copyright (C) 1999 Fumio Mizoguchi %%%
 * %%%                                      %%%
 */

#include "deliv_extern.h"

struct tcp_client_data{
    int sock;
    unsigned long host;
    struct hostent *hp;
    struct sockaddr_in sock_in;
};

int client_connect(char *label,char *hostname, int port, int *sock,struct hostent *hp, struct sockaddr_in *sin)
{

    fprintf(stderr, "hostname: %s [%s]\n",hostname,label);
    
    if((hp = (struct hostent *)gethostbyname(hostname)) == NULL){
	fprintf(stderr, "unknownhost: %s\n",hostname);
	exit(0);
    }

    if((*sock = socket(AF_INET, SOCK_STREAM, 0)) < 0){	
	perror("clinet: socket");
	exit(1);
    }
    
    sin->sin_family = AF_INET;
    sin->sin_port = htons(port);
    bcopy(hp->h_addr, &sin->sin_addr, hp->h_length);

    if(connect(*sock, (struct sockaddr *)sin, sizeof(*sin)) < 0){
	perror("client: connect\n");
	exit(1);
    }
    return(1);    
}

int client_sendmsg(int sock, char *msg)
{
    char buff[32];

    write(sock,msg,strlen(msg));
    buff_clr(buff,sizeof(buff));
    while(1){
	read(sock,buff,sizeof(buff));
	if(strchr(buff,';')) break;
    }
    fprintf(stderr, "receive message : %s",buff);
    return(1);
}

int tcp_server_init(int port,Tcp_Server_Data *tcp_serv)
{
    int i;
    char host[64];

    for(i=0;i<64;i++) host[i] = '\0';
    printf("using port %d\n",port);

    gethostname(host,sizeof(host));

    if((tcp_serv->hp = gethostbyname((char*)&host))==NULL){
	fprintf(stderr,"tcp_server_init: host unknown.\n");
	return(0);
    }

    if((tcp_serv->sock = socket(AF_INET,SOCK_STREAM,0))<0){
	perror("server: socket");
	return(0);
    }

    tcp_serv->sock_in.sin_family = AF_INET;
    tcp_serv->sock_in.sin_port   = htons(port);
    tcp_serv->sock_in.sin_addr.s_addr = INADDR_ANY;

    if(bind(tcp_serv->sock,(struct sockaddr*)&(tcp_serv->sock_in),
	    sizeof(tcp_serv->sock_in))<0){
	perror("server: bind");
	return(0);
    }

    if(listen(tcp_serv->sock,5)<0){
	perror("server: listen");
	return(0);
    }

    return(1);
}

