/* %%%                                      %%%
 * %%%   deliv_main.c                       %%%
 * %%%   Copyright (C) 1999 Fumio Mizoguchi %%%
 * %%%                                      %%%
 */

#include "deliv_extern.h"

int  check_option(int, char **);
void usage(void);
void mainloop(int);

int debug_flag = 0;
extern int count;
extern int x_length;
extern int center_trap;
extern int position_trap;
extern int first_trap;
extern int final_trap;
extern int nishiyama_flag;

void main(int argc , char **argv)
{
    int mode = 0;

    if(check_option(argc, argv) == 0){
	//usage();
	exit(0);
    }
    set_option();
    getdata(globals.file);

    mainloop(mode);
}


void mainloop(int mode)
{
    int i;
    int s, ss, dat_true;
    int velocity_v, velocity_t, cx, cy;
    char c,buff[32],orderbuff[32],*data,*p;
    struct hostent *hp, *s_hp;
    struct sockaddr_in sin, s_sin;
    Scout_Point scout_point;
    Tcp_Server_Data tcp_serv1, tcp_serv2;

    data = "data";

    if(!debug_flag){
	if(tcp_server_init(hoge_read.port,&tcp_serv1)){
	    fprintf(stderr, "tcp_serv1 ok.\n");
	}
	else exit(1);
	
	if(tcp_server_init(hoge_write.port,&tcp_serv2)){
	    fprintf(stderr, "tcp_serv2 ok.\n");
	}
	else exit(1);
    }

    if(!debug_flag){
	serv_wait(&tcp_serv1,&tcp_serv2);
    }

    fprintf(stderr, "connect ok.\n");


    while(1){
	fprintf(stderr, "waiting request from MRL\n");
	while(!debug_flag){
	    if(ret = read(named1,buff,256)){
		fprintf(stderr,"receive data = %s \n",buff);
		break;
	    }
	}
        write(named2,"ok\0",3);


	count = 0;
	center_trap = 0;
	position_trap = 0;
	first_trap = 1;
	final_trap = 0;
	nishiyama_flag = 1;

/*   connect width image  */

	client_connect(image.label,image.IP,image.port,&s,hp,&sin);	
	fprintf(stderr, "connect ok!!\n");


/*   connect width scout  */

	client_connect(scout.label,scout.IP,scout.port,&ss,s_hp,&s_sin);
	fprintf(stderr, "connect ok!!\n");


	if(debug_flag){
	    while(1){
		fprintf(stderr, "start ok? [Y/n] ");
		c = getchar();
		if(c == 'Y' || c == 'y'){
		    break;
		}
		if(c == 'N' || c == 'n'){
		    exit(1);
		}
//		else exit(1);
		printf("\n");
	    }
	}


	p = "data";
	
	while(1){
	    while(nishiyama_flag && !debug_flag){
		 fprintf(stderr, "send message [%s]\n",p);
		 buff_clr(buff,32);
		 send(s,p,strlen(p),0);
		 while(1){
		     fprintf(stderr, "socket->%d\n",s);
		     read(s,buff,sizeof(buff));
		     if(strchr(buff,';') != NULL) break;
		 }
		 fprintf(stderr, "message from view = %s\n",buff);
		 if(get_status(&scout_point,buff)==1){
		     if(scout_point.point[0] != -1){
			 write(named2,"insight",strlen("insight"));
			 fprintf(stderr,"send message to nishiyama\n");
			 nishiyama_flag = 0;
			 sleep(1);
			 break;
		     }
		 }
	     }
	    

	    fprintf(stderr, "send message [%s]\n",p);
	    buff_clr(buff,32);
	    send(s,p,strlen(p),0);
	    for(i=0; i<3; i++){
		fprintf(stderr, "socket->%d\n",s);
		read(s,buff,sizeof(buff));
		if(strchr(buff,';') != NULL) break;
	    }
	    fprintf(stderr, "message from view = %s\n",buff);
	    if(get_status(&scout_point,buff)==1){
		fprintf(stderr,"scout moving now...\n");

	
		scout_control(&scout_point,buff,&velocity_v,&velocity_t,&dat_true,&cx,&cy);

		if(final_trap > 10){
		    fprintf(stderr,"getgoal\n");
		    break;
		}

		if(x_length == 0){
		    velocity_v = 0;
		    velocity_t = 0;
		}
		else{
		    velocity_v *= 100/x_length+5;
		    if(velocity_v > 90) velocity_v = 90;
		    else if(velocity_v < -90) velocity_v = -90;

		    if(velocity_v > 0){
			velocity_v += 5;
		    }
		    velocity_t *= 50/x_length+5;
		    if(velocity_t > 100) velocity_t = 100;
		    else if(velocity_t < -100) velocity_t = -100;
		    if(velocity_t > 0){
			velocity_t += 10;
		    }
		}		

		if((velocity_v == 0) && (velocity_t == 0) && dat_true && (first_trap == 0)&& (final_trap == 0) && (center_trap != 1) && ((cy-60)<5)){
		    count ++;
		    if(count > 5){
			printf("hogehoge\n");
			final_trap = 1;
		    }
		}
		else count = 0;

		buff_clr(orderbuff,32);
		sprintf(orderbuff,"gotohell:%d,%d",velocity_v,velocity_t);
		fprintf(stderr,"send message [%s]\n",orderbuff);
		send(ss,orderbuff,strlen(orderbuff),0);

/*    wait message from scout    */
		buff_clr(buff,32);
		while(1){
		    read(ss,buff,sizeof(buff));
		    if(strchr(buff,';') != NULL) break;
		}
		fprintf(stderr,"message from scout = %s\n",buff);
	    }
	    else{
		fprintf(stderr,"scout stop!\n");
	    }

	}
	close(s);
	close(ss);
	fprintf(stderr, "final message sending.\n");

	if(!debug_flag){
	    send_message(&tcp_serv1, &tcp_serv2, &scout_point);
	}
    }
    
    exit(0);
}


int get_status(Scout_Point *scout_point, char *buff)
{
    int  i;
    char *p;

    if((p = strchr(buff, ':')) == NULL) return(-1);
    p++;
    scout_point->point[0] = atoi(p);
    
    for(i=1; i<4; i++){
	if((p = strchr(p,',')) == NULL) return(-1);
	p++;
	scout_point->point[i] = atoi(p);
    }
    
	for(i=0; i<4; i++){
	    fprintf(stderr, "%d\n",scout_point->point[i]);
	}
    
    return(1);

}


void buff_clr(char *buff, int size)
{
    int i;
    for(i=0; i<size; i++){
	buff[i] = '\0';
    }
}


void serv_wait(Tcp_Server_Data *tcp_serv1, Tcp_Server_Data *tcp_serv2)
{
    fd_set rfds1;
    fd_set rfds2;
    char buff[256];

    flag1 = 0;
    flag2 = 0;
    FD_ZERO(&rfds1);
    FD_SET(tcp_serv1->sock,&rfds1);
    FD_ZERO(&rfds2);
    FD_SET(tcp_serv2->sock,&rfds2);

    fprintf(stderr, "waiting client.\n");
    
    len1 = sizeof(caddr1);
    if((named1 = accept(tcp_serv1->sock,(struct sockaddr*)&caddr1,&len1))<0){
	perror("accept");
    }
    fprintf(stderr, "tcp_serv->sock = %d\n",tcp_serv1->sock);
    flag1 =1;
    FD_SET(named1,&rfds1);
    fprintf(stderr, "server1 connect.\n");

    len2 = sizeof(caddr2);
    if((named2 = accept(tcp_serv2->sock,(struct sockaddr*)&caddr2,&len2))<0){
	perror("accept");
    }
    fprintf(stderr,"tcp_serv2->sock = %d\n",tcp_serv2->sock);
    flag2 = 1;
    FD_SET(named2,&rfds1);
    fprintf(stderr, "server2 connect.\n");

    for(i=0; i<256; i++) buff[i] = '\0';

}

void send_message(Tcp_Server_Data *tcp_serv1, Tcp_Server_Data *tcp_serv2, Scout_Point *scout_point)
{
    int x,y;
    char buff[256];
    
    x = (scout_point->point[0] + scout_point->point[2])/2;
    y = (scout_point->point[1] + scout_point->point[3])/2;
    
    sprintf(buff,"%d,%d,%d,%d,4:",scout_point->point[0],scout_point->point[1],scout_point->point[2],scout_point->point[3]);

    write(named2,buff,strlen(buff));
    fprintf(stderr, "send message = %s\n",buff);

}

void getdata(char *filename)
{
    FILE *fp;
    char buff[256],*ap,*pp;
    int  i;

    if((fp = fopen(filename,"r")) == NULL){
	fprintf(stderr, "file cannot open. [%s]\n",filename);
	exit(1);
    }
    
    
    while(fgets(buff,256,fp) != NULL){

//	fprintf(stderr,"%s",buff);
	if((ap = strchr(buff,':')) == NULL) continue; 
	*ap = '\0';
	ap++;
	if((pp = strchr(ap,':')) == NULL) continue;
	*pp = '\0';
	pp++;

	if(streq(buff,"scout")){
	    strcpy(scout.label,buff);
	    strcpy(scout.IP,ap);
	    scout.port = atoi(pp);
	}
	else if(streq(buff,"image")){
	    strcpy(image.label,buff);
	    strcpy(image.IP,ap);
	    image.port = atoi(pp);
	}
	else if(streq(buff,"hoge_read")){
	    strcpy(hoge_read.label,buff);
	    strcpy(hoge_read.IP,ap);
	    hoge_read.port = atoi(pp);
	}
	else if(streq(buff,"hoge_write")){
	    strcpy(hoge_write.label,buff);
	    strcpy(hoge_write.IP,ap);
	    hoge_write.port = atoi(pp);
	}
	for(i=0; i<256; i++) buff[i] = '\0';
    }

}

/*
void usage(void)
{

    fprintf(stderr,"\n\nPrint delivery system ver 0.1  Mizoguchi lab. 1998.\n");
    fprintf(stderr,"Usage: prdeliv [OPTION]\n");
    fprintf(stderr,"    -m [mode]     set mode(1 == debug_mode, 0 == normal_mode\n\n");
    fprintf(stderr,"    -ip [port]    set port number(image)\n\n");
    fprintf(stderr,"    -sp [port]    set port number(scout)\n\n");
    fprintf(stderr,"    -ih [IP]      set host IP(image)\n\n");   
    fprintf(stderr,"    -sh [IP]      set host IP(scout)\n\n");

}
*/


int check_option(int argc, char **argv)
{
    int i, d;
    d = -1;
    if(argc == 1) return(1);

    argv++;
    for(i=1; i<argc; i++){
	if(streq(*argv,"-m")){
	    argv++;
	    i++;
	    if(i < argc){
		d = atoi(*argv);
	    }
	}
    }

    if((d != 1) && (d != 0)){
	return(0);
    }
    debug_flag = d;
    return(1);
}


void set_option(void)
{
    globals.file = "../communication.dat";
}



