/**********************************************************************/
/*                                                                    */
/*      program of VCclient.c   1996.11.28 (Thu)                      */
/*      Program for Canon VC-C1 (Hiraishi version)                    */
/*                                                                    */
/*      Hironori Hiraishi       Last Modify: 1996.11.28(Thu)          */
/*                                                                    */
/**********************************************************************/
#include <string.h>
#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <sys/stat.h>
#include <netinet/in.h>
#include <netdb.h>
#include <sys/termio.h>
#include <fcntl.h>
#include "VCclient.h"

#define HOME       32768

/***** FUNCTION PROTOTYPE *****/
void VCreset(void);
void wait(int);
void VCreset(void);
void ChangeModeHost(void);
void VCack(int);
void plusCheckSum(unsigned char*, unsigned char*);

void VCinit(void);
void get_angle(int, unsigned char*, double, double);
void get_angle2(int, unsigned char*, double, double);
int send_code(unsigned char*);
int read_code();
void reverse(char*);
void itoa16(int, char*);
int atoi16(char*);
void notify(void);


/***** EXTERNALDATA ******/
int fd;           /* RS-232C Device            */
struct termio ter;                  

int pan_flg = 0;  /* -1:right, 0:stop,  1:left */
int tilt_flg = 0; /* -1:down,  0:stop,  1:up   */
int zoom_flg = 0; /* -1:wide,  0:stop,  1:tele */

int lest = 0;


/***** VCSETUP FUNCTION ***********************************************/
int VCsetup(char *dev)
{
    /***** INTERNALDATA *****/

    /***** PROCESS *****/
    if((fd = open(dev,O_RDWR)) == (int)NULL){
	printf("VCclient error: can not open device.\n");
	return 0;
    }
    ioctl(fd, TCGETA, &ter);
    ter.c_iflag = 0;
    ter.c_lflag = 0;
    ter.c_oflag = 0;
    ioctl(fd, TCSETA, &ter);
    
    VCreset();
    printf("Please wait for 7 seconds..\n");
    wait(7);
    ChangeModeHost();
    VChome();

    pan_flg = 0;
    tilt_flg = 0;

    return 1;
}
/***** END OF VCSETUP FUNCTION ****************************************/


/***** WAIT FUNCTION **************************************************/
void wait(int time)
{
    /***** INTERNAL DATA *****/
    int i;

    /***** PROCESS *****/
    for(i=0; i<time; i++){
	fprintf(stderr,"\rcount %d",i+1);
	sleep(1);
    }
    printf("\rThank for waiting me !!\n");
}
/***** END OF WAIT FUNCTION *******************************************/


/***** VCRESET FUNCTION ***********************************************/
void VCreset(void)
{
    /***** INTERNALDATA *****/
    unsigned char code[1024], readCode[1024];

    /***** PROCESS *****/
    code[0] = 0x32;
    code[1] = 0x32;
    code[2] = 0x32;
    code[3] = 0x32;
    code[4] = 0x32;
    code[5] = 0x32;
    code[6] = 0x32;
    code[7] = 0x32;
    code[8] = 0;
    code[9] = 0;
    code[10] = 0;
    code[11] = 0;
    code[12] = 0;
    code[13] = 0;
    code[14] = 0;
    code[15] = 0;
    send_code(code); 
}
/***** END OF VCRESET FUCNTION ****************************************/


/***** Change Mode Host FUNCTION **************************************/
void ChangeModeHost(void)
{
    /***** INTERNALDATA *****/
    unsigned char code[1024], readCode[1024];
    
    /***** PROCESS *****/
    code[0] = 0x05;      /* $B%3%^%s%ID9(B       */
    code[1] = 0x08;      /* CCU              */
    code[2] = 0x17;      /* $B@)8f%b!<%I@ZBX$((B */
    code[3] = 0x01;      /* $B%Q%s%A%k%?@)8f%b!<%I(B */
    code[4] = 0x00;      /* $B%[%9%H@)8f%b!<%I(B */
    code[5] = 0xdb;      /*  $B%A%'%C%/%5%`(B     */

    send_code(code); 
    /* ACK  */
    read_code();
    /* reply */
    read_code();
    /* ACK */
    VCack(0x08);
}
/***** END OF Change Mode Host FUNCTION *******************************/


/***** VCACK FUNCTION *************************************************/
void VCack(int data) 
{
    /***** INTERNALDATA *****/
    unsigned char code[1024], readCode[1024];
    
    /***** PROCESS *****/
    code[0] = 0x03;
    code[1] = 0x80 + data;
    code[2] = 0x00;
    code[3] = 0x7d - data;
    send_code(code); 
}
/***** END OF VCACK FUNCTION ******************************************/


/***** VCHOME FUNCTION ************************************************/
void VChome(void)
{
    /***** INTERNALDATA *****/
    unsigned char code[1024], readCode[1024],sendCode[1024]; 

    /***** PROCESS *****/
    notify();
    VCstop();
    VCzstop();

    code[0] = 0x03;
    code[1] = 0x05;
    code[2] = 0x11;
    plusCheckSum(code, sendCode);
    
    send_code(sendCode); 
    /* ACK */
    read_code();

    /* reply */
    read_code();
    /* ACK */
    VCack(0x05);

    pan_flg = 0;
    tilt_flg = 0;
    
    sleep(3);
}
/***** END OF VCHOME FUCNTION *****************************************/


/***** VCMOVE FUNCTION ************************************************/
void VCmove(int pan, int tilt)
{
    /***** INTERNALDATA *****/
    unsigned char code[1024], readCode[1024],sendCode[1024]; 

    /***** PROCESS *****/
    notify();
    VCzstop();
    code[0] = 0x06;
    code[1] = 0x05;
    code[2] = 0x12;
    code[3] = 0x01;
    if(pan < 0){
	code[4] = 0x01;
    }
    else if(pan >0){
	code[4] = 0x02;
    }
    else{
	code[4] = 0x00;
    }

    if(tilt < 0){
	code[5] = 0x02;
    }
    else if(tilt > 0){
	code[5] = 0x01;
    }
    else{
	code[5] = 0x00;
    }
    plusCheckSum(code, sendCode);
    
    send_code(sendCode); 
    /* ACK */
    read_code();

    /* reply */
    read_code();
    /* ACK */
    VCack(0x05);
}
/***** VCMOVE FUNCTION ************************************************/


/***** VCPOINT FUNCTION ***********************************************/
void VCpoint(int pan, int tilt)
{
    /***** INTERNALDATA *****/
    unsigned char code[1024], readCode[1024],sendCode[1024]; 
    unsigned char data_p[2];
    unsigned char data_t[2];
    double flg[2];

    /***** PROCESS *****/
    //printf("go notify\n");
    notify();
    //printf("go VCstop\n");
//    VCstop();
    //printf("go VCzstop\n");
//    VCzstop();
    code[0] = 0x09;
    code[1] = 0x05;
    code[2] = 0x12;
    code[3] = 0x05;
    code[4] = 0x02;

    if (pan > 9000){
	pan =  9000;
    }
    else if(pan < -9000){
	pan = -9000;
    }
    //printf("go get_angle2\n");
    get_angle2(pan, data_p, (double)0x320, 90.0);
    
    code[5] = data_p[0]; /* $B%Q%s(BHi         */ 
    code[6] = data_p[1]; /* $B%Q%s(BLow        */

    if (0 <= tilt) {
	flg[0] = (double)0xde;
	flg[1] = 25.0;
    }
    else {
	flg[0] = (double)0x10a;
	flg[1] = 30.0;
    }
    if (tilt > 2500){
	tilt = 2500;
    }
    else if(tilt < -3000){
	tilt = -3000;
    }
//    printf("go get_angle2\n");
    get_angle2( tilt, data_t, flg[0], flg[1]);
    code[7] = data_t[0];    /* $B%A%k%H(BHi       */
    code[8] = data_t[1];    /* $B%A%k%H(BLow      */
    
    //printf("go plusCheckSum\n");
    plusCheckSum(code, sendCode);

   //printf("go send_code\n");
    send_code(sendCode); 
    /* ACK */
    //printf("go read_ACKcode\n");
    read_code();

    /* reply */
    //printf("go read_code\n");
    read_code();
    /* ACK */
    //printf("go VCack\n");
    VCack(0x05);
}
/***** END OF VCPOINT FUNCTION ****************************************/


/***** VCSPEED FUNCTION ***********************************************/
void VCspeed(int pan, int tilt)
{
    /***** INTERNALDATA *****/
    unsigned char code[1024], readCode[1024],sendCode[1024]; 

    /***** PROCESS *****/
    notify();
    code[0] = 0x07;
    code[1] = 0x05;
    code[2] = 0x12;
    code[3] = 0x03;
    code[4] = 0x02;

    if(pan < 1){
	pan = 1;
    }
    else if(pan > 76){
	pan = 76;
    }
    code[5] = (unsigned char)pan;
    if(tilt < 1){
	tilt = 1;
    }
    else if(tilt > 70){
	tilt = 70;
    }
    code[6] = (unsigned char)tilt;
    
    plusCheckSum(code, sendCode);
    
    send_code(sendCode);
    /* ACK */
    read_code();

    /* reply */
    read_code();
    /* ACK */
    VCack(0x05);
}
/***** END OF VCSPEED FUNCTION ****************************************/


/***** VCSTOP FUNCTION ************************************************/
void VCstop(void)
{
    /***** INTERNALDATA *****/
    unsigned char code[1024], readCode[1024],sendCode[1024]; 

    /***** PROCESS *****/
//    printf("go notify [VCstop]\n");
    notify();
    code[0] = 0x04;
    code[1] = 0x05;
    code[2] = 0x12;
    code[3] = 0x02;

//    printf("go plusCheckSum [VCstop]\n");
    plusCheckSum(code, sendCode);

//    printf("go send_code [VCstop]\n");
    send_code(sendCode); 
    /* ACK */
//    printf("go read_code [VCstop]\n");
    read_code();

    /* reply */
//    printf("go read_code [VCstop]\n");
    read_code();
    /* ACK */
//    printf("go VCack [VCstop]\n");
    VCack(0x05);
}
/***** END OF VCSTOP FUNCTION *****************************************/


/***** VCzmove FUNCTION ***********************************************/
void VCzmove(int tw)
{
    /***** INTERNALDATA *****/
    unsigned char code[1024], readCode[1024],sendCode[1024]; 

    /***** PROCESS *****/
    notify();
//    VCstop();
    code[0] = 0x05;
    code[1] = 0x01;
    code[2] = 0x12;
    code[3] = 0x01;

    if(tw > 0){
	code[4] = 0x00;
    }
    else{
	code[4] = 0x01;
    }

    plusCheckSum(code, sendCode);

    send_code(sendCode); 
    /* ACK */
    read_code();

    /* reply */
    read_code();
    /* ACK */
    VCack(0x01);
}
/***** END OF VCZMOVE FUNCTION ****************************************/


/***** VCzmove FUNCTION ***********************************************/
void VCzhome()
{
    /***** INTERNALDATA *****/
    unsigned char code[1024], readCode[1024],sendCode[1024]; 

    /***** PROCESS *****/
    notify();
//    VCstop();
    code[0] = 0x07;
    code[1] = 0x01;
    code[2] = 0x12;
    code[3] = 0x02;
    code[4] = 0x02;
    code[5] = 0x00;
    code[6] = 0x00;

    plusCheckSum(code, sendCode);
    
    send_code(sendCode); 
    /* ACK */
    read_code();

    /* reply */
    read_code();
    /* ACK */
    VCack(0x01);
}
/***** END OF VCZMOVE FUNCTION ****************************************/


/***** VCZSPEED FUNCTION **********************************************/
void VCzspeed(int speed)
{
    /***** INTERNALDATA *****/
    unsigned char code[1024], readCode[1024],sendCode[1024]; 

    /***** PROCESS *****/
    notify();
    VCstop();
    code[0] = 0x06;
    code[1] = 0x01;
    code[2] = 0x12;
    code[3] = 0x04;
    code[4] = 0x02;

    if(speed < 0){
	speed = 1;
    }
    else if(speed > 7){
	speed = 7;
    }
    code[5] = (unsigned char)speed;
    
    plusCheckSum(code, sendCode);
    
    send_code(sendCode); 
    /* ACK */
    read_code();

    /* reply */
    read_code();
    /* ACK */
    VCack(0x01);
}
/***** END OF VCSPEED FUNCTION ****************************************/


/***** VCZSTOP FUNCTION ***********************************************/
void VCzstop(void)
{
    /***** INTERNALDATA *****/
    unsigned char code[1024], readCode[1024],sendCode[1024]; 

    /***** PROCESS *****/
    notify();
    code[0] = 0x04;
    code[1] = 0x01;
    code[2] = 0x12;
    code[3] = 0x03;

    plusCheckSum(code, sendCode);
    
    send_code(sendCode); 
    /* ACK */
    read_code();

    /* reply */
    read_code();
    /* ACK */
    VCack(0x01);
}
/***** END OF VCZSTOP FUNCTION ****************************************/


/***** SEND_CODE FUNCTION *********************************************/
int send_code(unsigned char* send_buf)
{
    /***** INTERNALDATA *****/
    int len;

    /***** PROCESS *****/
    len = (int)send_buf[0]+1;
    write(fd, send_buf, len); 
    
    return 1;
}
/***** END OF SEND_CODE FUNCTION **************************************/
 

/***** READ_CODE FUNCTION *********************************************/
int read_code(void)
{
    /***** INTERNALDATA *****/
    unsigned char len[1024];
    unsigned char buf[1024];
    int n = 0;


    /***** PROCESS *****/

    //printf("go read %dbytes[read_code]\n",lest+1);
    n = read(fd, len, lest+1);
    //printf("go read2  %d, n = %d, [read_code]\n", len[lest], n);
    n = read(fd, buf, (int)len[lest]);
    lest = len[lest]-n;
    //printf("lest = %d, %d  , n = %d, [read_code]\n",lest, buf[0], n);

/*    while(lest > 0){
	printf("checker \n");
	n = read(fd, buf, lest);
	lest = lest - n;
    } */

    return 0;
}
/***** END OF READ_CODE FUNCTION **************************************/


/***** GET_ANGLE FUCNTION *********************************************/
void get_angle(int angle, unsigned char *data, double flg1, double flg2)
{
    /***** INTERNALDATA *****/
    unsigned char u,l;
    int i;
    char one_data[10] ;
    char upper[3];
    char lower[3];

    /***** PROCESS *****/
    one_data[0] ='\0';
    angle = (int)(angle*flg1)/flg2;   /* degree(int) to (10)     */
    angle = HOME + angle;       /* 8000(16) + degree->(16) */ 
    
    itoa16(angle,one_data);

    switch(strlen(one_data)) {
    case 1:
        upper[0] = '0';
        upper[1] = '0';
        upper[2] = '\0';
        lower[0] = '0';
	lower[1] = one_data[0];
        lower[2] = '\0';
        break;
    case 2:
	upper[0] = '0';
        upper[1] = '0';
        upper[2] = '\0';
        lower[0] = one_data[0];
        lower[1] = one_data[1];
        lower[2] = '\0';
        break;
    case 3:
	upper[0] = '0';
        upper[1] = one_data[0];
        upper[2] = '\0';
        lower[0] = one_data[1];
        lower[1] = one_data[2];
        lower[2] = '\0';
	break;
    case 4:
	upper[0] = one_data[0];
        upper[1] = one_data[1];
        upper[2] = '\0';
        lower[0] = one_data[2];
        lower[1] = one_data[3];
        lower[2] = '\0';
	break;
    }
    data[0] = (unsigned char)atoi16(upper);
    data[1] = (unsigned char)atoi16(lower);    
}
/***** END OF GET_ANGLE FUCNTION **************************************/


/***** GET_ANGLE FUCNTION *********************************************/
void get_angle2(int angle, unsigned char *data, double flg1, double flg2)
{
    /***** INTERNALDATA *****/
    unsigned char u,l;
    int i;
    char one_data[10] ;
    char upper[3];
    char lower[3];

    /***** PROCESS *****/
    one_data[0] ='\0';
    angle = (int)((double)(angle/100)*flg1)/flg2;   /* degree(int) to (10)     */
    angle = HOME + angle;       /* 8000(16) + degree->(16) */ 
    
    itoa16(angle,one_data);

    switch(strlen(one_data)) {
    case 1:
        upper[0] = '0';
        upper[1] = '0';
        upper[2] = '\0';
        lower[0] = '0';
	lower[1] = one_data[0];
        lower[2] = '\0';
        break;
    case 2:
	upper[0] = '0';
        upper[1] = '0';
        upper[2] = '\0';
        lower[0] = one_data[0];
        lower[1] = one_data[1];
        lower[2] = '\0';
        break;
    case 3:
	upper[0] = '0';
        upper[1] = one_data[0];
        upper[2] = '\0';
        lower[0] = one_data[1];
        lower[1] = one_data[2];
        lower[2] = '\0';
	break;
    case 4:
	upper[0] = one_data[0];
        upper[1] = one_data[1];
        upper[2] = '\0';
        lower[0] = one_data[2];
        lower[1] = one_data[3];
        lower[2] = '\0';
	break;
    }
    data[0] = (unsigned char)atoi16(upper);
    data[1] = (unsigned char)atoi16(lower);    
}
/***** END OF GET_ANGLE FUCNTION **************************************/


/***** ITOA16 FUCNTION ************************************************/
void itoa16(int n, char *s)
{
    /***** INTERNALDATA *****/
    int i,sign, x;
    
    /***** PROCESS *****/
    if((sign = n) < 0){
	n = -n;
    }
    
    i=0;
    do{
        if((x = n%16) < 10){
	    s[i++] = x + '0';
	}
        else{
	    s[i++] = x-9 + '@';
	}
    } while ((n /= 16) > 0);
    
    if(sign < 0){
	s[i++] = '-';
    }
    s[i] = '\0';
    
    reverse(s);
}
/***** END OF ITOA16 FUCNTION *****************************************/


/***** REVERSE FUCNTION ***********************************************/
void reverse(char *s)
{
    /***** INTERNALDATA *****/
    int c,i,j;
    
    /***** PROCESS *****/
    for (i = 0, j= strlen(s)-1; i < j;i++, j--){
        c = s[i];
        s[i] = s[j];
        s[j] = c;
    }
}
/***** END OF REVERSE FUCNTION ****************************************/


/***** ATOI16 FUNCTION ************************************************/
int atoi16(char *code)
{
    /***** INTERNALDATA *****/
    int i, j,tmp, data;

    /***** PROCESS *****/
    data = 0;
    
    for(i=strlen(code)-1, j=0; i>=0; i--,j++){
	if(code[i] < 0x40){
	    tmp = code[i] - 0x30;
	}
	else{
	    tmp = 9 + code[i] - 0x40;
	}
	data = tmp*pow(16,j)+data;
    }
    
    return data;
}
/***** END FO ATOI16 FUNCTION *****************************************/


void plusCheckSum(unsigned char *code, unsigned char *newcode)
{
    int num,i,total,amari,checksum;

    total = 0;

    num = code[0];
    for(i = 0; i<num; i++){
        total += code[i];
        newcode[i] = code[i];
    }
    amari = total%256;
    checksum = 256-amari;
    newcode[num] = checksum;
}


/****** NOTIFY FUNCTION ***********************************************/
void notify(void)
{
    /***** INTERNALDATA *****/
    int nfds;
    fd_set readfds;
    unsigned char len[1];
    unsigned char buf[1024];
    struct timeval tv;
    int n = 0;
    
    /***** PROCESS *****/
    tv.tv_sec = 0;
    tv.tv_usec = 100;

    FD_ZERO(&readfds);              /* Initialize fdset               */
    FD_SET(fd,&readfds);            /* Set socket_fd to fdset         */
    nfds = select(FD_SETSIZE,&readfds, NULL, NULL, &tv);
                                    /* Select Process                 */
    if(nfds > 0){
	/* reply */

	n = read(fd, len, lest+1);
	//printf("notify READ = %d , %d,  n = %d, [read_code]\n",lest, len[lest], n);
	n = read(fd, buf, (int)len[lest]);
	lest = len[lest]-n;
	
	//printf("lest = %d , %d [read_code]\n",lest, buf[0]);

/*	while(lest > 0){
	    //printf("checker \n");
	    n = read(fd, buf, lest);
	    lest = lest - n;
	}*/

	/* ACK */
	if(n > 0) {
	    //printf("go ACK\n");
	    VCack(buf[0]);
	}
    }
}
/***** END NOTIFY FUNCTION ********************************************/
    



