/* %%%                                      %%%
 * %%%   CameraServer.c                     %%%
 * %%%   Copyright (C) 1999 Fumio Mizoguchi %%%
 * %%%                                      %%%
 */

#include <string.h>
#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <sys/stat.h>
#include <netinet/in.h>
#include <netdb.h>
#include <sys/termio.h>
#include <fcntl.h>
#include "VCclient.h"

#define streq(a,b) (!(strcmp(a,b)))

typedef struct{
    char label[32];
    char IP[16];
    int  port;
}Comm_Data;

void getdata(char *);

struct sockaddr_in   soin; 
struct servent       *sp; 
struct hostent       *hp; 
Comm_Data scout,image,image2,image3,hoge_read,hoge_write,camera_server;

int   fromlen;
int   ss = -1;
struct sockaddr_in   soin,from;
struct servent *sp;

void main(int argc, char **argv)
{
    int port = 19001;
    int c,sn,fd,i,locate[2], check ;
    unsigned char  code[100];
    char buf[20],*filename;
    
    filename = "../communication.dat";
    getdata(filename);

    if(argc == 1) port = camera_server.port;
    else {
        port = atoi(argv[1]);
    }
    fprintf(stderr,"port = %d\n",port);

    fd = VCsetup("/dev/ttya");
    VCpoint(200,-1890);
    VCpoint(0,0);
    for(;;){
        sn = socket_server(port);
	c = 1;
        while(c) {
	    socket_read(sn, buf);
	    //printf("%s\n",buf); 
	    check = make_command(buf, code);
	    if(check<=0){
                printf("connection closed\n");
                if(buf[0] == '\0'){
                    c = -1;
		    close(sn);
		    break; 
                } 
            }
	    socket_send(sn,"ok;");

	}
    }
}

int socket_server(port)
int port;
{
    int   sn;
    int   s_port = port;
    
    if(ss < 0){
        ss = socket(AF_INET, SOCK_STREAM, 0);
        if(ss < 0){
            fprintf(stderr, "rwriteed: socket\n");
            exit(1);
        }
        soin.sin_family = AF_INET;
        soin.sin_port = s_port;
        soin.sin_addr.s_addr = INADDR_ANY;/*{133.31.108.183};*/

        while(bind(ss, (caddr_t)&soin, sizeof(soin)) < 0){
            fprintf(stderr, "rwrited: bind\n");
            exit(1);
        }
        if(listen(ss,5) < 0){
            fprintf(stderr, "rwrited: listen\n");
            exit(1);
        }
    }
    
    printf("accept wait\n");
    fromlen = sizeof(from);
    sn = accept(ss, &from, &fromlen);
    if(sn < 0){
        fprintf(stderr, "rwrited: accept\n"); 
    }
    printf("socket connect !!\n");
    return sn;
}

int socket_read(int sn, char *buf)
{
    buf[0] = '\0';
    read(sn,buf,20);
    return 0;
}


int socket_send(int sn, char *buf)
{
    write(sn,buf,strlen(buf));
    return 0;
}

int make_command(char *command, unsigned char *code)
{
    int i, check;
    unsigned char param[20];
    check = get_parameta(command, param);
    if(check) plusCheckSum(param,code);
    return check;
}

int get_parameta(char *command, unsigned char *code)
{
    int com_len, i, data[10];
    char com[3];
    get_com(command, com);
    com_len = strlen(com);

    if(strcmp(com,"ST") == 0 || strcmp(com,"st") == 0){
	VCstop();
    }
    else if(strcmp(com,"PT") == 0 || strcmp(com,"pt") == 0){
	atoi_data(com_len, command, data);
	VCmove(data[1],data[2]);
    }
    else if(strcmp(com,"SP") == 0 || strcmp(com,"sp") == 0){
	VCspeed(20, 10);
    }
    else if(strcmp(com,"ZSP") == 0 || strcmp(com,"zsp") == 0){
	VCzspeed(1);
    }
    else if(strcmp(com,"MV") == 0 || strcmp(com,"mv") == 0){
	atoi_data(com_len, command, data);
	fprintf(stderr,"sending mesg.");
	VCpoint(data[1],data[2]);
	fprintf(stderr, "  done.\n");
    }
    else if(strcmp(com,"HP") == 0 || strcmp(com,"hp") == 0){
	VChome();
    }
    else if(strcmp(com,"ZW") == 0 || strcmp(com,"zw") == 0){
	VCzmove(0);
    }
    else if(strcmp(com,"ZT") == 0 || strcmp(com,"zt") == 0){
	VCzmove(1);
    }
    else if(strcmp(com,"ZH") == 0 || strcmp(com,"mv") == 0){
	VCzspeed(7);
	VCzhome();
    }
    else if(strcmp(com,"ZST") == 0 || strcmp(com,"zst") == 0){
	VCzstop();
    }
    else return -1;
    return 1;
}


get_com(char *command, char *com)
{
    int c, p;
    p = 0;
    c = 1;
    while(c) {
        switch(command[p]){
        case ' ':
        case '\n':
            com[p] = '\0';
            c = 0;
            break;
        case '0': 
        case '1': 
        case '2':
        case '3': 
        case '4': 
        case '5':
        case '6':
        case '7':
        case '8':
        case '9':
            //printf("check\n");
            com[p] = '\0';
            c = 0;
            break;
        case '\0':
            com[p] = '\0';
            c = 0;
            break;
        default:
            com[p] = command[p];
            p ++;
            if(sizeof(com) <= p) c = 0;
            else if(sizeof(command) <= p){
                com[p] = '\0';
                c = 0;
            }
            break;
        }
    }
}

int get_one_data(char *atom_data, char *one_data, int n)
{
    int c,p;

    p = 0;
    c = 1;
    while(c) {
        switch(atom_data[n]){
        case '\0':
        case '\n':
            one_data[p] = '\0';
            c = 0;
            break;
        default:
            if(atom_data[n] != ' '){
                one_data[p] = atom_data[n];
                p ++;
            }
            n ++;
            if(sizeof(one_data) <= p) c = 0;
            else if(sizeof(atom_data) <= p){
                one_data[p] = '\0';
                c = 0;
            }
            break;
        }
    }
    return n;
}


atoi_data(int n, char *buf, int *i_data)
{
    int c,p,num;
    char atom[20];

    c = 1;
    num = 1;
    p = 0;

    while(c){

        switch(buf[n]){
        case ':':
        case '\0':
        case '\n':
            if(p != 0){
                atom[p] = '\0';
                i_data[num] = atoi(atom);
                num ++;
            }
            i_data[0] = num - 1;
            c = 0;
            break;
        case ',':
            atom[p] = '\0';
            i_data[num] = atoi(atom);
            num ++;
            n ++;
            p = 0;
            break;
        default:
            atom[p] = buf[n];
            n ++;
            p ++;
            break;
        }
    }
}


void getdata(char *filename)
{
    FILE *fp;
    char buff[256],*ap,*pp;
    int  i;

    if((fp = fopen(filename,"r")) == NULL){
	fprintf(stderr, "file cannot open. [%s]\n",filename);
	exit(1);
    }
    
    
    while(fgets(buff,256,fp) != NULL){
	if((ap = strchr(buff,':')) == NULL) continue; 
	*ap = '\0';
	ap++;
	if((pp = strchr(ap,':')) == NULL) continue;
	*pp = '\0';
	pp++;

	if(streq(buff,"scout")){
	    strcpy(scout.label,buff);
	    strcpy(scout.IP,ap);
	    scout.port = atoi(pp);
	}
	else if(streq(buff,"image")){
	    strcpy(image.label,buff);
	    strcpy(image.IP,ap);
	    image.port = atoi(pp);
	}
	else if(streq(buff,"image2")){
	    strcpy(image2.label,buff);
	    strcpy(image2.IP,ap);
	    image2.port = atoi(pp);
	}
	else if(streq(buff,"image3")){
	    strcpy(image3.label,buff);
	    strcpy(image3.IP,ap);
	    image3.port = atoi(pp);
	}
	else if(streq(buff,"hoge_read")){
	    strcpy(hoge_read.label,buff);
	    strcpy(hoge_read.IP,ap);
	    hoge_read.port = atoi(pp);
	}
	else if(streq(buff,"hoge_write")){
	    strcpy(hoge_write.label,buff);
	    strcpy(hoge_write.IP,ap);
	    hoge_write.port = atoi(pp);
	}
	else if(streq(buff,"camera_server")){
	    strcpy(camera_server.label,buff);
	    strcpy(camera_server.IP,ap);
	    camera_server.port = atoi(pp);
	}
	for(i=0; i<256; i++) buff[i] = '\0';
    }

    fclose(fp);

}







