/* %%%                                      %%%
 * %%%   SocketConnect.java                 %%%
 * %%%   Copyright (C) 1999 Fumio Mizoguchi %%%
 * %%%                                      %%%
 */

import java.lang.*;
import java.net.*;
import java.io.*;

class SocketConnect {
    Socket socket = null;
    ServerSocket serversocket = null;
    BufferedReader datainput = null;       // $BF~NOMQ%9%H%j!<%`(B
    DataInputStream in = null ;         // $BF~NOMQ%9%H%j!<%`(B

    OutputStreamWriter dataoutput = null;  // $B=PNOMQ%9%H%j!<%`(B


    SocketConnect(){
    }

    /* $B%5!<%P!<MQ%=%1%C%H@\B3(B */
    boolean ServerConnect(int port){
	if(serversocket == null){
	    try{
		serversocket = new ServerSocket(port);
	    }
	    catch(IOException e){
		System.out.println("Can not open socket");
		return false;
	    }
	}
        try {
            socket = serversocket.accept();
	    datainput = new BufferedReader(
                        new InputStreamReader(socket.getInputStream()));
            dataoutput = new OutputStreamWriter(socket.getOutputStream());

        }
        catch(Exception e) { 
            System.out.println("Exception caught:" + e.getMessage() );
            e.printStackTrace();
	    return false;
        }
	return true;
    }

    /* $B%/%i%$%"%s%HMQ%=%1%C%H@\B3(B */
    boolean ClientConnect(String host, int port){
        try{
            socket = new Socket(host, port);
        }
        catch(IOException e){
            System.out.println("Can not open socket");
            System.out.println("Please Run Server Applet!!");
        }
        try {
	    datainput = new BufferedReader(
                        new InputStreamReader(socket.getInputStream()));
            dataoutput = new OutputStreamWriter(socket.getOutputStream());
	    in = new DataInputStream
              ( new BufferedInputStream(socket.getInputStream()));
        }
        catch(Exception e) { 
            System.out.println("Exception caught:" + e.getMessage() );
            e.printStackTrace();
	    return false;
        }
	return true;
    }

    /* $B%a%C%;!<%8Aw?.(B */
    public synchronized boolean Send(String Message) {
        try {
            dataoutput.write(Message + "\n");
            dataoutput.flush();
        }
        catch(Exception e) {
	    return false;
	}
	return true;
    }

    public synchronized boolean SendKLIC(String Message) {
	System.out.println("sendKLIC = "+Message);
        try {
            dataoutput.write(Message);
            dataoutput.flush();
	    // System.out.println("Message :"+Message);
        }
        catch(Exception e) {
	    return false;
	}
	return true;
    }

    /* $B%a%C%;!<%8<u?.(B */
    public synchronized String Read() {
        String readstring = null;
        try{
            readstring = datainput.readLine();
        }
        catch(Exception e) {
            System.out.println("Can't read message !!!");
	    return null;
        }
        return (readstring);
    }

    /* $B%a%C%;!<%8<u?.(B */
    public synchronized int  readint() {
	String getS = null;
        int read_int = 0;
        try{
            getS = datainput.readLine();
	    read_int = Integer.valueOf(getS).intValue();
        }
        catch(Exception e) {
            System.out.println("Can't read message !!!");
	    return -1;
        }
        return (read_int);
    }

    public synchronized String ReadKLIC() {
        String readstring = null;
	char b[] = new char[1024];
        try{
            int num = datainput.read(b,0,b.length);
	    String S = new String(b,0,num);
	    readstring = S;
	    // System.out.println("num = "+num+"  , "+S);
        }
        catch(Exception e) {
            System.out.println("Can't read message !!!");
	    return null;
        }
        return (readstring);
	
    }

    /* $B%=%1%C%H$N3+J|(B */
    public void Close() {
        try{
	    if(socket != null) socket.close();
	    socket = null;
            System.out.println("connect close");
        }
        catch(Exception e){
	    System.out.println("connect close MISS");
	}
    }
    public void serverClose() {
        try{
            if(serversocket != null) serversocket.close();
	    serversocket = null;
            System.out.println("connect close");
        }
        catch(Exception e){
	    System.out.println("connect close MISS");
	}
    }
}



