// Copyright (C) 1996-1999 Buntarou Shizuki(shizuki@is.titech.ac.jp)

#include <amulet/am_io.h>
  
#include <amulet/formula_advanced.h>
#include <amulet/standard_slots.h>
#include <amulet/opal_advanced.h>
#include <amulet/value_list.h>
#include <amulet/inter_advanced.h> // to get Am_Initialize_Interactors
#include <amulet/widgets_advanced.h>

#include <amulet/object_advanced.h>
#include <amulet/gdefs.h>
#include <amulet/gem.h>

#include "parse.h"

#define TOP_LEFT	30
#define TOP_TOP		30
//#define TOP_WIDTH	620
//#define TOP_HEIGHT	700
#define TOP_WIDTH	620
#define TOP_HEIGHT	500
//#define CONTROL_LEFT
//#define CONTROL_TOP
#define CONTROL_WIDTH	TOP_WIDTH
#define CONTROL_HEIGHT	64

#define DIALOG_HEIGHT	0	// 100

//
//
//
static int top_left_init	= TOP_LEFT;
static int top_top_init		= TOP_TOP;
static int top_width_init	= TOP_WIDTH;
static int top_height_init	= TOP_HEIGHT;

static Am_Object T_top;
static Am_Object T_top2;

static Am_Object T_menu;
/*static*/ Am_Object T_canvas;
static Am_Object T_control;
static Am_Object T_dialog;
static Am_Object T_board;

static Am_Object Pnode;

Am_Object ToggleCommand;
/*
static Am_Object_Method do_quit;
static Am_Object_Method do_start;
static Am_Object_Method do_stop;
static Am_Object_Method do_step;
static Am_Object_Method do_redraw;
static Am_Object_Method do_update_monitor;
static Am_Object_Method do_animation;
static Am_Object_Method do_show_continuous;
static Am_Object_Method do_draw_links;
static Am_Object_Method do_draw_fixed_links;
*/
/*
static void do_quit(Am_Object cmd);
static void do_start(Am_Object cmd);
static void do_stop(Am_Object cmd);
static void do_step(Am_Object cmd);
static void do_redraw(Am_Object cmd);
static void do_update_monitor(Am_Object cmd);
static void do_animation(Am_Object cmd);
static void do_show_continuous(Am_Object cmd);
static void do_draw_links(Am_Object cmd);
static void do_draw_fixed_links(Am_Object cmd);
*/
static Am_Object create_Top();
static Am_Object create_Top2();
static Am_Object create_MenuBar();
static Am_Object create_Canvas();
static Am_Object create_Control();
static Am_Object create_Dialog();
static Am_Object create_Interface();

static Am_Object create_Pnode();

static void Initializa_ToggleCommand();


Am_Slot_Key CONTROL_STATE = Am_Register_Slot_Name("CONTROL_STATE");
//static int window_current_state = WINDOW_STATE_INIT;
void
window_set_state(int new_state)
{
  if (T_control.Valid())
    T_control.Set(CONTROL_STATE, new_state);
}

int
window_get_state()
{
  if (T_control.Valid())
    return T_control.Get(CONTROL_STATE);
  return WINDOW_STATE_INIT;	// XXX
}

Am_Define_String_Formula(start_button_label)
{
  if (T_control.Valid()) {
    int state = (int)T_control.GV(CONTROL_STATE);
    if (state == WINDOW_STATE_INIT)
      return (Am_String)"Start";
    if (state == WINDOW_STATE_STOPPED)
      return (Am_String)"Continue";
  }
  return (Am_String)"Continue";	// This must be "Continue" not "Start"...
}  

Am_Define_Formula(bool, start_button_active)
{
  if (T_control.Valid()) {
    int state = (int)T_control.GV(CONTROL_STATE);
    return state == WINDOW_STATE_INIT || state == WINDOW_STATE_STOPPED;
  }
  return false;
}

Am_Define_Formula(bool, step_button_active)
{
  if (T_control.Valid()) {
    int state = (int)T_control.GV(CONTROL_STATE);
    return (state == WINDOW_STATE_INIT
	    || state == WINDOW_STATE_RUNNING
	    || state == WINDOW_STATE_STOPPED);
  }
  return true;
}

Am_Define_Formula(bool, stop_button_active)
{
  if (T_control.Valid()) {
    int state = (int)T_control.GV(CONTROL_STATE);
    return state == WINDOW_STATE_RUNNING;
  }
  return false;
}

//
//
//
#ifndef DEMO
Am_Cursor my_cursor;
#endif

int 
window_create()
{
  Am_Initialize();

#ifndef DEMO
#define BUTTON_FONT  Am_Font("-*-courier-bold-r-*-*-20-*-*-*-*-*-*-*")
  Am_Button.Set(Am_FONT, BUTTON_FONT);
  Am_Button_Panel.Set(Am_FONT, BUTTON_FONT);

  Am_Image_Array huge_cursor, huge_mask;
  huge_cursor = Am_Image_Array("/home/nsk/shizuki/lib/X11/bitmaps/huge-cursor.xbm");
  if (! huge_cursor.Valid()) {
    printf("Window_create: can't create huge_cursor image\n");
    exit(1);
  }
  huge_mask = Am_Image_Array("/home/nsk/shizuki/lib/X11/bitmaps/huge-mask.xbm");
  if (! huge_mask.Valid()) {
    printf("Window_create: can't create huge_cursor mask image\n");
    exit(1);
  }
  my_cursor = Am_Cursor(huge_cursor, huge_mask, Am_Blue, Am_Red);
#endif

  My_Amulet_Initialize();
  Initializa_ToggleCommand();
  Initialize_ZoomingText();
  Initialize_Pop_Up_Menu();
  Initialize_KL_Widgets();

/*
  T_top2 = create_Top2();	Am_Screen.Add_Part(T_top2);
  T_board = create_Interface(); T_top2.Add_Part(T_board);
*/
  T_top = create_Top();		Am_Screen.Add_Part(T_top);
  T_menu = create_MenuBar();	T_top.Add_Part(T_menu);
  T_canvas = create_Canvas();	T_top.Add_Part(T_canvas);
  T_dialog = create_Dialog();	/*T_top.Add_Part(T_dialog);*/
  T_control = create_Control();	T_top.Add_Part(T_control);

  draw_init();

  Pnode = create_Pnode();
  return 0;
}

int
window_init()
{
  window_set_state(WINDOW_STATE_INIT);
  return 0;
}

int
window_main()
{
  //  change_process_proto();
  Am_Main_Event_Loop();

  return 0;
}

int
window_draw(Am_Slot_Key slot, Am_Object &obj)
{
  T_canvas.Add_Part(slot, obj);
  return 0;
}

static int mode_skip_window_update = 0;

int
window_update()
{
  if (! mode_skip_window_update)
    Am_Do_Events();		// ??? Is this enough?
  return 0;
}

int
window_clean()
{     
  Am_Cleanup();

  return 0;
}

//
//
//
static Am_Object
create_Top()
{
  Am_Object top = Am_Window.Create("tracer")
    .Set(Am_LEFT, top_left_init)
    .Set(Am_TOP, top_top_init)
    .Set(Am_WIDTH, top_width_init)
    .Set(Am_HEIGHT, top_height_init)
    .Set(Am_FILL_STYLE, Am_Motif_Gray)
    .Set(Am_TITLE, "Tracer")
    .Set(Am_ICON_TITLE, "KLIEG Tracer")
//    .Set(Am_CURSOR, my_cursor)
    ;
  return top;
}

//
//
//

Am_Define_Method(Am_Object_Method,
		 void, do_start, (Am_Object cmd))
{
  int ret;

  if (window_get_state() == WINDOW_STATE_INIT) {
    ret = subprocess_start();
    if (ret) {
      fprintf(stderr, "do_start: subprocess failed.\n");
      return;
    }
    sleep(1);
    subprocess_send_init();
  } else {
    // continuing...
    ret = subprocess_send("\n"); // XXX
  }
  window_set_state(WINDOW_STATE_RUNNING);

  //
  // do parsing
  //
  ret = subprocess_tracing();
  if (ret)
    ;
}

Am_Define_Method(Am_Object_Method,
		 void, do_stop, (Am_Object cmd))
{
  window_set_state(WINDOW_STATE_STOPPED);
}

Am_Define_Method(Am_Object_Method,
		 void, do_step, (Am_Object cmd))
{
  int ret;

  if (window_get_state() == WINDOW_STATE_INIT) {
    ret = subprocess_start();
    if (ret) {
      fprintf(stderr, "do_step: subprocess failed.\n");
      return;
    }
    sleep(1);
    subprocess_send_init();
  }
  window_set_state(WINDOW_STATE_STOPPED);

  //
  ret = subprocess_send("\n"); // XXX
  ret = subprocess_tracing();
}

Am_Define_Method(Am_Object_Method,
		 void, do_redraw, (Am_Object cmd))
{
  main_draw();
}

Am_Define_Method(Am_Object_Method,
		 void, do_quit, (Am_Object cmd)) {
  //  Am_Exit_Main_Event_Loop();
  exit(0);
}

Am_Define_Method(Am_Object_Method,
		 void, do_draw_links, (Am_Object cmd)) {
  mode_draw_links = !mode_draw_links; // XXX
}

Am_Define_Method(Am_Object_Method,
		 void, do_draw_fixed_links, (Am_Object cmd)) {
  mode_draw_fixed_links = !mode_draw_fixed_links;
}

#include "rproc.h"

Am_Define_Method(Am_Object_Method,
		 void, do_update_monitor, (Am_Object cmd)) {
  mode_update_monitor = !mode_update_monitor; // XXX
  if (mode_update_monitor)
    pstore_monitor();
}

// this should be implemented as something like a slider
Am_Define_Method(Am_Object_Method,
		 void, do_animation, (Am_Object cmd)) {
  mode_animation = !mode_animation; // XXX

  if (interpolation_step == 1) {
    interpolation_step = INTERPOLATION_STEP;
    CZNode::CZSetInterpolation(INTERPOLATION_STEP);
  } else {
    interpolation_step = 1;
    CZNode::CZSetInterpolation(1);
  }
}

Am_Define_Method(Am_Object_Method,
		 void, do_show_continuous, (Am_Object cmd)) {
  mode_show_continuous_change = ! mode_show_continuous_change;
}

static Am_Object
create_MenuBar()
{
  Am_Object menu = Am_Menu_Bar.Create("menu-bar")
    .Set(Am_LEFT, 0)
    .Set(Am_TOP, 0)
    .Set(Am_FONT, Am_Font(MENUBAR_FONT))
    .Set(Am_FILL_STYLE, Am_Motif_Gray)
    .Set(Am_ITEMS, Am_Value_List()
	 .Add(Am_Command.Create("file-menu")
	      .Set(Am_LABEL, "Files")
	      .Set(Am_ITEMS, Am_Value_List()
//		   .Add("Load")
//		   .Add("Reload")
		   .Add(Am_Command.Create("start button")
			.Set(Am_LABEL, start_button_label)
			.Set(Am_DO_METHOD, do_start)
			.Set(Am_ACTIVE, start_button_active))
		   .Add(Am_Command.Create("redraw button")
			.Set(Am_LABEL, "Redraw")
			.Set(Am_DO_METHOD, do_redraw)
			.Set(Am_ACTIVE, true))
		   .Add(Am_Command.Create("stop button")
			.Set(Am_LABEL, "Stop")
			.Set(Am_DO_METHOD, do_stop)
			.Set(Am_ACTIVE, stop_button_active))
		   .Add(Am_Command.Create("step button")
			.Set(Am_LABEL, "Step")
			.Set(Am_DO_METHOD, do_step)
			.Set(Am_ACTIVE, step_button_active))
		   .Add(Am_Menu_Line_Command.Create("my menu line"))
		   .Add(Am_Command.Create("quit-command")
			.Set(Am_DO_METHOD, do_quit)
			.Set(Am_LABEL, "Quit"))
		   )
	      )
// 	 .Add(Am_Command.Create("option-menu")
// 	      .Set(Am_LABEL, "Options")
// 	      .Set(Am_ITEMS, Am_Value_List()
// 		   .Add(Am_Command.Create()
// 			.Set(Am_LABEL, "Update Port Data")
// 			.Set(Am_DO_METHOD, do_update_monitor))
// 		   .Add(Am_Command.Create()
// 			.Set(Am_LABEL, "Animation")
// 			.Set(Am_DO_METHOD, do_animation))
// 		   .Add(Am_Command.Create()
// 			.Set(Am_LABEL, "Highlight Continuous Change")
// 			.Set(Am_DO_METHOD ,do_show_continuous))
// 		   .Add(Am_Command.Create()
// 			.Set(Am_LABEL, "Draw Links")
// 			.Set(Am_DO_METHOD, do_draw_links))
// 		   .Add(Am_Command.Create()
// 			.Set(Am_LABEL, "Draw Fixed Links")
// 			.Set(Am_DO_METHOD, do_draw_fixed_links))
// // 		   .Add(Am_Command.Create()
// // 			.Set(Am_LABEL, "Show Links Animation")
// // 			.Set(Am_ACTIVE,false))
// 		   )
// 	      )
	 .Add(Am_Command.Create("option-menu")
	      .Set(Am_LABEL, "Options")
	      .Set(Am_ITEMS, Am_Value_List()
		   .Add(ToggleCommand.Create()
			.Set(Am_TEXT, "Update Port Data")
			.Set(ToggleVar, (void*)&mode_update_monitor)
			.Set(Am_DO_METHOD, do_update_monitor))
		   .Add(ToggleCommand.Create()
			.Set(Am_TEXT, "Animation")
			.Set(ToggleVar, (void*)&mode_animation)
			.Set(Am_DO_METHOD, do_animation))
		   .Add(ToggleCommand.Create()
			.Set(Am_TEXT, "Highlight Continuous Change")
			.Set(ToggleVar, (void*)&mode_show_continuous_change))
		   .Add(ToggleCommand.Create()
			.Set(Am_TEXT, "Draw Links")
			.Set(ToggleVar, (void*)&mode_draw_links))
		   .Add(ToggleCommand.Create()
			.Set(Am_TEXT, "Draw Fixed Links")
			.Set(ToggleVar, (void*)&mode_draw_fixed_links))
		   )
	      )
/*
	 .Add(Am_Command.Create("help-menu")
	      .Set(Am_LABEL, "Help"))
*/
	 )
    ;

  return menu;
}

Am_Define_No_Self_Formula (int, canvas_win_left) {
  return 0;
}
Am_Define_No_Self_Formula (int, canvas_win_top) {
  return (int)T_menu.GV(Am_HEIGHT);
}
Am_Define_No_Self_Formula (int, canvas_win_width) {
  return T_top.GV(Am_WIDTH);
}
Am_Define_No_Self_Formula (int, canvas_win_height) {
  return (int) T_top.GV(Am_HEIGHT) - ((int) T_menu.GV(Am_HEIGHT)
				      + DIALOG_HEIGHT
				      + CONTROL_HEIGHT);
}

// Scroll Inner Width, Height
Am_Define_Formula(int, kl_scroll_inner_width) {
  int max_x = 0, comp_right;
  Am_Value_List components;
  Am_Object comp;
  components = self.GV(Am_GRAPHICAL_PARTS);
  for (components.Start(); !components.Last(); components.Next()) {
    comp = components.Get ();
    // compute how much of the component extends right of the origin
    comp_right = ((int)(comp.GV(Am_LEFT)) + (int)(comp.GV(Am_WIDTH)));
    max_x = imax (max_x, comp_right);
  }
  return imax(max_x, self.GV(Am_WIDTH));
}
Am_Define_Formula (int, kl_scroll_inner_height) {
  int max_y = 0, comp_bottom;
  Am_Value_List components;
  Am_Object comp;
  components = self.GV(Am_GRAPHICAL_PARTS);
  for (components.Start(); !components.Last(); components.Next()) {
    comp = components.Get ();
    // compute how much of the component extends below the origin
    comp_bottom = ((int)(comp.GV(Am_TOP)) + (int)(comp.GV(Am_HEIGHT)));
    max_y = imax (max_y, comp_bottom);
  }
  return imax(max_y, self.GV(Am_HEIGHT));
}

static Am_Object
create_Canvas()
{
  Am_Object canvas = Am_Scrolling_Group.Create("canvas")
    .Set(Am_LEFT, canvas_win_left)
    .Set(Am_TOP, canvas_win_top)
    .Set(Am_WIDTH, canvas_win_width)
    .Set(Am_HEIGHT, canvas_win_height)
    .Set(Am_FILL_STYLE, Am_Motif_Gray)
    .Set(Am_INNER_FILL_STYLE, Am_Motif_Light_Gray)
    .Set(Am_INNER_WIDTH, Am_Width_Of_Parts)
    .Set(Am_INNER_HEIGHT, Am_Height_Of_Parts)
//    .Set(Am_INNER_WIDTH, kl_scroll_inner_width)
//    .Set(Am_INNER_HEIGHT,kl_scroll_inner_height)
    ;

  //  Am_Initialize_Inspector(canvas);
  
  return canvas;
}

Am_Define_No_Self_Formula (int, control_win_left) {
  return 0;
}
Am_Define_No_Self_Formula (int, control_win_top) {
  return (int) T_menu.GV(Am_HEIGHT)
    + (int) T_canvas.GV(Am_HEIGHT)
      + (int) T_dialog.GV(Am_HEIGHT);
}
Am_Define_No_Self_Formula (int, control_win_width) {
  return T_top.GV(Am_WIDTH);
}
Am_Define_No_Self_Formula (int, control_win_height) {
  return CONTROL_HEIGHT;
}

Am_Define_Formula (void*, horizontal_layout_equally)
{
  int i = 0;
  int rank = 0;
  Am_Value_List components = (Am_Value_List) self.GV(Am_GRAPHICAL_PARTS);
  int fixed_width, fixed_height;
  get_fixed_sizes(self, components, cc, fixed_width, fixed_height);
  int max_rank, max_size;
  get_max_rank_and_size(self, cc, max_rank, max_size);
  int width = self.GV(Am_WIDTH);
  int height = self.GV(Am_HEIGHT);

  components.Start();
  while (!components.Last()) {
    Am_Object item = (Am_Object)components.Get ();
    if ((bool)item.GV(Am_VISIBLE))
      rank++;
    components.Next();
  }

  if (max_rank != 0 && rank > max_rank)
    rank = max_rank;

  int left = 0;
  int prev_left = 0;
  components.Start();
  for (i = 0; i < rank; i++) {
    Am_Object item = (Am_Object)components.Get ();
    if ((bool)item.GV(Am_VISIBLE)) {
      item.Set(Am_LEFT, left);
      item.Set(Am_TOP, 0);

      prev_left = left;
      left = left + (width-left) / (rank-i);

      item.Set(Am_WIDTH, left-prev_left);
      item.Set(Am_HEIGHT, height);

    }
    components.Next();
  }

  return NULL;
}

Am_Define_Formula (void*, vertical_layout_equally)
{
  int i = 0;
  int rank = 0;
  Am_Value_List components = (Am_Value_List)self.GV(Am_GRAPHICAL_PARTS);
  int fixed_width, fixed_height;
  get_fixed_sizes(self, components, cc, fixed_width, fixed_height);
  int max_rank, max_size;
  get_max_rank_and_size(self, cc, max_rank, max_size);
  int width = self.GV(Am_WIDTH);
  int height = self.GV(Am_HEIGHT);

  components.Start();
  while (!components.Last()) {
    Am_Object item = (Am_Object)components.Get ();
    if ((bool)item.GV(Am_VISIBLE))
      rank++;
    components.Next();
  }

  if (max_rank != 0 && rank > max_rank)
    rank = max_rank;

  int top = 0;
  int prev_top = 0;
  components.Start();
  for (i = 0; i < rank; i++) {
    Am_Object item = (Am_Object)components.Get ();
    if ((bool)item.GV(Am_VISIBLE)) {
      item.Set(Am_LEFT, 0);
      item.Set(Am_TOP, top);

      prev_top = top;
      top = top + (height-top) / (rank-i);

      item.Set(Am_WIDTH, width);
      item.Set(Am_HEIGHT, top-prev_top);

    }
    components.Next();
  }

  return NULL;
}

static Am_Object
create_Control()
{
  Am_Object control = Am_Button_Panel.Create("control")
    .Set(CONTROL_STATE, (int)WINDOW_STATE_INIT)
    .Set(Am_LEFT, control_win_left)
    .Set(Am_TOP, control_win_top)
    .Set(Am_WIDTH, control_win_width)
    .Set(Am_HEIGHT, control_win_height)
    .Set(Am_LAYOUT, horizontal_layout_equally)
    .Set(Am_FILL_STYLE, Am_Motif_Gray)
    .Set(Am_ITEMS, Am_Value_List()
	 .Add(Am_Command.Create("start button")
	      .Set(Am_LABEL, start_button_label)
	      .Set(Am_DO_METHOD, do_start)
	      .Set(Am_ACTIVE, start_button_active))
	 .Add(Am_Command.Create("redraw button")
	      .Set(Am_LABEL, "Redraw")
	      .Set(Am_DO_METHOD, do_redraw)
	      .Set(Am_ACTIVE, true))
	 .Add(Am_Command.Create("stop button")
	      .Set(Am_LABEL, "Stop")
	      .Set(Am_DO_METHOD, do_stop)
	      .Set(Am_ACTIVE, stop_button_active))
	 .Add(Am_Command.Create("step button")
	      .Set(Am_LABEL, "Step")
	      .Set(Am_DO_METHOD, do_step)
	      .Set(Am_ACTIVE, step_button_active)))
    .Get_Part(Am_INTERACTOR)
      .Set(Am_PRIORITY, 10)
      .Get_Owner()
    ;

//  Am_Initialize_Inspector(control);
//  Am_Text_Inspect(control);

  return control;
}
Am_Define_No_Self_Formula (int, dialog_win_left) {
  return 0;
}
Am_Define_No_Self_Formula (int, dialog_win_top) {
  return (int)T_menu.GV(Am_HEIGHT)
    + (int)T_canvas.GV(Am_HEIGHT);
}
Am_Define_No_Self_Formula (int, dialog_win_width) {
  return T_top.GV(Am_WIDTH);
}
Am_Define_No_Self_Formula (int, dialog_win_height) {
  return DIALOG_HEIGHT;
}

static Am_Object
create_Dialog()
{
  Am_Object dialog = Am_Group.Create("dialog")
    .Set(Am_LEFT, dialog_win_left)
    .Set(Am_TOP, dialog_win_top)
    .Set(Am_WIDTH, dialog_win_width)
    .Set(Am_HEIGHT, dialog_win_height);

  return dialog;
}

int
window_dialog()
{
  return 0;
}

int
window_tracing()
{
  return 0;
}

int
window_canvas_width()
{
  return T_canvas.Get(Am_WIDTH);
}

int
window_canvas_height()
{
  return T_canvas.Get(Am_HEIGHT);
}

void
window_highlight_object(Am_Object image,
			Am_Style line_style, Am_Style fill_style,
			int number, int msec1, int msec2)
{
  Am_Object window = (Am_Object)image.Get(Am_WINDOW);

  int left;
  int top;
  int width = image.Get(Am_WIDTH);
  int height = image.Get(Am_HEIGHT);
  Am_Translate_Coordinates(image, 0, 0, window, left, top);
  
  Am_Object rect = Am_Rectangle.Create("highlight")
    .Set(Am_LEFT, left)
    .Set(Am_TOP, top)
    .Set(Am_WIDTH, width)
    .Set(Am_HEIGHT, height)
    .Set(Am_LINE_STYLE, line_style)
    .Set(Am_FILL_STYLE, fill_style)
    ;

  int i;
  for (i = 0; i < number; i++) {
    window.Add_Part(rect);
    window_update();
    my_usleep(msec1*1000);
    window.Remove_Part(rect);
    window_update();
    my_usleep(msec2*1000);
  }
  rect.Destroy();
}

void
my_usleep(int useconds)
{
  timespec rqt;
  rqt.tv_sec = useconds / 1000000;
  rqt.tv_nsec = (useconds % 1000000) * 1000;
  nanosleep(&rqt, NULL);
}

//-----------------------------------------------------------------------------
Am_Object
Pnode_add(char *name)
{
  static int num = 0;
  Am_Object node = Pnode.Create(name)
    .Set(Am_LEFT, num*4)	// XXX
    .Set(Am_TOP, num*3)		// XXX
    .Set(PROC_NAME, name)
    ;
  T_board.Add_Part(node)
    ;
  num++;
  return node;
}

#define INTERFACE_LEFT		0
#define INTERFACE_TOP		0
#define INTERFACE_WIDTH		400
#define INTERFACE_HEIGHT	400

Am_Define_Formula(int, parent_width)
{
  Am_Object parent = self.GV_Owner();
  if (parent.Valid())
    return parent.GV(Am_WIDTH);
  else
    return 0;
}
Am_Define_Formula(int, parent_height)
{
  Am_Object parent = self.GV_Owner();
  if (parent.Valid())
    return (int)parent.GV(Am_HEIGHT);
  else
    return 0;
}
      
#define POOL_RATIO		(1.0 / 4)
#define DELIMITER_HEIGHT	3

Am_Define_No_Self_Formula(int, board_width)
{
  if (T_top2.Valid())
    return (int)T_top2.GV(Am_WIDTH);
  else
    return 10;
}
Am_Define_No_Self_Formula(int, board_height)
{
  if (T_top2.Valid())
    return (int)T_top2.GV(Am_HEIGHT);
  else
    return 10;
}

Am_Define_No_Self_Formula(int, pool_height)
{
  if (T_top2.Valid())
    return (int)((int)T_top2.GV(Am_HEIGHT) * POOL_RATIO - DELIMITER_HEIGHT);
  else
    return 10;
}

static Am_Object
create_Top2()
{
  Am_Object top = Am_Window.Create("interface")
    .Set(Am_LEFT, INTERFACE_LEFT)
    .Set(Am_TOP, INTERFACE_TOP)
    .Set(Am_WIDTH, INTERFACE_WIDTH)
    .Set(Am_HEIGHT, INTERFACE_HEIGHT)
    .Set(Am_FILL_STYLE, Am_Motif_Green)
    .Set(Am_TITLE, "Tracer Interface")
    .Set(Am_ICON_TITLE, "KLIEG Tracer Interface")
    .Set(Am_ICONIFIED, true)
    ;
  //  Am_Initialize_Inspector(top);

  Am_Object pool = Am_Rectangle.Create("pool")
    .Set(Am_LEFT, 0)
    .Set(Am_TOP, 0)
    .Set(Am_WIDTH, board_width)
    .Set(Am_HEIGHT, pool_height)
    .Set(Am_FILL_STYLE, Am_White)
    ;
  Am_Object delimiter = Am_Border_Rectangle.Create("pool_delimiter")
    .Set(Am_LEFT, 0)
    .Set(Am_TOP, pool_height)
    .Set(Am_WIDTH, board_width)
    .Set(Am_HEIGHT, DELIMITER_HEIGHT)
    .Set(Am_SELECTED, true)
    .Set(Am_FILL_STYLE, Am_Motif_Green)
    ;
  Am_Object group = Am_Group.Create("pool_group")
    .Set(Am_LEFT, 0)
    .Set(Am_TOP, 0)
    .Set(Am_WIDTH, board_width)
    .Set(Am_HEIGHT, Am_Height_Of_Parts)
    .Add_Part(pool)
    .Add_Part(delimiter)
    ;
  top.Add_Part(group);

  return top;
}

static Am_Object
create_Interface()
{
  Am_Object board_mover = Am_Move_Grow_Interactor.Create("board_mover")
    .Set(Am_START_WHERE_TEST, &Am_Inter_In_Part)
//    .Set(Am_WHERE_ATTACH, Am_ATTACH_NW)
    ;
  Am_Object board = Am_Group.Create("board")
    .Set(Am_LEFT, 0)
    .Set(Am_TOP, 0)
    .Set(Am_WIDTH, board_width)
    .Set(Am_HEIGHT, board_height)
    .Add_Part(board_mover)
    ;
  
  //  Am_Initialize_Inspector(board);
    
  return board;
}

Am_Define_String_Formula(pnode_parent_name)
{
  Am_Object parent = self.GV_Owner();
  if (parent.Valid())
    return (Am_String)parent.GV(PROC_NAME);
  else
    "";
}

Am_Slot_Key BACK_PART = Am_Register_Slot_Name("BACK_PART");
Am_Slot_Key CO_X = Am_Register_Slot_Name("CO_X");
Am_Slot_Key CO_Y = Am_Register_Slot_Name("CO_Y");

#define DEFAULT_CO_X ((double)0.20)
#define DEFAULT_CO_Y ((double)0.10)

Am_Define_Formula(double, pnode_co_x)
{
  Am_Object parent = self.GV_Owner();
  if (parent.Valid()) {
    int limit = (int)((int)parent.GV(Am_HEIGHT) * POOL_RATIO);
    int top = self.GV(Am_TOP);
    if (limit < top)
      return (double)self.GV(Am_LEFT)/(int)parent.GV(Am_WIDTH);
  }
  return DEFAULT_CO_X;
}
Am_Define_Formula(double, pnode_co_y)
{
  Am_Object parent = self.GV_Owner();
  if (parent.Valid()) {
    int limit = (int)((int)parent.GV(Am_HEIGHT) * POOL_RATIO);
    int top = self.GV(Am_TOP);
    if (limit < top) {
      int pool_height = (int)parent.GV(Am_HEIGHT) - limit;
      return (double)(top - limit) / pool_height;
    }
  }
  return DEFAULT_CO_Y;
}

#define PNODE_MIN_WIDTH 50
#define PNODE_MIN_HEIGHT 0

Am_Define_Formula(int, pnode_width)
{
  Am_Object parent = self.GV_Owner();
  if (parent.Valid()) {
    int percent = (int)(100 * (double)parent.GV(CO_X));
    return PNODE_MIN_WIDTH + percent;
  }
  return PNODE_MIN_WIDTH;
}
Am_Define_Formula(int, pnode_board_height)
{
  Am_Object parent = self.GV_Owner();
  if (parent.Valid()) {
    int percent = (int)(100 * (double)parent.GV(CO_X));
    return PNODE_MIN_HEIGHT + percent;
  }
  return PNODE_MIN_HEIGHT;
}
Am_Define_Style_Formula(pnode_style)
{
  Am_Object parent = self.GV_Owner();
  if (parent.Valid()) {
    int percent = (int)(100 * (double)parent.GV(CO_Y));
    return Am_Style::Halftone_Stipple(percent);
  }
  return Am_Gray_Stipple;
}

static Am_Object
create_Pnode()
{
/*
  Am_Object p_back = Am_Rectangle.Create("Pnode_back")
    .Set(Am_LEFT, 0)
    .Set(Am_TOP, 0)
    .Set(Am_WIDTH, pnode_width)
    .Set(Am_HEIGHT, pnode_height)
    .Set(Am_FILL_STYLE, Am_Motif_Gray)
    ;
*/
  Am_Object p_name = Am_Text.Create("Pnode_name")
    .Set(Am_TEXT, pnode_parent_name)
    .Set(Am_FONT, Am_Font("-*-helvetica-*-r-*--12-*"))
    .Set(Am_LINE_STYLE, Am_Blue)
    .Set(Am_LEFT, 0)
    .Set(Am_TOP, 0)
    .Set(Am_WIDTH, pnode_width)
    ;
  Am_Object p_board = Am_Rectangle.Create("Pnode_board")
    .Set(Am_WIDTH, pnode_width)
    .Set(Am_HEIGHT, pnode_board_height)
    .Set(Am_FILL_STYLE, pnode_style)
    ;
  Am_Object p = Am_Group.Create("Pnode")
    .Set(Am_WIDTH, Am_Width_Of_Parts)
    .Set(Am_HEIGHT, Am_Height_Of_Parts)
    .Set(PROC_NAME, "Pnode")
    .Set(CO_X, pnode_co_x)
    .Set(CO_Y, pnode_co_y)
    .Set(Am_LAYOUT, Am_Vertical_Layout)
//    .Add_Part(BACK_PART, p_back)
    .Add_Part(NAME_PART, p_name)
    .Add_Part(FRAME_PART, p_board)
    ;

  return p;
}

Am_Slot_Key ToggleVar = Am_Register_Slot_Name("ToggleVar");

Am_Define_Object_Formula(toggle_command_label)
{
  self.GV_Owner().GV_Owner().GV_Owner().GV(Am_VISIBLE);

  Am_String label;
  int *int_ptr;
  if (self.Valid()) {
    label = self.GV(Am_TEXT);
    int_ptr = (int*)(void*)self.GV(ToggleVar);
    if (int_ptr) {
      Am_Object command_label = Am_Group.Create()
	.Set(Am_LAYOUT, Am_Horizontal_Layout)
	.Set(Am_H_SPACING, 5)
	.Set(Am_WIDTH, Am_Width_Of_Parts)
	.Set(Am_HEIGHT, Am_Height_Of_Parts)
	.Add_Part(Am_Border_Rectangle.Create()
		  .Set(Am_WIDTH, 6)
		  .Set(Am_HEIGHT, 6)
		  .Set(Am_SELECTED, (bool)(*int_ptr)))
	.Add_Part(Am_Text.Create()
		  .Set(Am_FONT, Am_Font(MENUBAR_FONT)) // XXX
		  .Set(Am_TEXT, label))
	;	
      return command_label;
    } else {
      return label;
    }
  }
  return (Am_String)"TOGGLE COMMAND LABEL";
}

Am_Define_Method(Am_Object_Method,
		 void, toggle_command_method, (Am_Object cmd)) {
  //  cout << "-- toggle_command_method\n";
  
  int *int_ptr;
  if (cmd.Valid()) {
    int_ptr = (int*)(void*)cmd.Get(ToggleVar);
    if (int_ptr) {
      *int_ptr = !*int_ptr;
      //      cout << "--             changing value to " << *int_ptr << ".\n";
    }
  }
}

static void
Initializa_ToggleCommand()
{
  ToggleCommand = Am_Command.Create("toggle_command")
    .Set(ToggleVar, (void*)(int*)NULL)
    .Set(Am_TEXT, "")
    .Set(Am_LABEL, toggle_command_label)
    .Set(Am_DO_METHOD, toggle_command_method)
    ;
}

/* eof */
