// Copyright (C) 1996-1999 Buntarou Shizuki(shizuki@is.titech.ac.jp)

#include "tracer-types.h"

int
unify_term(rterm *t1, rterm *t2)
{
  int ret = 1;
  
  t1 = deref(t1);
  t2 = deref(t2);

  if (t1 == NULL || t2 == NULL) {
    ret = 1;			// unification failed
    goto tail;
  }

  if (t1->Type() != tt_variable && t2->Type() == tt_variable) {
    //
    // t1 <---> t2
    //
    rterm *t;
    t = t1; t1 = t2; t2 = t;
  }
  
  switch (t1->Type()) {
    ;				// for indentation
  case tt_variable: {
    term_variable *vp = (term_variable *) t1;
    if (t2->Type() == tt_variable) {
      term_variable *v2 = (term_variable *) t2;
      if (strcmp(vp->GetName(), v2->GetName()) == 0) // vp==v2 is sufficient?
	;
      else
	vp->SetContent(t2);
    } else
      vp->SetContent(t2);
    //
    // some processes my be activated
    // some processes are terminated
    //
    ret = 0;
    goto tail;
  }
  case tt_functor: {
    term_functor *f1, *f2;
    
    if (t2->Type() != tt_functor) {
      ret = 1;			// unification failed
      goto tail;
    }
    
    f1 = (term_functor *) t1;
    f2 = (term_functor *) t2;
    
    //if (strcmp(f1->GetName(), f2->GetName()) != 0)
    if (f1->GetName() != f2->GetName()) {
      ret = 1;
      goto tail;
    }
    if (f1->GetModule() != f2->GetModule()) {
      ret = 1;
      goto tail;
    }
    if (f1->GetArity() != f2->GetArity()) {
      ret = 1;
      goto tail;
    }
    
    int arity;
    Pix arg1, arg2;
    SLList<rterm *> args1, args2;
    
    arity = f1->GetArity();
    args1 = f1->GetArgs();
    args2 = f2->GetArgs();
    
    for (arg1 = args1.first(), arg2 = args2.first();
	 arg1 != 0 && arg2 != 0;
	 args1.next(arg1), args2.next(arg2)) {
      int ret;
      
      ret = unify_term(args1(arg1), args2(arg2));
      if (ret)
	goto tail;
    }
    ret = 0;
    goto tail;
  }
  case tt_cons: {
    term_cons *c1, *c2;

    if (t2->Type() != tt_cons) {
      ret = 1;
      goto tail;
    }

    c1 = (term_cons *) t1;
    c2 = (term_cons *) t2;

    ret = unify_term(c1->Car(), c2->Car());
    if (ret)
      goto tail;
    ret = unify_term(c1->Cdr(), c2->Cdr());
    if (ret)
      goto tail;

    ret = 0;
    goto tail;
  }
  case tt_nil: {
    if (t2->Type() != tt_nil)
      ret = 1;
    else
      ret = 0;
    goto tail;
  }
  case tt_vector:
    break;
  case tt_string:
    break;
  case tt_integer: {
/*
    term_integer *i1, *i2;

    if (t2->Type() != tt_integer)
      return 1;

    i1 = (term_integer *) t1;
    i2 = (term_integer *) t2;

    if (i1->GetValue() != i2->GetValue())
      return 1;
    
    return 0;
*/
    // assume that two term_integers with same value
    // are allocated at same address
    ret = (t1 != t2);
    goto tail;
  }
  case tt_real:
    break;
  case tt_unknown:
  default:
    ret = 1;			// unification failed
    goto tail;
  }
  
 tail:
  if (ret && debug_unify) {
    printf("unify_term: unification failed:\n");
    printf("\tterm1[%s,%x]=%s\n",
	   t1->TermTypeStr(), t1, t1 ? t1->Get() : "NULL");
    printf("\tterm2[%s,%x]=%s\n",
	   t2->TermTypeStr(), t2, t2 ? t2->Get() : "NULL");
  }
  return ret;
}

//
// unify term
//
/*
   t1 : unbound
   t2 : unbound
   ---> t2 = t1

   t1 : unbound
   t2 : bound
   ---> t1 = t2

 */

/* eof */
