// -*- C++ -*-
// Copyright (C) 1996-1999 Buntarou Shizuki(shizuki@is.titech.ac.jp)

#include "parse.h"

#ifndef _rproc_h
#define _rproc_h

#define pstore_init	rproc::Pstore_init
#define pstore_create	rproc::Pstore_create
#define pstore_get	rproc::Pstore_get
#define pstore_monitor	rproc::Pstore_monitor_ports

#define MINIMUM_SIZE		10
#define EXPANSION_DEFAULT	0
#define EXPANSION_PROC		1

class rproc : public CZNode {
  enum rproc_state {
    rproc_dead,
    rproc_running,
    rproc_blocked,
  };
  struct link {
    int drawn;
    char *my_slot;
    char *to_slot;
    rproc *to_proc;
  };
  struct port {
    char     *name;
    int       monitored;
    PortType  type;
    rterm    *term;
    Am_Object image;
  };

  int			procid;
  int			subid;
  char *		module;
  char *		name;
  Proc *		proc;
  rproc_state		state;
  int			creation_time;
  SubProc *		subproc;
  Rule *		rule;	// creator
  SLList<link *>	linklist;
  SLList<port *>	portlist;
  Am_Object		image;

  double		system_doi;
  double		doi;

  rproc *		parent;
  rproc *		leader;
  DLList<rproc *>	children, member;

  void			reorder();
  void			reorder_downward();
  void			reorder_rightward();

  void			set_children_coordinate();
  void			set_member_coordinate();
  void			set_member_coordinate_h();
  void			set_member_coordinate_v();
  void			set_member_coordinate_default();

  rproc *		GetParent() { return parent; }
  DLList<rproc *>	GetChildren() { return children; }
  void			AddChild(rproc *p) { children.append(p); }
  DLList<rproc *>&	GetMember() { return member; }
  void			AddMember(rproc *p) { member.append(p); }

  int			tmp_min_mode; // XXX
public:
			rproc(int id, char *m, char *n, int now, rproc *p_proc);
			~rproc() {}
  
  int			GetID() { return procid; }
  int			SetSubID(int id) { subid = id; }
  int			GetSubID() { return subid; }
  char *		GetModule() { return module; }
  char *		GetName() { return name; }
  Proc *		GetProc() { return proc; }
  SubProc *		GetSubProc() { return subproc; }
  void			SetSubProc(SubProc *sb) { subproc = sb; }
  rproc *		GetChild(int n);
  rproc *		GetLeader() { return leader; }
  void			SetLeader(rproc *l) {
    if (debug_setleader)
      if (l != NULL)
	printf("rproc::SetLeader: my(%s:%s(%d)) leader is %s:%s(%d)\n",
	       module, name, procid,
	       l->GetModule(), l->GetName(), l->GetID());
      else
	printf("rproc::SetLeader: my(%s:%s(%d)) leader is NULL:NULL(NaN)\n",
	       module, name, procid);
    leader = l; }
  Rule *		GetRule() { return rule; }
  void			SetRule(Rule *r) { rule = r; }
  void			SetLink(char *my_slot, char *to_slot, rproc *to_proc);
  SLList<link *>	GetLinks() { return linklist; }
  Am_Object 		Image() { return image; }
  Am_Object		VisiblePart();

  int			isalive() { return state != rproc_dead; }
  int			isrunning() { return state == rproc_running; }
  int			issuspended() { return state == rproc_blocked; }
  int			isdead() { return state == rproc_dead; }

  void			bind(SLList<rterm *> terms);
  void			bind_cont(SLList<rterm *> terms);
  SLList<port *>	get_ports() { return portlist; }
  rproc::port *		get_port(char *name);
  void			monitor_enable(char *name);
  void			monitor_disable(char *name);
  void			monitor_update();

  void			change_layout_top(int layout_id);
  void			change_layout(int layout_id);

  void			update();
  void			run();
  void			suspend();
  void			die();

  double		XMin();
  double		YMin();

  void			CalcDOI();
  void			RecalcQuality();
  void			update_system_doi();
  void			propagate_system_doi(double new_doi);

  double		getdoi();
  void			update_doi(double diff);
  void			update_doi_downward(double diff);
  void			set_doi(double value);
  void			set_doi_downward(double value);

  void			draw(int count, int limit, int visible);
  void			draw_links();

  int			do_grow();
  int			do_expand();
  int			do_auto();
  int			do_shrink();

  //
  // XXX
  //
  void			SetTmpMin();
  void			SetNormalMin();

  rproc *		pstore_next; // for linked list in Pstore
  static int		Pstore_init();
  static rproc *	Pstore_create(char *module, char *name,
				      rproc *parent, Rule *creator,
				      int now);
  static rproc *	Pstore_get(int id);
  static void		Pstore_monitor_ports();

  // for debuggin
  void			dump_member(int level);
  void			dump_children(int level);

  static int		debug_calcdoi;
  static int		debug_setleader;

public:
  int			haschildren() { return children.length(); }
  int			hasmember() { return member.length(); }
  int			expanding();
};

#endif

/* eof */
