// Copyright (C) 1996-1999 Buntarou Shizuki(shizuki@is.titech.ac.jp)

#include <amulet/am_io.h>
  
#include <amulet/formula_advanced.h>
#include <amulet/standard_slots.h>
#include <amulet/opal_advanced.h>
#include <amulet/value_list.h>
#include <amulet/inter_advanced.h> // to get Am_Initialize_Interactors
#include <amulet/widgets_advanced.h>

#include <amulet/object_advanced.h>
#include <amulet/gdefs.h>
#include <amulet/gem.h>
#include "rproc.h"

//#define QUALITY_MINIMUM 0.001
#define QUALITY_MINIMUM 0

int rproc::debug_calcdoi = 0;
int rproc::debug_setleader = 0;

extern Am_Object Am_Rproc;
extern Am_Object Am_Rlink;
extern Am_Object rgroup;
extern Am_Object rlinks;
extern Am_Object Stream_Monitor;

extern Am_Slot_Key RPROC;
extern Am_Slot_Key RPROC_MOVER_PART;
extern Am_Slot_Key RPROC_NORMAL;
extern Am_Slot_Key RPROC_SMALL;
extern Am_Slot_Key RPROC_LITTLE;
extern Am_Slot_Key CZSTATE;
extern Am_Slot_Key RPROC_SELECT;
extern Am_Slot_Key RPROC_BACK;
extern Am_Slot_Key PROC_PART;
extern Am_Slot_Key BL_SRC_NAME;
extern Am_Slot_Key BL_DEST_NAME;
extern Am_Slot_Key RPROC_POPUP;
extern Am_Slot_Key MONITOR_GROUP;
extern Am_Slot_Key MONITOR_DISMISS;
extern Am_Slot_Key MONITOR_CHECK;
extern Am_Slot_Key MONITOR_CONTENT;
extern Am_Slot_Key MONITOR_SCROLL;
extern Am_Slot_Key MONITOR_TEXT;

//Am_Declare_Formula(bool, rproc_normal_visible);
extern Am_Formula rproc_normal_visible;


rproc::rproc(int id, char *m, char *n, int now, rproc *p_proc)
{
  Am_Object normal_image;

  procid = id;
  module = m;
  name = n;
  proc = getProc(module, name, 0);
  // must be checked whether "proc" has a NULL value or not.
  parent = p_proc;
  leader = parent;		// XXX
  normal_image = proc->Image()
    .Set(Am_VISIBLE, rproc_normal_visible)
    ;
  state = rproc_running;
  creation_time = now;

  char title[1024];		// XXX
  sprintf(title, "%s:%s", module, name);
  //image = Am_Rproc.Create(title)
  image = Am_Rproc.Create(name)
    .Set(RPROC, (void *)this)
    .Set(CZNODE, (void *)this)
    //.Set(PROC_NAME, title)
    .Set(PROC_NAME, name)
    .Add_Part(RPROC_NORMAL, normal_image)
    ;
  CZwindow.Add_Part(image);

  //  if (debug_rproc)
  //    printf("new rproc(this=%x)\n", this);

  if (parent)
    doi = parent->getdoi();	// inherit parent's doi
  else
    doi = QUALITY_MINIMUM;		// for main process(default doi)
  CZSetDOI(doi);
  system_doi = 1;		// XXX exp(0) == 1
  CZSetMin(10, 10);		// XXX

//    if (strcmp(n, "dispatcher") == 0)
//      CZSetState(CZ_be_closed);

  tmp_min_mode = 0;		// XXX
}

#define PSTORE_HASH_SIZE 1021
static rproc *proc_table[PSTORE_HASH_SIZE];

int
rproc::Pstore_init()
{
  int i;
  for (i = 0; i < PSTORE_HASH_SIZE; i++) {
    proc_table[i] = NULL;
  }
  return 0;
}

rproc *
rproc::Pstore_create(char *module, char *name, rproc *p_proc, Rule *creator,
		     int now)
{
  static int next_id = 0;
  int i = next_id % PSTORE_HASH_SIZE;

  rproc *p = new rproc(next_id, module, name, now, p_proc);
  if (debug_rproc)
    printf("Rproc created %s:%s(%d)\n", module, name, next_id);
  next_id++;
  if (p == NULL)
    return NULL;

  if (p_proc)
    p_proc->AddChild(p);
  p->SetRule(creator);

  p->pstore_next = proc_table[i];
  proc_table[i] = p;

  return p;
}

rproc *
rproc::Pstore_get(int id)
{
  rproc *p;
  int i = id % PSTORE_HASH_SIZE;

  // Oh..., My!!
  for (p = proc_table[i]; p != NULL; p = p->pstore_next) {
    if (p->GetID() == id)
      return p;
  }
  return NULL;
}

void
rproc::Pstore_monitor_ports()
{
  if (window_get_state() == WINDOW_STATE_RUNNING)
    return;

  if (! mode_update_monitor)
    return;

  int i;
  rproc *p;
  if (debug_stream_monitor)
    printf("Monitoring...\n");
  
  for (i = 0; i < PSTORE_HASH_SIZE; i++) {
    for (p = proc_table[i];p != NULL;p = p->pstore_next) {
      p->monitor_update();
    }
  }
}

static void
draw_link(rproc *src_proc, char *src_name, rproc *dst_proc, char *dst_name)
{
  if (src_proc == dst_proc)
    return;			// XXX

  if (dst_proc->IsVisible()) {
    if (! mode_draw_fixed_links) {
      rproc::port *p = dst_proc->get_port(dst_name);
      if (p->term->isconcrete())
	return;
    }
    
    if (debug_link)
      printf("       %s to %s(%s:%s,%d)\n",
	     src_name, dst_name,
	     dst_proc->GetModule(), dst_proc->GetName(), dst_proc->GetID());

    Am_Object new_line = Am_Rlink.Create()
      .Set(BL_SRC, Proc_Get_Port(src_proc->Image().Get_Part(RPROC_NORMAL),
				 src_name))
      .Set(BL_SRC_NAME, src_name)
      .Set(BL_DEST, Proc_Get_Port(dst_proc->Image().Get_Part(RPROC_NORMAL),
				  dst_name))
      .Set(BL_DEST_NAME, dst_name)
      ;
    rlinks.Add_Part(new_line);
  } else {			// XXX: more checks should be needed
    Pix li;
    SLList<rproc::link *> linklist = dst_proc->GetLinks();
    for (li = linklist.first(); li != 0; linklist.next(li)) {
      rproc::link *link = linklist(li);
      if (strcmp(dst_name, link->my_slot) == 0)
	draw_link(src_proc, src_name, link->to_proc, link->to_slot);
    }
  }
}

void
rproc::draw_links()
{
  if (this == NULL)
    return;

  if (debug_link)
    printf("rproc::draw_links(%s:%s,%d)\n", module, name, procid);

  if (IsVisible()) {
    //
    // draw links emitting from this process
    //
    Pix i;
    for (i = linklist.first(); i != 0; linklist.next(i)) {
      rproc::link *link = linklist(i);
      char *src_name    = link->my_slot;
      draw_link(this, src_name, link->to_proc, link->to_slot);
    }
  }
  if (IsVisible() && CZGetStatus() == CZ_opened) {
    //
    // traverse process tree
    //
    Pix pi;
    for (pi = member.first(); pi != 0; member.next(pi))
      member(pi)->draw_links();
  }
}

void
rproc::run()
{
  state = rproc_running;
  image.Set(Am_FILL_STYLE, COLOR_RUNNING);
  if (leader && this != leader)	// XXX
    leader->run();
}

void
rproc::suspend()
{
  // check whether all live children are blocked or not
  Pix pi;
  for (pi = member.first(); pi != 0; member.next(pi)) {
    if (member(pi)->isrunning()) // XXX
      return;
  }
  state = rproc_blocked;
  image.Set(Am_FILL_STYLE, COLOR_SUSPENDED);
  if (leader)
    leader->suspend();
}

void
rproc::die()
{
  int all_dead = 1;

  Pix pi;
  for (pi = member.first(); pi != 0; member.next(pi)) {
    rproc *p = member(pi);
    if (p->isrunning())
      return;
    if (p->issuspended())
      all_dead = 0;
  }

  if (all_dead && procid == 0) {
    // main process is dead...
    state = rproc_dead;
    doi = 0;			// XXX
    CZSetDOI(0);		// XXX
//    update_doi(0);		// XXX
    image.Set(Am_FILL_STYLE, COLOR_DEAD);

  } else if (all_dead) {
    state = rproc_dead;
    doi = 0;			// XXX
    CZSetDOI(0);		// XXX
    leader->update_doi(0);	// XXX
    image.Set(Am_FILL_STYLE, COLOR_DEAD);
    if (leader)
      leader->die();
  } else {
    state = rproc_blocked;
    image.Set(Am_FILL_STYLE, COLOR_SUSPENDED);
    if (leader)
      leader->suspend();
  }
}

Am_Object
rproc::VisiblePart()
{
  Am_Object normal_image = image.Get_Part(RPROC_NORMAL);
  if (normal_image.Get(Am_VISIBLE))
    return normal_image;
  Am_Object small_image = image.Get_Part(RPROC_SMALL);
  if (small_image.Get(Am_VISIBLE))
    return small_image;
  Am_Object little_image = image.Get_Part(RPROC_LITTLE);
  if (little_image.Get(Am_VISIBLE))
    return little_image;
  return NULL;
}

void
rproc::bind(SLList<rterm *> terms)
{
  SLList<Port *> proc_ports = proc->GetPorts();
  Pix pi = proc_ports.first();
  Pix ti;
  for (ti = terms.first(); ti != 0; terms.next(ti)) {
    Port *proc_port = proc_ports(pi);
    port *p = new port();
    p->name = proc_port->name;
    if (proc_port->type==port_single_in || proc_port->type==port_single_out)
      p->monitored = 1;		// for single ports
    else
      p->monitored = 0;		// for stream ports
    p->type = proc_port->type;
    p->term = terms(ti);
    p->image = NULL;		// XXX
    portlist.append(p);
    proc_ports.next(pi);
  }
}

void
rproc::bind_cont(SLList<rterm *> terms)
{
  Pix pi = portlist.first();
  Pix ti;
  for (ti = terms.first(); ti != 0; terms.next(ti)) {
    port *p = portlist(pi);
    // update single ports only
    if (p->type==port_single_in || p->type==port_single_out)
      p->term = terms(ti);
    portlist.next(pi);
  }
}

rproc::port *
rproc::get_port(char *name)
{
  Pix pi;
  for (pi = portlist.first(); pi != 0; portlist.next(pi)) {
    port *p = portlist(pi);
    if (strcmp(p->name, name) == 0)
      return p;
  }
  return NULL;
}

void
rproc::monitor_enable(char *name)
{
  Pix pi;
  for (pi = portlist.first(); pi != 0; portlist.next(pi)) {
    port *p = portlist(pi);
    if (strcmp(p->name, name) == 0) {
      p->monitored = 1;
      monitor_update();
      return;
    }
  }
}

void
rproc::monitor_disable(char *name)
{
  Pix pi;
  for (pi = portlist.first(); pi != 0; portlist.next(pi)) {
    port *p = portlist(pi);
    if (strcmp(p->name, name) == 0) {
      p->monitored = 0;
      monitor_update();
      return;
    }
  }
  // something should be done for single ports
}

#ifndef DEMO
extern Am_Cursor my_cursor;
Am_Drawonable* Get_a_drawonable (Am_Object obj);
#endif

void
rproc::monitor_update()
{
  if (debug_stream_monitor)
    printf("        %s:%s(pid=%d)\n", module, name, procid);
  Pix pi;
  for (pi = portlist.first(); pi != 0; portlist.next(pi)) {
    port *p = portlist(pi);
    if (p->monitored) {
      rterm *t = p->term;
      // in texts
      if (debug_stream_monitor)
	printf("                %s: %s\n", p->name, t->Get());

      // in graphics
      if  (p->type == port_stream_in || p->type == port_stream_out) {
	if (! p->image.Valid()) {
	  p->image = Stream_Monitor.Create()
	    .Set(RPROC, this)
	    .Set(PORT_NAME, p->name)
	    ;
	  Am_Screen.Add_Part(p->image);
	}
	p->image.Set(MONITOR_TEXT, t->Get());
	p->image.Set(Am_VISIBLE, true);
      } else if (p->type == port_single_in || p->type == port_single_out) {
	Am_Object normal_image = image.Get_Part(RPROC_NORMAL);
	Am_Object single_port  = Proc_Get_Port(normal_image, p->name);
	if (! p->image.Valid()) {
	  p->image = Atom_Proto.Create();
	  Port_Add(single_port, p->image);
	}
	if (t->isatom()) {
	  char *content = t->Get();
	  p->image.Get_Part(CONTENTS_PART).Set(Am_TEXT, content);
	  // overlapping items must be moved a little
	} else if (t->isunbound()) {
	  p->image.Get_Part(CONTENTS_PART).Set(Am_TEXT, "?");
	  // overlapping items must be moved a little
	} else {
	  p->image.Get_Part(CONTENTS_PART).Set(Am_TEXT, "*");
	  //
	}
      }
    } else {
      //
      // monitoring of this port is disabled
      //
      if (p->type == port_single_in || p->type == port_single_out) {
	if (p->image.Valid()) {
	  Am_Object content = p->image.Get_Part(CONTENTS_PART);
	  Port_Remove_Value(content);
	}
      }
    }
  }
}

//
// layouting
//
void
rproc::change_layout_top(int layout_id)
{
  change_layout(layout_id);
  GetParent()->CZResection();
  CZNode::CZRedraw();
}

void
rproc::change_layout(int layout_id)
{
  //
  // XXX:we now refer to 'children' not member... is this right?
  //
  double area_max = 0;
  double area[children.length()];

  Pix pi;
  int i;
  for (pi = children.first(), i = 0; pi != 0; children.next(pi), i++) {
    rproc *child = children(pi);
    SLList<Layout *> layouts = child->GetSubProc()->GetLayout();
    Pix pj = layouts.first();
    for (int j = 0; j < layout_id; j++)
      layouts.next(pj);
    Layout *layout = layouts(pj);
    area[i] = layout->GetWidth() * layout->GetHeight();
    if (area[i] > area_max)
      area_max = area[i];
  }

  for (pi = children.first(), i = 0; pi != 0; children.next(pi), i++) {
    rproc *child = children(pi);
    double doif = area[i] / area_max;
    //doif = doif * doif;
    if (child->GetProc()->Type() == PROC_TYPE_PATTERN) {
      child->CZSetState(CZ_be_auto); // XXX
      child->set_doi(doi * doif);
      child->change_layout(layout_id);
    } else {
      child->set_doi_downward(doi * doif);
      if (area[i] < 20000) {	// XXX
 	child->CZSetState(CZ_be_closed); // XXX
      }
    }
  }
  CZMakeSection();		// XXX
}

//
// update parent-child tree
//
void
rproc::update()
{
  {
    int i = 0;
    Pix pi = children.first();
    Rule *creator = children(pi)->GetRule(); // XXX
    for (pi = children.first(); pi != 0; children.next(pi)) {
      rproc *child = children(pi);
      SubProc *sp = creator->GetBody(i);
      child->SetSubID(i);
      child->SetSubProc(sp);
      child->CalcDOI();
      i++;
    }
  }
  
  set_children_coordinate();

  // re-order children based on this process's arrangement requirement
  reorder();
  
  // update leader-member tree
  if (children.length() > 0) {
    if (parent && name == parent->GetName() && module == parent->GetModule()) {
      DLList<rproc *> &leader_member = leader->GetMember();

      // Pix j = leader_member.seek(this);
      Pix j;
      for (j = leader_member.first(); j != 0; leader_member.next(j)) {
	if (this == leader_member(j))
	  break;
      }
      if (j == 0) {
	printf("rproc::update: Something is wrong!!!\n");
	// exit(1);
      }
      Pix pi;
      for (pi = children.first(); pi != 0; children.next(pi)) {
	rproc *p = children(pi);
	leader_member.ins_before(j, p);
	p->SetLeader(leader);
	p->CZSetParent(leader);
	if (mode_creation_time)
	  p->update_system_doi();
      }

      // OLD: leader_member(j)->force_unvisible(); // XXX
      leader_member(j)->CZDeleteMember();
      leader_member.del(j);

      // reset members' coordinates
      leader->set_member_coordinate();

      // doi
      leader->update_doi(0);
      
      // re-section
      leader->CZResection();
    } else {
      // i am a leader...
      Pix pi;
      for (pi = children.first(); pi != 0; children.next(pi)) {
	rproc *p = children(pi);
	AddMember(p);
	p->SetLeader(this);
	p->CZSetParent(this);
	if (mode_creation_time)
	  p->update_system_doi();
      }

      update_doi(0);
      
      // set leader's default display method
      ExpandMethod m = proc->GetExpand();
      ArrangeOption opt = proc->GetArrangeOption();
      if (opt == arrange_default && m == expand_downward) {
	DisplayEllipsis *method = new DisplayEllipsis(this, ELLIPSIS_VERTICAL);
	CZSetMethod(method);
	method->update();
      }
      if (opt == arrange_default && m == expand_rightward) {
	DisplayEllipsis *method = new DisplayEllipsis(this, ELLIPSIS_HORIZONTAL);
	CZSetMethod(method);
	method->update();
      }

      // set members' coordinates
      set_member_coordinate();

      // re-section
      CZResection();
    }
  } else {
    // something is wrong...
  }
}

void
rproc::reorder()
{
  // re-order children based on this process's arrangement requirement
  ExpandMethod m = proc->GetExpand();
  if (m == expand_downward)
    reorder_downward();
  else if (m == expand_rightward)
    reorder_rightward();
}

void
rproc::reorder_downward()
{
  int i, j;
  int length = children.length();
  rproc *plist[length];

  Pix pi = children.first();
  for (i = 0; i < length; i++) {
    plist[i] = children(pi);
    children.next(pi);
  }

  for (j = 0; j < length; j++) {
    for (i = j+1; i < length; i++) {
      if (plist[j]->GetTop() > plist[i]->GetTop()) {
	// swap plist[j] and plist[i]
	rproc *tmp = plist[j];
	plist[j] = plist[i];
	plist[i] = tmp;
      }
    }
  }

  pi = children.first();
  for (i = 0; i < length; i++) {
    children(pi) = plist[i];
    children.next(pi);
  }
}

void
rproc::reorder_rightward()
{
  int i, j;
  int length = children.length();
  rproc *plist[length];

  Pix pi = children.first();
  for (i = 0; i < length; i++) {
    plist[i] = children(pi);
    children.next(pi);
  }

  for (j = 0; j < length; j++) {
    for (i = j+1; i < length; i++) {
      if (plist[j]->GetLeft() > plist[i]->GetLeft()) {
	// swap plist[j] and plist[i]
	rproc *tmp = plist[j];
	plist[j] = plist[i];
	plist[i] = tmp;
      }
    }
  }

  pi = children.first();
  for (i = 0; i < length; i++) {
    children(pi) = plist[i];
    children.next(pi);
  }
}

rproc *
rproc::GetChild(int n)
{
  Pix c;
  int i = 0;
  for (c = children.first(); c != 0; children.next(c)) {
//    if (n == i)
//      return children(c);
    if (children(c)->GetSubID() == n)
      return children(c);
    i++;
  }
  return NULL;
}

void
rproc::SetLink(char *my_slot, char *to_slot, rproc *to_proc)
{
  // check whether the same link was stored or not
  Pix li;
  for (li = linklist.first(); li != 0; linklist.next(li)) {
    link *l = linklist(li);
    if (strcmp(l->my_slot, my_slot) == 0
	&& strcmp(l->to_slot, to_slot) == 0
	&& l->to_proc == to_proc)
      return;
  }

  // this is a new link
  link *new_link = new link();

  new_link->drawn = 0;
  new_link->my_slot = my_slot;
  new_link->to_slot = to_slot;
  new_link->to_proc = to_proc;

  linklist.append(new_link);

  if (debug_trace)
    printf("Link: %s:%s(%d)::%s ---> %s:%s(%d)::%s\n",
	   module, name, procid, my_slot,
	   to_proc->GetModule(), to_proc->GetName(), to_proc->GetID(), to_slot);
}

//
// all memebers have same size horizontally aligned
//
void
rproc::set_member_coordinate()
{
  ExpandMethod m = proc->GetExpand();
  if (m == expand_downward)
    set_member_coordinate_v();
  else if (m == expand_rightward)
    set_member_coordinate_h();
  else
    set_member_coordinate_default();
}

#define PROC_MARGIN 4
void
rproc::set_member_coordinate_h()
{
  int m_length = GetAllLength();
  if (m_length < 1) {
    printf("rproc::set_member_coodinate_h: something wrong\n");
    return;
  }
  CZNode *p = GetAllFirst();
  double new_T = p->GetTop();
  double new_W = GetWidth()/(2*m_length + 1);
  double new_H = p->GetHeight();
  double new_L = new_W + GetLeft();

  for (/*p = GetAllFirst()*/; !IsAllDone(); p = GetAllNext()) {
    p->SetPoint(new_L, new_T);
    p->SetSize(new_W, new_H);
    new_L = new_L + 2*new_W;
  }
}

void
rproc::set_member_coordinate_v()
{
  int m_length = GetAllLength();
  if (m_length < 1) {
    printf("rproc::set_member_coodinate_v: something wrong\n");
    return;
  }
  CZNode *p = GetAllFirst();
  double new_L = p->GetLeft();
  double new_W = p->GetWidth();
  double new_H = GetHeight() / (2*m_length + 1);
  double new_T = new_H + GetTop();

  for (/*p = GetAllFirst()*/; !IsAllDone(); p = GetAllNext()) {
    p->SetPoint(new_L, new_T);
    p->SetSize(new_W, new_H);
    new_T = new_T + 2*new_H;
  }
}

#undef PROC_MARGIN

// #define PROC_MARGIN 4
// void
// rproc::set_member_coordinate_h()
// {
//   int m_length = GetLength();
//   if (m_length < 1) {
//     printf("rproc::set_member_coodinate_h: something wrong\n");
//     return;
//   }
//   CZNode *p = GetFirst();
//   double new_T = p->GetTop();
//   double new_W = GetWidth()/(2*m_length + 1);
//   double new_H = p->GetHeight();
//   double new_L = new_W + GetLeft();

//   for (/*p = GetFirst()*/; !IsDone(); p = GetNext()) {
//     p->SetPoint(new_L, new_T);
//     p->SetSize(new_W, new_H);
//     new_L = new_L + 2*new_W;
//   }
// }

// void
// rproc::set_member_coordinate_v()
// {
//   int m_length = GetLength();
//   if (m_length < 1) {
//     printf("rproc::set_member_coodinate_v: something wrong\n");
//     return;
//   }
//   CZNode *p = GetFirst();
//   double new_L = p->GetLeft();
//   double new_W = p->GetWidth();
//   double new_H = GetHeight() / (2*m_length + 1);
//   double new_T = new_H + GetTop();

//   for (/*p = GetFirst()*/; !IsDone(); p = GetNext()) {
//     p->SetPoint(new_L, new_T);
//     p->SetSize(new_W, new_H);
//     new_T = new_T + 2*new_H;
//   }
// }

// #undef PROC_MARGIN

void
rproc::set_member_coordinate_default()
{
  return;
}

int
rproc::do_grow()
{
  if (leader == NULL)
    // top level process can't grow any more
    return 1;

  update_doi_downward(+1);	// XXX
  CZSetState(CZ_be_auto);	// XXX
  CZResection();		// XXX
  //CZInitSection();		// XXX
  leader->update_doi(0);	// XXX
  return 0;
}

int
rproc::do_shrink()
{
  update_doi_downward(-1);	// XXX
  leader->update_doi(0);
  return 0;
}

#define MIN_LIMIT 0.97

int
rproc::do_expand()
{
  if (CZGetStatus() == CZ_closed)
    CZSetState(CZ_be_opened);
  else
    CZSetState(CZ_be_closed);
  
  return 0;
}

int
rproc::do_auto()
{
  CZSetState(CZ_be_auto);
  return 0;
}

//
// XXX
//
double
rproc::XMin()
{
  if (tmp_min_mode)
    return image.Get_Part(RPROC_SMALL).Get(Am_WIDTH);
  else
    return 10;
}

double
rproc::YMin()
{
  if (tmp_min_mode)
    return image.Get_Part(RPROC_SMALL).Get(Am_HEIGHT);
  else
    return 10;
}

void
rproc::SetTmpMin()
{
  tmp_min_mode = 1;
}

void
rproc::SetNormalMin()
{
  tmp_min_mode = 0;
}

void
rproc::update_system_doi()
{
  if (state == rproc_dead) {
    system_doi = 0;
    leader->propagate_system_doi(0);
  } else if (member.length() == 0) {
    system_doi = exp(creation_time - global_time);
    leader->propagate_system_doi(system_doi);
  } else {
    system_doi = 0;
    Pix pi;
    for (pi = member.first(); pi != 0; member.next(pi)) {
      rproc *p = member(pi);
      p->update_system_doi();
    }
  }
}

void
rproc::propagate_system_doi(double new_doi)
{
  if (this == NULL)
    return;

  if (system_doi < new_doi)
    system_doi = new_doi;
  leader->propagate_system_doi(system_doi);
}

static char *system_library = "KLIEG System Library";

// this routine is called from rproc::update()
void
rproc::CalcDOI()
{
  if (mode_quality) {
    doi = QUALITY_MINIMUM;		// XXX

    char *mname, *dname, *parent_mname;
    int mtime, dtime, parent_mtime;

    mname = proc->GetModifierName();
    mtime = proc->GetModifiedTime();
    if (mname == NULL)
      mname = system_library;

    if (subproc != NULL) {
      dname = subproc->GetDropperName();
      dtime = subproc->GetDroppedTime();
      if (dname == NULL)
	dname = system_library;
    }
    if (parent != NULL) {
      parent_mname = parent->GetProc()->GetModifierName();
      parent_mtime = parent->GetProc()->GetModifiedTime();
      if (parent_mname == NULL)
	parent_mname = system_library;
    }

    //
    // XXX
    //
    double min_time = 0;
    if (strcmp(dname, parent_mname) != 0) {
      if (dtime == 0) dtime = (int)min_time + 1; // XXX
      if (mtime == 0) mtime = (int)min_time + 1; // XXX
      double doi_from_drop = log10(ceil((dtime - min_time)/(60*30)));
      double doi_from_mtime = log10(ceil((mtime - min_time)/(60*30)));
      doi = (doi_from_drop > doi_from_mtime) ? doi_from_drop : doi_from_mtime;
    } else if (strcmp(mname, system_library) != 0)
      doi = log10(ceil((mtime - min_time)/(60*30)));

    if (parent != NULL && doi < parent->getdoi())
      doi = parent->getdoi();
    if (leader != NULL && doi < leader->getdoi())
      doi = leader->getdoi();
	
    if (debug_calcdoi) {
      printf("rproc(name=%s:%s,id=%d)::CalcDOI: dropped by %s at %d\n",
	     GetModule(), GetName(), GetID(),
	     dname, dtime);
      printf("\tparent is created by %s at %d\n", parent_mname, parent_mtime);
      printf("\tDOI = %g\n", doi);
    }

  } else {

    if (leader)
      doi = leader->getdoi();
    else if (parent)
      doi = parent->getdoi();	// inherit parent's doi
    else
      doi = 1;			// for main process(default doi)
  }
  CZSetDOI(doi);
  system_doi = 1;		// XXX exp(0) == 1
}

void
rproc::RecalcQuality()
{
  Pix pi;
  for (pi = member.first(); pi != 0; member.next(pi)) {
    rproc *p = member(pi);
    p->CalcDOI();
    p->RecalcQuality();
  }
  CZSetState(CZ_be_auto);
}

double
rproc::getdoi()
{
  if (mode_creation_time)
    return system_doi;		// XXX
  return doi;
}

void
rproc::update_doi(double diff)
{
  if (this == NULL)
    return;

  if (mode_creation_time)
    return;			// XXX
  
  // XXX
  doi = 0;
  Pix pi;
  for (pi = member.first(); pi != 0; member.next(pi)) {
    rproc *p = member(pi);
    if (p->getdoi() > doi)
      doi = p->getdoi();
  }
  CZSetDOI(doi);
  CZResection();		// XXX
  //CZInitSection();		// XXX

  if (leader)
    leader->update_doi(0);
}

void
rproc::update_doi_downward(double diff)
{
  doi = doi + diff;
  if (isalive() && doi < QUALITY_MINIMUM)
    //doi = 1;
    doi = QUALITY_MINIMUM;
  if (doi < 0)
    doi = 0;
  CZSetDOI(doi);

  // XXX
  Pix pi;
  for (pi = member.first(); pi != 0; member.next(pi)) {
    rproc *p = member(pi);
    p->update_doi_downward(diff);
  }
  //CZMakeSection();		// XXX
  CZResection();		// XXX
}

void
rproc::set_doi(double value)
{
  if (debug_layout)
    printf("rproc::set_doi of %s(%d) to %f\n", name, procid, value);

  doi = value;
  CZSetDOI(value);
  //CZMakeSection();		// XXX
  CZResection();		// XXX
}

void
rproc::set_doi_downward(double value)
{
  if (debug_layout)
    printf("rproc::set_doi_downward of %s(%d) to %f\n", name, procid, value);

  doi = value;
  CZSetDOI(value);
  Pix pi;
  for (pi = member.first(); pi != 0; member.next(pi)) {
    rproc *p = member(pi);
    p->set_doi_downward(value);
  }
  //CZMakeSection();		// XXX
  CZResection();		// XXX
}

//
// default method for expansion
// must be called BEFORE set_children_coordinate()
//
void
rproc::set_children_coordinate()
{
  int c = 0;
  if (children.length() != 0) {
    Pix i = children.first();

    Rule *creator = children(i)->GetRule(); // XXX
    while (i != 0) {
      rproc *child = children(i);
//      SubProc *sp = creator->GetBody(c);
      SubProc *sp = child->GetSubProc();
      // fixed algoritm...
      double new_L = GetLeft()+sp->GetLeft()*GetWidth() /creator->GetWidth();
      double new_T = GetTop() +sp->GetTop() *GetHeight()/creator->GetHeight();
      double new_W = sp->GetWidth()  * GetWidth() / creator->GetWidth();
      double new_H = sp->GetHeight() * GetHeight() / creator->GetHeight();
      child->SetPoint(new_L, new_T);
      child->SetSize(new_W, new_H);
//      printf("Process %d (%d, %d) %dx%d(%fx%f)\n",
//	     child->GetID(), new_L, new_T, new_W, new_H, scale_w, scale_h);
      children.next(i);
      c++;
    }
  }  
}

// these should be moved to some header file
extern Am_Slot_Key CO_X;
extern Am_Slot_Key CO_Y;
#define DEFAULT_CO_X ((double)0.20)
#define DEFAULT_CO_Y ((double)0.10)

int
rproc::expanding()
{
//   Am_Object pnode = proc->Pnode();
  double x;
//   if (pnode.Valid())
//     x = pnode.Get(CO_X);
//   else
    x = DEFAULT_CO_X;

  return x > 0.05;		// XXX
}

void
rproc::dump_member(int level)
{
  int i;
  for (i = 0; i < level; i++)
    printf(" ");
  printf("pid=%d(%s:%s(%d,%s),%x): %f(%f,%f)(%f,%f)(%f,%f)\n",
	 procid,
	 module,
	 name,
	 state,			// XXX
	 CZGetStatus() == CZ_opened ? "expand" : "unexpand",
	 this,
	 doi,
	 GetLeft(), GetTop(),
	 GetWidth(), GetHeight(),
	 XMin(), YMin());
  
  Pix pi;
  for (pi = member.first(); pi != 0; member.next(pi)) {
    rproc *p = member(pi);
    p->dump_member(level + 1);
  }
}

void
rproc::dump_children(int level)
{
  int i;
  for (i = 0; i < level; i++)
    printf(" ");
  printf("pid=%d(%s:%s(%d,%s),%x): %f(%f,%f)(%f,%f)(%f,%f)\n",
	 procid,
	 module,
	 name,
	 state,			// XXX
	 CZGetStatus() == CZ_opened ? "expand" : "unexpand",
	 this,
	 doi,
	 GetLeft(), GetTop(),
	 GetWidth(), GetHeight(),
	 XMin(), YMin());
  
  Pix pi;
  for (pi = children.first(); pi != 0; children.next(pi)) {
    rproc *p = children(pi);
    p->dump_children(level + 1);
  }
}

/* eof */
