// -*-Mode: C++ -*-
// Copyright (C) 1996-1999 Buntarou Shizuki(shizuki@is.titech.ac.jp)

#ifndef _parse_h
#define _parse_h

#include "CZoom.h"

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>
#include <time.h>
#include <errno.h>
#include <fcntl.h>
#include <unistd.h>
#include <limits.h>

#include <sys/types.h>
#include <sys/stat.h>
#include <sys/wait.h>
#include <sys/termios.h>
#if defined(PTY_SOLARIS)
#include <sys/stropts.h>	// XXX
#endif

#if defined(PTY_LINUX)
#include <pty.h>
#endif

#if defined(SOLARIS)
extern "C" void bzero(void *, int);
#endif

#include <algobase.h>

#include <amulet.h>
#include <amulet/debugger.h>
#include <amulet/object_advanced.h>

#include "ToyWidgets.h"

//
// defined in opal.cc
//
void get_fixed_sizes(Am_Object self, Am_Value_List& components,
		     Am_Constraint_Context& cc,
		     int& fixed_width, int& fixed_height);
void get_max_rank_and_size(Am_Object self, Am_Constraint_Context& cc,
			   int& max_rank, int& max_size);

#include "my_amulet.h"
#include "kl_widgets.h"

#include "debug.h"
#include "tracer-types.h"

#include "Term.h"
#include "Object.h"
#include "ProcRegister.h"

#define KLIC_PROGRAM		"/usr/local/bin/klic"
#define KLIEG_WORK_ENV		"KLIEG_WORK_DIR"
#define KLIEG_WORK_DEFAULT	".klieg-work"
#define KLIEG_WORK_MODE		S_IRWXU	// defined in sys/stat.h on solaris 2.4
#define KLIEG_WORK_FILE		"source.kl1"
#define KLIEG_TRACED		"klieg-traced"
#define KLIEG_ENVIRONMENT	{"PATH=/usr/local/bin:/usr/bin", NULL}

#define TRACE_OBJECT	0
#define TRACE_LOGFILE	1

#define WINDOW_STATE_INIT	0
#define WINDOW_STATE_RUNNING	1
#define WINDOW_STATE_STOPPED	2
#define WINDOW_STATE_DEAD	3

#define MENUBAR_FONT "-*-helvetica-bold-r-*-*-*-120-*-*-*-*-iso8859-*"

#define COLOR_RUNNING	Am_Motif_Light_Gray
#define COLOR_SUSPENDED	Am_Motif_Green
#define COLOR_DEAD	Am_Blue
#define COLOR_CHECK	Am_Red

#define BLINK_CHECK	3
#define SPEED_CHECK	500

#define Port_Null	0
#define Port_Left	1
#define Port_Right	2
#define Port_Stream	4
#define Port_Single	5
#define Port_Unknown	6

typedef rterm		*RTERMTYPE;
typedef term_cons	*RCONSTYPE;
typedef term_functor	*RFUNCTYPE;
typedef rsubgoal	*RSUBGTYPE;
typedef char		*NAMETYPE;
typedef Proc		*PROCTYPE;
typedef Rule		*RULETYPE;
typedef Port		*PORTTYPE;
typedef Goal		*GOALTYPE;
typedef SubProc		*SUBPROCTYPE;
typedef enum {
  con_any,
  con_guard,
  con_body
} CONTEXTTYPE;

//
// Port.cc
//
//
// Proc.cc
//
Proc *getProc(char *name, int arity);

//
// ProcRegister.cc
//
void initProcRegister();
void procRegister(Proc *p);
Proc *getProc(char *module, char *name, int arity);
void dumpProcs();

//
// kl.l
//
extern "C" {
  int yylex(void);
  int yyerror(char *);
}
int fghc_parse(char *path);
int tracer_parse(FILE *in);

//
// kl.rie
//
int yyparse(void);

//
// runtime.cc
//
extern Am_Slot_Key RPROC;
extern Am_Slot_Key RPROC_MOVER_PART;
extern Am_Slot_Key RPROC_NORMAL;
extern Am_Slot_Key RPROC_SMALL;
extern Am_Slot_Key RPROC_LITTLE;
extern Am_Slot_Key RPROC_SELECT;
extern Am_Slot_Key RPROC_BACK;
extern Am_Slot_Key PROC_PART;
extern Am_Slot_Key BL_SRC_NAME;
extern Am_Slot_Key BL_DEST_NAME;
extern Am_Slot_Key CLICK_GROW;
extern Am_Slot_Key CLICK_TOGGLE;
extern Am_Slot_Key CLICK_SHRINK;
extern Am_Slot_Key RPROC_POPUP;
extern Am_Slot_Key MONITOR_GROUP;
extern Am_Slot_Key MONITOR_DISMISS;
extern Am_Slot_Key MONITOR_CHECK;
extern Am_Slot_Key MONITOR_CONTENT;
extern Am_Slot_Key MONITOR_SCROLL;
extern Am_Slot_Key MONITOR_TEXT;

//#define INTERPOLATION_STEP 10	// for animation
#define INTERPOLATION_STEP 5	// for animation

extern int global_time;
extern int mode_update_monitor;
extern int mode_show_continuous_change;
extern int mode_quality;
extern int mode_creation_time;
extern int mode_draw_links;
extern int mode_draw_links_always;
extern int mode_draw_fixed_links;
extern int mode_animation;
extern int interpolation_step;

extern rterm *NIL;		// available after env_init()

class rproc;
extern rproc *proc_main;

int env_init();
int draw_init();
int main_draw();
term_variable *env_getvar(char *name);
update(int goalid, ActType acttype, rterm *head, rsubgoal *subgoal);
void My_Goal_Modify(Am_Object process);

//
// subprocess.cc
//
extern int tracing_mode;

int subprocess_init();
int subprocess_compile(char *path);
int subprocess_start();
int subprocess_send(char *str);
int subprocess_send_init();
int subprocess_openlog(char *logfile);
int subprocess_tracing();
int subprocess_clean();

//
// unify.cc
//
int unify_term(rterm *t1, rterm *t2);

//
// window.cc
//
//extern int window_current_state;

void window_set_state(int new_state);
int window_get_state();
int window_create();
int window_init();
int window_main();
int window_draw(Am_Slot_Key slot, Am_Object &obj);
int window_update();
int window_clean();
int window_dialog();
int window_tracing();
int window_canvas_width();
int window_canvas_height();
void window_highlight_object(Am_Object image,
			     Am_Style line_style, Am_Style fill_style,
			     int number, int msec1, int msec2);
void my_usleep(int useconds);

Am_Object Pnode_add(char *name);

extern Am_Object ToggleCommand;
extern Am_Slot_Key ToggleVar;

#endif

/* eof */
