// -*- C++ -*-
// Copyright (C) 1996-1999 Buntarou Shizuki(shizuki@is.titech.ac.jp)

#ifndef _Object_h
#define _Object_h

#include <stdio.h>
#include <string.h>
#include <SLList.h>

#include <amulet.h>
#include <amulet/debugger.h>

#include "kl_widgets.h"
#include "tracer-types.h"

struct Port {
public:
  int		where;
  char		*name;
  int		id;
  int		refer;
  PortType	type;
  int		lr;
  int		left, top, width, height;
  double	rx, ry;
  int		rxy_defined;
  Port		*next;		// for list

		Port() { where = -2; // XXX
			 refer = -1;
			 rxy_defined = 0; }
};

//
// link is defined in head or in body
//
struct Link {
  int id1;
  int id2;
};

class Guard;
class SubProc;
class Proc;
class Rule : public PointSize {
  Proc			*proc;
  int			rule_number;
  RuleType		type;
  int			subproc_num;
  SLList<Guard *>	GuardList;
  SLList<SubProc *>	BodyList;
  SLList<Link *>	LinkList;
  SLList<Port *>	PortList;

  Am_Object		image;

public:
  Rule(Proc *parent, int num, RuleType t) { proc = parent;
					    rule_number = num;
					    type = t;
					    left = top = width = height = 0;
					    subproc_num = 0;
					    image = NULL; }
  ~Rule() {}

  void			SetRuleNum(int n) { rule_number = n; }
  int			RuleNum() { return rule_number; }

  RuleType		Type() { return type; }

  void			AddGuard(Guard *r) { GuardList.append(r); }
  void			AddBody(SubProc *r);
  SubProc		*NewSubProc();
  SubProc		*GetBody(int n);
  int			CountGuard() { return GuardList.length(); }
  int			CountBody() { return BodyList.length(); }
  SLList<SubProc *>	GetBody() { return BodyList; }
  void			AddPort(int where/*, int order*/, Port *ports);
  Port			*GetPort(int id);
  Port			*GetPort(int where, char *name);
  void			UnifyPorts(int port_id, Port *ports);
  void			AddLink(int id1, int id2);
  SLList<Link *>	GetLinks() { return LinkList; }

  Am_Object		Image();

  // for debugging
  void			Dump();
};

class Goal : public PointSize {
 public:
  Rule			*rule;

  Rule			*GetRule() { return rule; }
  
  virtual Am_Object	Image() = 0;

  //
  // for debugging
  //
  virtual void		Dump() = 0;
};

class Guard : public Goal {
 public:
			Guard(Rule *r) { rule = r;
					 left = top = width = height = 0; }
			~Guard() {}

  Am_Object		Image() { return NULL; }

  //
  // for debugging
  //
  void			Dump() {}
};

class Layout {
protected:
  double width, height;

public:
  Layout() {}
  Layout(double w, double h) {
    width = w;
    height = h;
  }

  double GetWidth() { return width; }
  double GetHeight() { return height; }
};

class LayoutDef : public Layout {
protected:
  char *name;

public:
  LayoutDef(char *s, double W, double H) {
    name = get_symbol(s);
    width = W;
    height = H;
  }

  char *GetName() { return name; }
};

class SubProc : public Goal {
  char			*module;
  char			*name;
  int			arity;
  int			id;
  SLList<Layout *>	LayoutList;

  char			*dropper_name;
  int			dropped_time;

public:
			SubProc(Rule *r, int num) { rule = r;
						    id = num;
						    left = top = width = height = 0;
						    dropper_name = NULL;
						    dropped_time = 0; }
			~SubProc() {}

  Am_Object		Image();

  void			SetModule(char *m) { module = get_symbol(m); }
  void			SetName(char *n) { name = get_symbol(n); }
  char			*GetName() { return name; }
  void			SetArity(int n) { arity = n; }
  int			GetArity() { return arity; }
  int			GetID() { return id; }
  double		GetPortRx(char *p_name);
  double		GetPortRy(char *p_name);

  void			AddLayout(double w, double h);
  SLList<Layout *>	GetLayout() { return LayoutList; }

  void			SetDropper(char *n, int t) { dropper_name = n;
						     dropped_time = t; }
  char			*GetDropperName() { return dropper_name; }
  int			GetDroppedTime() { return dropped_time; }
  
  //
  // for debugging
  //
  void			Dump();
};

#define PROC_TYPE_NULL		0
#define PROC_TYPE_CREATOR	1
#define PROC_TYPE_NORMAL	2
#define PROC_TYPE_PATTERN_TOP	3
#define PROC_TYPE_PATTERN	4

class Rule;
class Proc : public PointSize {
  struct Comment {
    int		left, top;
    char	*str;
  };

  char			*proc_module;
  char			*proc_name;
  int			proc_arity;
  int			proc_type;
  ExpandMethod		method;
  ArrangeOption		arrange_option;
  SLList<Port *>	PortList;
  SLList<Rule *>	RuleList;
  SLList<Comment *>	CommentList;
  SLList<LayoutDef *>	LayoutDefList;

  char			*creator_name;
  int			created_time;
  char			*modifier_name;
  int			modified_time;

  Am_Object		image;
  //Am_Object		pnode;

 public:
  Proc();
  ~Proc() {};
  Proc(char *module, char *name, int type, ExpandMethod m, ArrangeOption opt);
  
  char			*Module() { return proc_module; }
  char			*Name() { return proc_name; }
  int			Arity() { return proc_arity; }
  int			Type() { return proc_type; }

  void			SetName(char *name) { proc_name = name; }
  void			SetArity(int arity) { proc_arity = arity; }
  ExpandMethod		GetExpand() { return method; }
  void			SetExpand(ExpandMethod m) { method = m; }
  ArrangeOption		GetArrangeOption() { return arrange_option; }
  void			AddPort(char *name, PortType type, int lr,
				int left, int top, int width, int height);
  SLList<Port *>	GetPorts() { return PortList; }  
  Rule			*NewRule(int num, RuleType type);
  Rule			*GetRule(int num);
  void			AddComment(int left, int top, char *str);

  void			AddLayoutDef(char *s, double w, double h);
  SLList<LayoutDef *>	GetLayoutDef() { return LayoutDefList; }

  void			SetCreator(char *n, int t) { creator_name = n;
						     created_time = t; }
  char			*GetCreatorName() { return creator_name; }
  int			GetCreatedTime() { return created_time; }
  void			SetModifier(char *n, int t) { modifier_name = n;
                                                      modified_time = t; } 
  char			*GetModifierName() { return modifier_name; }
  int			GetModifiedTime() { return modified_time; }
  
  Am_Object		Image();
  //  Am_Object		Pnode() { return pnode; }
  Am_Object		RuleImage(int rule_number);
  
  // for debugging
  void			Dump();
  
friend Proc* newProc(char *module, char *name, int arity);
};

#endif

/* eof */
