// Copyright (C) 1996-1999 Buntarou Shizuki(shizuki@is.titech.ac.jp)

#include "tracer-types.h"
#include "debug.h"

#include "Object.h"
#include "ProcRegister.h"

void My_Goal_Modify(Am_Object process);

Am_Object
SubProc::Image() {
  Proc *p = getProc(module, name, 0); // XXX
  if (p == NULL) {
    //
    // process is not defined
    //
    return NULL;
  }
  Am_Object obj = Goal_Create(p->Image());
  My_Goal_Modify(obj);
  return obj;
}

#define CONTENTS_MARGIN 16	// XXX

double
SubProc::GetPortRx(char *p_name)
{
  Port *p = rule->GetPort(id, p_name);
  if (! p->rxy_defined) {
    // for upper edge
    int nearest = p->top+CONTENTS_MARGIN;
    p->rx = p->left + p->width/2;
    p->ry = 0;

    if (nearest > width - (p->left+p->width)) {
      nearest = width - (p->left+p->width);
      p->rx = width;
      p->ry = p->top+CONTENTS_MARGIN + p->height/2;
    }
    if (nearest > height - (p->top+CONTENTS_MARGIN+p->height)) {
      nearest = height - (p->top+CONTENTS_MARGIN+p->height);
      p->rx = p->left + p->width/2;
      p->ry = height;
    }
    if (nearest > p->left) {
      nearest = p->left;
      p->rx = 0;
      p->ry = p->top+CONTENTS_MARGIN + p->height/2;
    }

    // normalization
    p->rx = p->rx / width;
    p->ry = p->ry / height;
    //
    p->rxy_defined = 1;
  }
  return p->rx;
}

double
SubProc::GetPortRy(char *p_name)
{
  Port *p = rule->GetPort(id, p_name);
  if (! p->rxy_defined)
    GetPortRx(p_name);		// XXX
  return p->ry;
}

void
SubProc::AddLayout(double w, double h)
{
  Layout *layout = new Layout(w, h);
  LayoutList.append(layout);
}

void
SubProc::Dump() {
  printf("\t\t%d: %s:%s/%d(%d, %d, %d, %d)\n",
	 id, module, name, arity, left, top, width, height);
}

//
//
//
Am_Object Pnode_add(char *name);

Proc*
newProc(char *module, char *name, int arity) {
  Proc *p = new Proc();
  p->proc_module = module;
  p->proc_name = name;
  p->proc_arity = arity;
  p->image = NULL;

  return p;
};

//
//
//
Proc::Proc()
{
  image = NULL;
  //  pnode = NULL;
  method = expand_default;
}

Proc::Proc(char *module, char *name, int type,
	   ExpandMethod m, ArrangeOption opt) {
  proc_module = module;
  proc_name = name;
  proc_arity = 0;
  proc_type = type;
  method = m;
  arrange_option = opt;

  /* set default, as a system library */
  creator_name = NULL;
  created_time = 0;
  modifier_name = NULL;
  modified_time = 0;
  
  image = NULL;

  // temporarily
  //pnode = Pnode_add(name);
};

void
Proc::AddPort(char *name, PortType type, int lr,
	      int left, int top, int width, int height)
{
  Port *p = new Port();
  p->name = get_symbol(name);
  p->id   = -1;			// Hmmmm...
  p->type = type;
  p->lr   = lr;
  p->left = left; p->top = top; p->width = width; p->height = height;
  PortList.append(p);
}

Rule *
Proc::NewRule(int num, RuleType type)
{
  Rule *r = new Rule(this, num, type);
  RuleList.append(r);
  return r;
}

Rule *
Proc::GetRule(int num)
{
  Pix i;
  Rule *r;

  for (i = RuleList.first(); i != 0; RuleList.next(i)) {
    r = RuleList(i);
    if (r->RuleNum() == num)
      return r;
  }
  return NULL;
}

void
Proc::AddComment(int left, int top, char *str)
{
    Comment *c = new Comment();
    c->left = left;
    c->top = top;
    c->str = get_symbol(str);
    CommentList.append(c);
}

void
Proc::AddLayoutDef(char *s, double w, double h)
{
  if (debug_layout)
    printf("layout: defining layout '%s' with (%d,%d)\n", s, (int)w, (int)h);
  LayoutDef *layout = new LayoutDef(s, w, h);
  LayoutDefList.append(layout);
}

Am_Object
Proc::Image()
{
  //char title[1024];		// XXX
  char *title;
  
  //
  // already created?
  //
  if (image == NULL) {
    //
    // create one!!
    //
    //sprintf(title, "%s:%s", proc_module, proc_name);
    title = proc_name;

    if (proc_type == PROC_TYPE_NORMAL)
      image = Process_Proto.Create(title);
    else
      //
      // creator, pattern, pattern_top
      //
      image = Creator_Proto.Create(title);
    Proc_Rename(image, title);

    //
    // port part
    //
    for (Pix i = PortList.first(); i != 0; PortList.next(i)) {
      struct Port *port = PortList(i);
      Am_Object am_port;

      switch(port->type) {
      case port_single_in:
	am_port = In_Single_Proto.Create(port->name);
	break;
      case port_single_out:
	am_port = Out_Single_Proto.Create(port->name);
	break;
      case port_stream_in:
	am_port = In_Stream_Proto.Create(port->name);
	break;
      case port_stream_out:
	am_port = Out_Stream_Proto.Create(port->name);
	break;
      default:
	printf("unknown port type: %d\n", port->type);
	break;
      }
      Port_Rename(am_port, port->name);
      Proc_Add_Port(image, am_port, port->left, port->top, NULL);
    }
  }

//  Am_Initialize_Inspector(image);

  Am_Object obj = Goal_Create(image);
  My_Goal_Modify(obj);
  return obj;
}

Am_Object
Proc::RuleImage(int rule_number)
{
//  Am_Object am_proc = Process_Proto.Create(proc_name);
//  Proc_Rename(am_proc, proc_name);

  //
  // get rule_number Rule of this process
  // this must be re-written!!!
  //
  Pix i;
  Rule *r = NULL;
  int n = 0;
  for (i = RuleList.first(); i != 0; n++, RuleList.next(i)) {
    if (n == rule_number) {
      r = RuleList(i);
      break;
    }
  }
  if (r == NULL) {
    // message!!

    return NULL;
  }
  return r->Image();
}

void
Proc::Dump()
{
  Pix i;

  printf("%s:%s/%d: ", proc_module, proc_name, proc_arity);
  // each port
  for (i = PortList.first(); i != 0; PortList.next(i)) {
    printf("%s(%d) ", PortList(i)->name, PortList(i)->type);
  }
  printf("\n");
  
  // each rule
  for (i = RuleList.first(); i != 0; RuleList.next(i)) {
    RuleList(i)->Dump();
  }
}

SubProc *
Rule::NewSubProc()
{
  SubProc *sp = new SubProc(this, subproc_num);
  if (debug_rule)
    printf("Creating subproc(%d)\n", subproc_num);
  subproc_num++;
  return sp;
}

void
Rule::AddBody(SubProc *r)
{
  BodyList.append(r);
}

SubProc *
Rule::GetBody(int n)
{
  int c;
  Pix i = BodyList.first();

  for (c = 0; c != n; c++)
    BodyList.next(i);

  return BodyList(i);
}

void
Rule::AddPort(int where/*, int order*/, Port *port)
{
  port->where = where;		// subprocess ID
  port->refer = -1;		// port->id;
  PortList.append(port);
  if (debug_rule || debug_port_coordinate)
    printf("AddPort to %s:%s(%d): (%s, %d, %s) at (%d,%d)\n",
	   proc->Module(),
	   proc->Name(),
	   where,
	   port->name,
	   port->id,
	   PortType_to_char(port->type),
	   port->left,
	   port->top);
}

void
Rule::UnifyPorts(int port_id, Port *ports)
{
  Port *p;

  for (p = ports; p != NULL; p = p->next) {
    p->refer = port_id;
    PortList.append(p);
  if (debug_rule || debug_port_coordinate)
    printf("AddPort to %s:%s as %d: (%s, %d, %s) at (%d,%d)\n",
	   proc->Module(),
	   proc->Name(),
	   p->refer,
	   p->name,
	   p->id,
	   PortType_to_char(p->type),
	   p->left,
	   p->top);
  }
}

Port *
Rule::GetPort(int id)
{
  Pix i;
  for (i = PortList.first(); i != 0; PortList.next(i)) {
    Port *p = PortList(i);
    if (p->id == id) {
      if (p->refer == -1)
	return p;
      else
	return this->GetPort(p->refer);
    }
  }
  return NULL;
}

Port *
Rule::GetPort(int where, char *name)
{
  if (debug_rule)
    printf("Rule::GetPort(): where=%d, name=%s\n", where, name);
  
  Pix i;
  for (i = PortList.first(); i != 0; PortList.next(i)) {
    Port *p = PortList(i);
    if (p->where == where && strcmp(p->name, name) == 0) {
      // p->refer XXX
      return p;
    }
  }
  return NULL;
}

void
Rule::AddLink(int id1, int id2)
{
  struct Link *l = new Link();
  l->id1 = id1;
  l->id2 = id2;
  LinkList.append(l);
}

Am_Object
Rule::Image()
{
  Pix i;

  if (image != NULL)
    return image;		// must be changed

  Am_Object proc_image = proc->Image();
  image = Rule_Create(proc_image, Vanishing_Rule_Proto)
    .Set(Am_LEFT, left)
    .Set(Am_TOP, top)
    .Set(Am_WIDTH, width)	// ??
    .Set(Am_HEIGHT, height);	// ??

  for (i = GuardList.first(); i != 0; GuardList.next(i)) {
    GuardList(i)->Image();
  }

  Am_Object goal_image;
  for (i = BodyList.first(); i != 0; BodyList.next(i)) {
    SubProc *sub = (SubProc *) BodyList(i);
    goal_image = sub->Image();
    Rule_Add_Goal(image,
		  goal_image,
		  sub->GetLeft(),
		  sub->GetTop(),
		  NULL);	// any size part?
  }

  return image;
}

void
Rule::Dump()
{
  Pix i;

  printf("\trule %d %s(%d, %d, %d, %d):\n",
	 rule_number, RuleType_to_str(type), left, top, width, height);
  for (i = GuardList.first(); i != 0; GuardList.next(i)) {
    GuardList(i)->Dump();
  }
  for (i = BodyList.first(); i != 0; BodyList.next(i)) {
    BodyList(i)->Dump();
  }
}

/* eof */
