// Copyright (C) 1997  Toyoda Masashi (toyoda@is.titech.ac.jp)

// Constants
// ----------------------------------------------------------------------

// sequence
enum SequenceDir { LeftRight = 0,
		   TopBottom = 1,
		   RightLeft = 2,
		   BottomTop = 3 };
// font
#define NofFontFamilies	3
#define FontFixed	0
#define FontSerif	1
#define FontSansSerif	2


#ifndef _INTERNAL_

#include <fstream.h>

// ----------------------------------------------------------------------
// Initialize routine
// ----------------------------------------------------------------------
void Initialize_Zooming_Widgets(void);

// ----------------------------------------------------------------------
// AlignZoomGroup
// ----------------------------------------------------------------------
extern Am_Object AlignZoomGroup;
extern Am_Object SequenceAlignZoomGroup;

// public slots
// ------------------------------
EXPORT_SLOT(propagateParent);	// $B;R%N!<%I$+$i?F%N!<%I$X$N%j%s%/(B
EXPORT_SLOT(propagateChildren);	// $B?F%N!<%I$+$i;R%N!<%I$N%0%k!<%W$X$N%j%s%/(B
EXPORT_SLOT(hyperLinks);	// $B3F;R%N!<%I$+$iD%$i$l$F$$$k%j%s%/$N%j%9%H(B

EXPORT_SLOT(alignThreshold);
EXPORT_SLOT(minimumSpace);
EXPORT_SLOT(maximumPercentage);
EXPORT_SLOT(detailThreshold);
EXPORT_SLOT(partMoved);
EXPORT_SLOT(seqDir);

// Drag & Dropping Methods
EXPORT_SLOT(DropPoints);
EXPORT_SLOT(DropMethod);
EXPORT_SLOT(CheckDropMethod);

// formulas
// ------------------------------
extern Am_Formula PropagateForm;

// Utility Methods
// ------------------------------
Am_Object Align_Zoom_Create_Part(Am_Object part);
Am_Object Align_Zoom_Copy_Part(Am_Object part);
int Get_Required_Width(Am_Object group);
int Get_Required_Height(Am_Object group);
int origX(Am_Object obj);
int origY(Am_Object obj);
int origW(Am_Object obj);
int origH(Am_Object obj);
void OutputCoords(Am_Object obj, ofstream& ofile);

// ----------------------------------------------------------------------
// Selection Widget and Commands
// ----------------------------------------------------------------------
extern Am_Object AlignZoomSelectionWidget;
extern Am_Object OrigSizeCmd;
extern Am_Object EditSizeCmd;
extern Am_Object ToggleSizeCmd;
extern Am_Object SetOrigCmd;
extern Am_Object SetEditCmd;


// public slots
// ------------------------------
EXPORT_SLOT(selectableObjects);

// Utility Methods
// ------------------------------
Am_Inter_Location Align_Zoom_Get_Location(Am_Object obj);
void Align_Zoom_Animate_Obj(Am_Object target, Am_Inter_Location loc);
void Retrieve_Hyper_Link(Am_Object src, Am_Object des, Am_Object selection);
void SetOrigXYWH(Am_Object obj, int x, int y, int w, int h);
void SetPointers(Am_Object obj, int cw, int ch, int sw, int sh, int lw, int lh);

void change_to_small_size(Am_Object obj);
void change_to_large_size(Am_Object obj);
void change_to_small_sizes(Am_Value_List objs);
void change_to_large_sizes(Am_Value_List objs);
void change_small_then_large(Am_Value_List smalls, Am_Value_List larges);

// group$B$r%k!<%H$H$7$F!"(B(x,y,ref)$B$N0LCV$K$"$k%*%V%8%'%/%H$N$&$A(B
// protos$B$K4^$^$l$k%$%s%9%?%s%9$N$b$N$rC5$9!#(B
Am_Object Content_Instance_Of(Am_Object group, int x, int y, Am_Object ref, Am_Value_List protos);

// ----------------------------------------------------------------------
// ZoomingText
// ----------------------------------------------------------------------
extern Am_Object ZoomingText;
extern Am_Object ZoomingMultiLineText;
extern Am_Object ZoomingTextBrowser;

extern Am_Object Create_Text_Browser(Am_String filename, Am_Object browser);

// public slots
// ------------------------------
EXPORT_SLOT(TextPart);
EXPORT_SLOT(FontFamily);
EXPORT_SLOT(FontIsBold);
EXPORT_SLOT(FontIsItalic);
EXPORT_SLOT(FontIsUnderline);

#endif


