// Copyright (C) 1997  Toyoda Masashi (toyoda@is.titech.ac.jp)

#include <amulet.h>
#include OBJECT_ADVANCED__H
#include WIDGETS_ADVANCED__H
#include OPAL_ADVANCED__H
#include INTER_ADVANCED__H

#define _INTERNAL_
#include "ToyWidgets.h"

DEFINE_SLOT(Am_RAISED);
DEFINE_SLOT(Am_THICKNESS);

Am_Object Am_Border_Roundtangle;

#define Am_Color_Style(color) Am_Style(color, 0, Am_CAP_BUTT, \
				       Am_JOIN_MITER, Am_LINE_SOLID, \
				       Am_DEFAULT_DASH_LIST, \
				       Am_DEFAULT_DASH_LIST_LENGTH, \
				       Am_FILL_SOLID, \
				       Am_FILL_POLY_EVEN_ODD, \
				       Am_No_Image)

// Sharper Border Rectangle
void My_Am_Draw_Motif_Box (int left, int top, int width, int height,
			   int thickness, bool depressed,
			   const Computed_Colors_Record& rec,
			   Am_Drawonable* draw)
{
  Am_Style top_fill;
  Am_Style bot_fill;
  Am_Style inside_fill;
  if (depressed) {
    top_fill = rec.data->shadow_style;
    bot_fill = rec.data->highlight_style;
    inside_fill = rec.data->background_style;
  }
  else {
    top_fill = rec.data->highlight_style;
    bot_fill = rec.data->shadow_style;
    inside_fill = rec.data->foreground_style;
  }
  //top edges
  draw->Draw_Rectangle(Am_No_Style, top_fill, left, top, width, height);
  //top-right corner
  draw->Draw_2_Lines(Am_No_Style, bot_fill,
		     left + width - thickness, top + thickness,
		     left + width            , top,
		     left + width            , top + thickness);
  //bottom-left corner
  draw->Draw_2_Lines(Am_No_Style, bot_fill,
		     left + thickness, top + height - thickness,
		     left            , top + height,
		     left + thickness, top + height);
  //bottom edges
  draw->Draw_Rectangle(Am_No_Style, bot_fill,
		       left + thickness, top + thickness,
		       width - thickness, height - thickness);
  //inside of box
  draw->Draw_Rectangle(Am_No_Style, inside_fill,
		       left + thickness, top + thickness,
		       width - thickness * 2, height - thickness * 2);
}

Am_Define_Method(Am_Draw_Method, void, my_border_rectangle_draw,
		 (Am_Object self, Am_Drawonable* drawonable,
		  int x_offset, int y_offset))
{
  int left = (int)self.Get (Am_LEFT) + x_offset;
  int top = (int)self.Get (Am_TOP) + y_offset;
  int width = self.Get (Am_WIDTH);
  int height = self.Get (Am_HEIGHT);
  int thickness = self.Get (Am_THICKNESS);
  bool selected = !self.Get (Am_RAISED);
  Computed_Colors_Record rec = self.Get(Am_STYLE_RECORD);
  Am_Widget_Look look = (Am_Widget_Look)(int)self.Get (Am_WIDGET_LOOK);
  if (look == Am_MOTIF_LOOK)
    My_Am_Draw_Motif_Box(left, top, width, height, thickness, selected,
			 rec, drawonable);
  else
    Am_Error("Sorry, only the Motif Style implemented for now");
}

// Border Round Rectangle
void Am_Draw_Motif_RBox (int left, int top, int width, int height, int radius,
			 int thickness, bool depressed,
			 const Computed_Colors_Record& rec,
			 Am_Drawonable* draw)
{
  Am_Style top_fill;
  Am_Style bot_fill;
  Am_Style inside_fill;
  if (depressed) {
    top_fill = rec.data->shadow_style;
    bot_fill = rec.data->highlight_style;
    inside_fill = rec.data->background_style;
  }
  else {
    top_fill = rec.data->highlight_style;
    bot_fill = rec.data->shadow_style;
    inside_fill = rec.data->foreground_style;
  }
  int arc_size = radius * 2;
  Am_Style gray_fill = Am_Color_Style("gray");

  //bottom edges
  draw->Draw_Roundtangle(Am_No_Style, bot_fill, left, top, width, height,
			 radius, radius);
  //top-right corner
  draw->Draw_Arc(gray_fill, gray_fill, left + width - arc_size - 1, top,
		 arc_size + 1, arc_size - 2, 0, 90);
  //top-left corner
  draw->Draw_Arc(top_fill, top_fill, left, top,
		 arc_size, arc_size, 90, 90);
  //bottom-left corner
  draw->Draw_Arc(gray_fill, gray_fill, left, top + height - arc_size - 1,
		 arc_size - 3, arc_size + 1, 180, 90);
  //top edges
  draw->Draw_Rectangle(Am_No_Style, top_fill,
		       left, top + radius,
		       width - thickness, height - radius * 2);
  draw->Draw_Rectangle(Am_No_Style, top_fill,
		       left + radius, top,
		       width - radius * 2, height - thickness);
  //inside of box
  draw->Draw_Roundtangle(Am_No_Style, inside_fill,
			 left + thickness, top + thickness,
			 width - thickness * 2, height - thickness * 2,
			 radius, radius);
}

Am_Define_Method(Am_Draw_Method, void, border_roundtangle_draw,
		 (Am_Object self, Am_Drawonable* drawonable,
		  int x_offset, int y_offset))
{
  int left = (int)self.Get (Am_LEFT) + x_offset;
  int top = (int)self.Get (Am_TOP) + y_offset;
  int width = self.Get (Am_WIDTH);
  int height = self.Get (Am_HEIGHT);
  int thickness = self.Get (Am_THICKNESS);
  int radius = self.Get(Am_DRAW_RADIUS);
  bool selected = !self.Get (Am_RAISED);
  Computed_Colors_Record rec = self.Get(Am_STYLE_RECORD);
  Am_Widget_Look look = (Am_Widget_Look)(int)self.Get (Am_WIDGET_LOOK);
  if (look == Am_MOTIF_LOOK)
    Am_Draw_Motif_RBox(left, top, width, height, radius, thickness, selected,
		       rec, drawonable);
  else
    Am_Error("Sorry, only the Motif Style implemented for now");
}


void Initialize_Rectangle_Widgets()
{
  Am_Object_Advanced obj_adv;

  Am_Border_Rectangle = Am_Border_Rectangle.Create("Border_Rectangle")
    .Set(Am_RAISED, true)
    .Set(Am_X_OFFSET, 0)
    .Set(Am_Y_OFFSET, 0)
    .Set(Am_THICKNESS, 2)
    .Set(Am_FILL_STYLE, Am_Amulet_Purple)
    .Set(Am_DRAW_METHOD, my_border_rectangle_draw)
    ;
  
  obj_adv = (Am_Object_Advanced&)Am_Border_Rectangle;
  obj_adv.Get_Slot (Am_THICKNESS)
    .Set_Demon_Bits (Am_STATIONARY_REDRAW | Am_EAGER_DEMON);
  obj_adv.Get_Slot (Am_RAISED)
    .Set_Demon_Bits (Am_STATIONARY_REDRAW | Am_EAGER_DEMON);


  Am_Border_Roundtangle = Am_Roundtangle.Create("Border_Roundtangle")
    .Set(Am_RAISED, true)
    .Set(Am_SELECTED, false)
    .Set(Am_WIDGET_LOOK, (int)Am_MOTIF_LOOK)
    .Set(Am_STYLE_RECORD, Am_Get_Computed_Colors_Record_Form)
    .Set(Am_WIDTH, 50)
    .Set(Am_HEIGHT, 50)
    .Set(Am_X_OFFSET, 0)
    .Set(Am_Y_OFFSET, 0)
    .Set(Am_THICKNESS, 2)
    .Set(Am_FILL_STYLE, Am_Amulet_Purple)
    .Set(Am_DRAW_METHOD, border_roundtangle_draw)
    ;
  
  obj_adv = (Am_Object_Advanced&)Am_Border_Roundtangle;
  obj_adv.Get_Slot (Am_THICKNESS)
    .Set_Demon_Bits (Am_STATIONARY_REDRAW | Am_EAGER_DEMON);
  obj_adv.Get_Slot (Am_RAISED)
    .Set_Demon_Bits (Am_STATIONARY_REDRAW | Am_EAGER_DEMON);
  obj_adv.Get_Slot (Am_SELECTED)
    .Set_Demon_Bits (Am_STATIONARY_REDRAW | Am_EAGER_DEMON);
  obj_adv.Get_Slot (Am_WIDGET_LOOK)
    .Set_Demon_Bits (Am_STATIONARY_REDRAW | Am_EAGER_DEMON);
  obj_adv.Get_Slot (Am_FILL_STYLE)
    .Set_Demon_Bits (Am_STATIONARY_REDRAW | Am_EAGER_DEMON);
}
