// Copyright (C) 1997  Toyoda Masashi (toyoda@is.titech.ac.jp)

// ------------------------------------------------------------
// Objects
// ------------------------------------------------------------

extern Am_Object PovlSelectionWidget;
extern Am_Object PovlOrigSizeCmd;
extern Am_Object PovlEditSizeCmd;
extern Am_Object EditableZoomingText;
extern Am_Object NewObjectCmd;
extern Am_Object RemoveObjectCmd;
extern Am_Object PovlGroup;
extern Am_Object SequencePovlGroup;
extern Am_Object ValueProto;
extern Am_Object PovlContents;

// ------------------------------------------------------------
// Slots
// ------------------------------------------------------------

// Models --------
EXPORT_SLOT(Name);
EXPORT_SLOT(ModuleList);
EXPORT_SLOT(ModuleNameList);
EXPORT_SLOT(Process);
EXPORT_SLOT(ProcessList);
EXPORT_SLOT(ProcessNameList);
EXPORT_SLOT(PatternList);
EXPORT_SLOT(PatternNameList);
EXPORT_SLOT(ProcPatternList);
EXPORT_SLOT(ProcPatternNameList);
EXPORT_SLOT(RuleList);
EXPORT_SLOT(Hole);
EXPORT_SLOT(HoleList);
EXPORT_SLOT(HoleNameList);
EXPORT_SLOT(PortList);
EXPORT_SLOT(PortNameList);
EXPORT_SLOT(InnerPortList);
EXPORT_SLOT(InnerPortNameList);
EXPORT_SLOT(GuardList);
EXPORT_SLOT(ValueList);
EXPORT_SLOT(NameList);
EXPORT_SLOT(MainRule);

// Processes --------
EXPORT_SLOT(Module);
EXPORT_SLOT(ModuleName);
EXPORT_SLOT(RuleVisible);

// Ports --------
EXPORT_SLOT(Mode);
EXPORT_SLOT(Type);
EXPORT_SLOT(Dir);
EXPORT_SLOT(Age);
EXPORT_SLOT(State);
EXPORT_SLOT(Special);
EXPORT_SLOT(Values);
EXPORT_SLOT(Binders);
EXPORT_SLOT(InputBinders);
EXPORT_SLOT(InnerBinders);
EXPORT_SLOT(OutputBinders);
EXPORT_SLOT(HoleBinders);

// Binders --------
EXPORT_SLOT(SrcPort);
EXPORT_SLOT(DestPort);

// Patterns --------
EXPORT_SLOT(LayoutNameList);
EXPORT_SLOT(LayoutSizeList);

// Views --------
EXPORT_SLOT(Parent);
EXPORT_SLOT(Model);
EXPORT_SLOT(ToCopyModel);
EXPORT_SLOT(FramePart);
EXPORT_SLOT(ContentsPart);
EXPORT_SLOT(NamePart);
EXPORT_SLOT(MarkerPart);
EXPORT_SLOT(IconPart);
EXPORT_SLOT(BindersPart);

EXPORT_SLOT(NameHeightMax);
EXPORT_SLOT(MenuPopper);

// Rename Method
EXPORT_SLOT(NamingMethod);

// Add Methods
EXPORT_SLOT(AddMethod);
EXPORT_SLOT(RemoveMethod);

// Copying Methods
EXPORT_SLOT(NewMethod);
EXPORT_SLOT(CopyMethod);
EXPORT_SLOT(CopyAllMethod);

// For Translator --------
EXPORT_SLOT(Id);
EXPORT_SLOT(NextId);
EXPORT_SLOT(InnerName);
EXPORT_SLOT(InnerNextName);
EXPORT_SLOT(GenOrder);
EXPORT_SLOT(Priority);

// User, Creator, Date, etc...
EXPORT_SLOT(User);
EXPORT_SLOT(Creator);
EXPORT_SLOT(CreatedTime);
EXPORT_SLOT(Modifier);
EXPORT_SLOT(ModifiedTime);
EXPORT_SLOT(Dropper);
EXPORT_SLOT(DroppedTime);
EXPORT_SLOT(ReplPatternView);

// Constants

#define TransitionRule 0
#define NetworkRule    1

#define NormalPattern 0
#define ReplPattern   1


#define PathProcess   1
#define PathHole      2
#define PathPort      3
#define PathValue     4
#define PathBinder    5

// ------------------------------------------------------------
// Utility Functions
// ------------------------------------------------------------

#define MGet(slot) Get_Object(Model).Get(slot)
#define MSet(slot, value) Get_Object(Model).Set(slot, value)
#define MGV(slot) GV_Object(Model).GV(slot)

void Set_User_Name(Am_Object obj,
		   Am_Slot_Key name_key, Am_String name,
		   Am_Slot_Key time_key, int time);

Am_Object Path_To_Obj(Am_Object root, Am_Value_List path);
Am_Value_List Obj_To_Path(Am_Object obj, Am_Object root);

Am_Object Content_Instance_Of_Povl(Am_Object group, int x, int y, Am_Object ref, Am_Value_List protos);

/* Renaming utilities */
void Propagate_Rename(Am_Object obj, Am_String name);
void Add_Name(Am_Object obj, Am_Slot_Key list_key, char* name);
void Remove_Name(Am_Object obj, Am_Slot_Key list_key, char* name);
bool Member_Name(Am_Object obj, Am_Slot_Key list_key, char* name);
Am_String Next_Name(Am_Object obj, Am_Slot_Key list_key, char* base);

/* Add and Remove utilities */
void Propagate_Add(Am_Object des, Am_Object src);
void Propagate_Remove(Am_Object obj);

Am_Object Proc_Get_Port(Am_Object process, char* name);
Am_Object Object_List_Get_By_Model_Key(Am_Value_List list, Am_Slot_Key key, Am_String s);
Am_Object ObjectListGetByModelKeyForm(Am_Value_List list, Am_Slot_Key key, Am_String s, Am_Constraint_Context& cc);

bool Is_Network(Am_Object obj);
Am_Object Parent_Rule(Am_Object obj);
Am_Object Parent_Rule_In_Form(Am_Constraint_Context& cc, Am_Object& obj);
Am_Object Top_Pattern(Am_Object obj);

void Disable_Name_Edit(Am_Object obj);
void Change_Menu(Am_Object obj, Am_Object popper);


// ------------------------------------------------------------
// Methods
// ------------------------------------------------------------

Am_Define_Method_Type(Copy_Method, Am_Object, (Am_Object));
Am_Define_Method_Type(Naming_Method, bool, (Am_Object, Am_String));

// ------------------------------------------------------------
// Formulas
// ------------------------------------------------------------

extern Am_Formula ContentsVisibleForm;
extern Am_Formula SelfVisibleForm;
extern Am_Formula ParentForm;
extern Am_Formula SelfForm;
extern Am_Formula PropagateForm;
extern Am_Formula NumberThresholdForm;
extern Am_Formula NameHeightForm;
extern Am_Formula NameHeightForm2;
extern Am_Formula PovlGroupHeightForm;
extern Am_Formula TargetNameForm;

extern Am_Formula ModelNameForm;
extern Am_Formula ContentsListForm;
extern Am_Constraint* InstanceListForm (Am_Object& proto);
extern Am_Constraint* NameListForm (Am_Slot_Key list_key);


extern Am_Formula SequenceLayoutForm;

// ------------------------------------------------------------
// Initialize
// ------------------------------------------------------------

void InitializeWidgets (void);
