// Copyright (C) 1997,1998  Toyoda Masashi (toyoda@is.titech.ac.jp)

#include <amulet.h>
#include <strstream.h>
#include <fstream.h>

#include "ToyWidgets.h"
#include "PovlWidgets.h"
#include "Resources.h"
#include "Rule.h"
#include "Process.h"
#include "Pattern.h"
#include "SaveLoad.h"
#include "Translator.h"
#include "Item.h"

// ------------------------------------------------------------
// Module Prototype
// ------------------------------------------------------------

Am_Object ModuleModel = 0;

Am_Object TopModule = 0;
Am_Object ModuleProto = 0;
Am_Object MainRuleProto = 0;

DEFINE_SLOT(SplitBarPart);

// Functions
// --------------------------------------------------

Am_Object Module_Find_Module(Am_String name)
{
  Am_Value_List module_list = TopModule.Get(ModuleList);
  Am_Object module = Object_List_Get_By_Model_Key(module_list, Name, name);

  if (module.Valid()) return module;
  return 0;
}

Am_Object Module_Find_Process(Am_Object module, Am_String name)
{
  Am_Value_List proc_list = module.Get(ProcessList);
  Am_Object process = Object_List_Get_By_Model_Key(proc_list, Name, name);

  if (process.Valid()) return process;
  return 0;
}

Am_Object ModuleFindModuleForm(Am_String name, Am_Constraint_Context& cc)
{
  Am_Value_List module_list = TopModule.GV(ModuleList);
  Am_Object module = ObjectListGetByModelKeyForm(module_list, Name, name, cc);

  if (module.Valid()) return module;
  return 0;
}

Am_Object ModuleFindProcessForm(Am_Object module, Am_String name, Am_Constraint_Context& cc)
{
  Am_Value_List proc_list = module.GV(ProcessList);
  Am_Object process = ObjectListGetByModelKeyForm(proc_list, Name, name, cc);

  if (process.Valid()) return process;
  return 0;
}

// Methods
// --------------------------------------------------

Am_Define_Method(Copy_Method, Am_Object, New_Module, (Am_Object /* module */))
{
  Am_Object new_model = ModuleModel.Create();
  Am_Object new_module = ModuleProto.Create()
    .Set(Model, new_model)
    .Set(Am_WIDTH, 400)
    .Set(Am_HEIGHT, 400)
    ;
  return new_module;
}

Am_Define_Method(Naming_Method, bool, Module_Rename, (Am_Object module, Am_String name))
{
  Am_Object root = module.Get(Parent);
  if (root.Valid()) {
    if (Member_Name(root, ModuleNameList, name)) return false;
  }
  module.MSet(Name, name);
  // $B%W%m%;%9$N%b%8%e!<%kL>$rA4$FJQ99(B
  // $BB>$N%b%8%e!<%k$d%Q%?!<%s$K%3%T!<$5$l$?$b$N$OL5;k(B
  Am_Value_List procs = module.Get(ProcessList);
  for (procs.Start(); !procs.Last(); procs.Next()) {
    Am_Object p = procs.Get();
    Process_Set_Module(p, module);
  }
  return true;
}

Am_Define_Method(Bin_Check_Method, bool, Module_Add, (Am_Object module, Am_Object obj))
{
  Am_Slot_Key list_key;
  Am_String base_name;

  // Rule $B$OL5>r7o$G(Badd$B$G$-$k(B
  if (obj.Is_Instance_Of(RuleProto)) {
    module.Get_Part(ContentsPart).Add_Part(obj);
    return true;
  }
  // Module, Process, Pattern$B$OL>A0$,=E$J$i$J$$$h$&$KJQ99$9$k!#(B
  if (obj.Is_Instance_Of(ModuleProto)) {
    base_name = obj.MGet(Name);
    list_key = ModuleNameList;
  }
  else if (obj.Is_Instance_Of(ProcessProto) || obj.Is_Instance_Of(PatternProto)) {
    base_name = obj.MGet(Name);
    list_key = ProcPatternNameList;
    Process_Set_Module(obj, module); // Module $B%9%m%C%H$N%;%C%H(B
  }
  else if (obj.Is_Instance_Of(ItemProto)) {
    module.Get_Part(ContentsPart).Add_Part(obj);
    return true;
  }
  else {
    cerr << "Can't add " << obj << " to " << module << endl;
    return false;
  }

  Am_String new_name = Next_Name(module, list_key, base_name);
  CALL2(obj, Naming_Method, NamingMethod, new_name);
  module.Get_Part(ContentsPart).Add_Part(obj);
  return true;
}

Am_Define_Method(Bin_Check_Method, bool, Module_Remove, (Am_Object module, Am_Object obj))
{
  // $B%W%m%;%9$N$H$-$O%k!<%k$*$h$S%b%8%e!<%kFb$N%4!<%k$rA4It>C$9!#(B
  if (obj.Is_Instance_Of(ProcessProto)) {
    if ((int)obj.Get(Type) != ProcessInterface) return false;

    Am_Value_List goals = obj.Get(ProcessList);
    for (goals.Start(); !goals.Last(); goals.Next()) {
      Am_Object g = goals.Get();
      CALL2(g.Get_Object(Parent), Bin_Check_Method, RemoveMethod, g);
    }

    Am_Value_List rules = obj.Get(RuleList);
    for (rules.Start(); !rules.Last(); rules.Next()) {
      Am_Object r = rules.Get();
      CALL2(r.Get_Object(Parent), Bin_Check_Method, RemoveMethod, r);
    }

    obj.Remove_From_Owner();
    return true;
  }

  module.Get_Part(ContentsPart).Remove_Part(obj);
  return true;
}

Am_Define_Method(Bin_Check_Method, bool, Module_Check_Drop, (Am_Object source, Am_Object target))
{
  //  if (source == target) return false;
  //  if (source.Get_Owner() == target.Get_Part(ContentsPart)) return false;
  //  if (target.Is_Part_Of(source)) return false;
  return true;
}

Am_Define_Method(Drop_Method, bool, Module_Drop,
		 (Am_Object source, Am_Object target, Am_Object /* cmd */))
{
  //  cout << "dropping " << source << " in " << source.Get_Owner() << " into " << target.Get_Part(ContentsPart) << endl;
  //  source.Get_Owner().Remove_Part(source);
  //  cout << "done remove" << endl;
  //  target.Get_Part(ContentsPart).Add_Part(source);
  //  cout << "done add" << endl;
  return true;
}

// Formulas
// --------
Am_Define_Value_List_Formula(PatternListForm)
{
  // $B%Q%?!<%s$NL>A06u4V$O$I$&$7$h$&$+$J!)(B
  // $B3,AX$r(Bflatten$B$7$?L>A0%j%9%H$G%f%K!<%/$K$9$k!#(B
}

Am_Define_Value_List_Formula(ProcPatternListForm) {
  Am_Value_List list = Am_Value_List();
  Am_Value_List procs = self.GV(ProcessList);
  Am_Value_List patts = self.GV(PatternList);
  list.Append(procs).Append(patts);
  return list;
}

void initModuleProto(void) {
  ModuleModel = Am_Root_Object.Create("ModuleModel")
    .Set(Name,	"module")
    ;

  Am_Object name = EditableZoomingText.Create("ModuleName")
    .Get_Part(TextPart).Set(Am_TEXT, ModelNameForm).Get_Owner()
    .Set(FontFamily, FontSerif)
    .Set(FontIsBold, true)
    .Set(NameHeightMax, GetResourceForm(NameHeightMax))
    .Set(Am_WIDTH, Am_From_Owner(Am_WIDTH))
    //    .Set(Am_HEIGHT, NameHeightForm2)
    .Set(Am_HEIGHT, NameHeightForm)
    ;
  
  //  Am_Object frame = Am_Border_Rectangle.Create("ModuleFrame")
  Am_Object frame = Am_Rectangle.Create("ModuleFrame")
    .Set(Am_WIDTH, Am_From_Owner(Am_WIDTH))
    .Set(Am_HEIGHT, Am_From_Owner(Am_HEIGHT))
    .Set(Am_THICKNESS, 1)
    .Set(Am_FILL_STYLE, GetResourceForm(ModuleFill))
    ;

  Am_Object splitBar = Am_Border_Rectangle.Create("ModuleSplitBar")
    .Set(Am_LEFT, 1)
    .Set(Am_TOP, Bellow_Of_Sibling(NamePart))
    .Set(Am_WIDTH, Am_From_Owner_Plus(Am_WIDTH, -2))
    .Set(Am_HEIGHT, 2)
    .Set(Am_THICKNESS, 2)
    .Set(Am_RAISED, false)
    .Set(Am_FILL_STYLE, GetResourceForm(ModuleFill))
    ;

  Am_Object titleBar = Am_Border_Rectangle.Create("ModuleTitleBar")
    .Set(Am_LEFT, 1)
    .Set(Am_TOP, 1)
    .Set(Am_WIDTH, Am_From_Owner_Plus(Am_WIDTH, -2))
    .Set(Am_HEIGHT, Am_From_Sibling_Plus(NamePart, Am_HEIGHT, -1))
    .Set(Am_THICKNESS, 2)
    .Set(Am_RAISED, true)
    .Set(Am_FILL_STYLE, GetResourceForm(ModuleFill))
    ;

  Am_Object contents = PovlContents.Create("ModuleContents")
    .Set(Am_TOP, Bellow_Of_Sibling(SplitBarPart))
    //    .Set(Am_TOP, 0)
    .Set(Am_WIDTH, Am_From_Owner(Am_WIDTH))
    //    .Set(Am_HEIGHT, Am_From_Owner(Am_HEIGHT))
    .Set(Am_HEIGHT, Fill_To_Bottom)
    .Set(maximumPercentage, 95)
    ;

  ModuleProto = PovlGroup.Create("ModuleProto")
    // Attributes
    .Set(Model, ModuleModel)
    .Set(Parent, ParentForm)
    // Methods
    .Set(NewMethod, New_Module)
    .Set(AddMethod, Module_Add)
    .Set(RemoveMethod, Module_Remove)
    .Set(CheckDropMethod, Module_Check_Drop)
    .Set(DropMethod, Module_Drop)
    .Set(NamingMethod, Module_Rename)
    // Lists
    .Set(ProcessList, InstanceListForm(ProcessProto))
    .Set(ProcessNameList, NameListForm(ProcessList))
    .Set(PatternList, InstanceListForm(PatternProto))
    .Set(PatternNameList, NameListForm(PatternList))
    .Set(ProcPatternList, ProcPatternListForm)
    .Set(ProcPatternNameList, NameListForm(ProcPatternList))
    .Set(RuleList, InstanceListForm(RuleProto))
    // Graphics
    .Set_Single_Constraint_Mode(Am_WIDTH, false)
    .Set_Single_Constraint_Mode(Am_HEIGHT, false)
    .Set(Am_WIDTH, 80)
    .Set(Am_HEIGHT, 29)
    .Set(Am_WIDTH, Am_From_Part(ContentsPart, Am_WIDTH))
    //    .Set(Am_HEIGHT, Am_From_Part(ContentsPart, Am_HEIGHT))
    .Set(Am_HEIGHT, PovlGroupHeightForm)

    .Add_Part(FramePart, frame)
    .Add_Part(SplitBarPart, titleBar)
    .Add_Part(NamePart, name)
    //    .Add_Part(SplitBarPart, splitBar)
    .Add_Part(ContentsPart, contents)
    ;

  TopModule = ModuleProto.Create("TopModuleProto")
    .Set(User, "")
    .Set(ModuleList, InstanceListForm(ModuleProto))
    .Set(ModuleNameList, NameListForm(ModuleList))
    .Get_Part(NamePart).Set(Am_VISIBLE, false).Get_Owner() // dirty!
    .Get_Part(SplitBarPart).Set(Am_VISIBLE, false).Get_Owner()
    .Get_Part(ContentsPart)
      .Set(propagateParent, 0)
    //      .Set(numberThreshold, 50)
      .Set(Am_TOP, 0)
      .Set(Am_HEIGHT, Am_From_Owner(Am_HEIGHT))
    .Get_Owner()
    ;

  MainRuleProto = CALL1(NetworkRuleProto, Copy_Method, NewMethod)
    .Set(Process, 0)
    .Set(Model, ProcessModel.Create()
	 .Set(Name, "main")
	 .Set(Module, ModuleProto))
    ;

  ModuleProto.Get_Part(ContentsPart)
    .Add_Part(MainRule, MainRuleProto)
    ;

}

// ------------------------------------------------------------
// Module Menu
// ------------------------------------------------------------

Am_Define_Method(Am_Object_Method, void, Execute_Do, (Am_Object command_obj))
{
  Am_Object menu = command_obj.Get_Owner().Get_Owner(); // $B%a%K%e!<(B
  Am_Object module = menu.Get(TargetObj); // $BDI2C@h(B
  Am_Object top_module = module.Get(Parent);

  Execute_Module(top_module, module);

}

Am_Define_Method(Am_Object_Method, void, Save_Do, (Am_Object command_obj))
{
  Am_Object menu = command_obj.Get_Owner().Get_Owner(); // $B%a%K%e!<(B
  Am_Object module = menu.Get(TargetObj); // $BDI2C@h(B

  Save_module(module);
}


void initModuleMenu(void)
{
  Am_Object ModuleMenu = PopUpMenu.Create("ModuleMenu")
    .Get_Part(MenuBody)
    .Set(Am_ITEMS, Am_Value_List()
	 .Add(MenuCommand.Create().Set(Am_LABEL, TargetNameForm))
	 .Add(Am_Menu_Line_Command.Create())
	 //	 .Add(UndoZoomCmd.Create())
	 //	 .Add(RedoZoomCmd.Create())
	 //	 .Add(SelectiveUndoZoomCmd.Create())
	 .Add(PovlOrigSizeCmd.Create())
	 .Add(PovlEditSizeCmd.Create())
	 .Add(Am_Menu_Line_Command.Create())
	 .Add(MenuCommand.Create().Set(Am_LABEL, "Execute")
	      .Set(Am_DO_METHOD, Execute_Do))
	 .Add(Am_Menu_Line_Command.Create())
	 .Add(NewObjectCmd.Create().Set(Am_LABEL, ProcessProto))
	 .Add(NewObjectCmd.Create().Set(Am_LABEL, PatternProto))	      
	 .Add(NewObjectCmd.Create().Set(Am_LABEL, ReplPatternProto))
	 .Add(MenuCommand.Create().Set(Am_LABEL, "Save Module")
	      .Set(Am_DO_METHOD, Save_Do))
	 .Add(RemoveObjectCmd.Create().Set(Am_LABEL, "Delete Module"))
	 )
    .Get_Owner();
  Am_Screen.Add_Part(ModuleMenu);

  Am_Object ModuleMenuPopper = PopUpMenuInteractor.Create("ModuleMenuPopper")
    .Set(MenuWindow, ModuleMenu);
  ModuleProto.Add_Part(ModuleMenuPopper);
}

// ------------------------------------------------------------
// Initialize
// ------------------------------------------------------------

void InitializeModule(void)
{
  initModuleProto();
  initModuleMenu();
}
