// Copyright (C) 1997,1998  Toyoda Masashi (toyoda@is.titech.ac.jp)

#include <amulet.h>
#include OBJECT_ADVANCED__H

#include "ToyWidgets.h"
#include "PovlWidgets.h"
#include "Resources.h"
#include "Guard.h"

// ------------------------------------------------------------
// Process Prototype
// ------------------------------------------------------------

// Global objects

Am_Object GuardModel = 0;
Am_Object GuardProto = 0;

Am_Define_Point_List_Formula(GuardPointListForm) {
  int width = self.GV(Am_WIDTH);
  int height = self.GV(Am_HEIGHT);
  int gap = height / 4;
  if (width < gap * 2) gap = width / 2;

  Am_Point_List hex;
  hex.Add(0,		height / 2);
  hex.Add(gap,		0	  );
  hex.Add(width - gap,	0	  );
  hex.Add(width - 1,	height / 2);
  hex.Add(width - gap,  height - 1);
  hex.Add(gap,		height - 1);
  hex.Add(0,		height / 2);
  
  return hex;
}

Am_Define_String_Formula(GuardNameForm)
{
  Am_Object model = self.GV_Owner().GV_Owner().GV(Model);
  if (model.Valid()) return model.GV(Name);
  else return (Am_String)"";
}

Am_Define_Method(Copy_Method, Am_Object, Copy_Guard, (Am_Object guard))
{
  Am_Object model = guard.Get(Model);
  Am_Object new_guard = guard.Create()
    .Set(Model, model.Copy());
  return new_guard;
}

Am_Define_Method(Naming_Method, bool, Guard_Rename, (Am_Object guard, Am_String name))
{
  //$B$[$s$H$O%Q!<%9$7$F%7%s%?%C%/%9%A%'%C%/$9$k$s$@$m$&$J!#(B
  return true;
}

void initGuard(void)
{
  GuardModel = Am_Root_Object.Create("GuardModel")
    .Set(Name, "true")
    ;

  Am_Object frame = Am_Polygon.Create("GuardFrame")
    .Set(Am_POINT_LIST, GuardPointListForm)
    .Set(Am_WIDTH, Am_From_Owner(Am_WIDTH))
    .Set(Am_HEIGHT, Am_From_Owner(Am_HEIGHT))
    .Set(Am_FILL_STYLE, GetResourceForm(GuardFill))
    ;

  Am_Object name = EditableZoomingText.Create("GuardContent")
    .Get_Part(TextPart).Set(Am_TEXT, GuardNameForm).Get_Owner()
    .Set(Am_WIDTH, Am_From_Owner(Am_WIDTH))
    .Set(Am_HEIGHT, Am_From_Owner(Am_HEIGHT))
    ;

  GuardProto = PovlGroup.Create("GuardProto")
    .Set(Model, GuardModel)
    .Set(Parent, ParentForm)
    .Set(Am_WIDTH, 60)
    .Set(Am_HEIGHT, 20)
    .Add_Part(FramePart, frame)
    .Add_Part(NamePart, name)

    .Set(NewMethod, Copy_Guard)
    .Set(NamingMethod, Guard_Rename)
    .Set(CheckDropMethod, 0)
    .Set(DropMethod, 0)
    ;
}

// ------------------------------------------------------------
// Guard Menu
// ------------------------------------------------------------

void initGuardMenu(void)
{
  Am_Object GuardMenu = PopUpMenu.Create("GuardMenu")
    .Get_Part(MenuBody)
    .Set(Am_ITEMS, Am_Value_List()
	 .Add(MenuCommand.Create().Set(Am_LABEL, "Guard"))
	 .Add(Am_Menu_Line_Command.Create())
	 .Add(RemoveObjectCmd.Create().Set(Am_LABEL, "Delete"))
	 )
    .Get_Owner();
  Am_Screen.Add_Part(GuardMenu);

  Am_Object GuardMenuPopper = PopUpMenuInteractor.Create("GuardMenuPopper")
    .Set(MenuWindow, GuardMenu)
    ;
  GuardProto.Add_Part(GuardMenuPopper);
}


void InitializeGuard(void)
{
  initGuard();
  initGuardMenu();
}
