// Copyright (C) 1997,1998  Toyoda Masashi (toyoda@is.titech.ac.jp)

#include <amulet.h>
#include FORMULA_ADVANCED__H

#include <math.h>

#define _INTERNAL_
#include "ToyWidgets.h"

// ------------------------------------------------------------
// Method Type Impls
// ------------------------------------------------------------
Am_Define_Method_Type(Drop_Method, bool, (Am_Object, Am_Object, Am_Object));
Am_Define_Method_Type(Bin_Check_Method, bool, (Am_Object, Am_Object));

Am_Define_Method_Type_Impl(Bin_Check_Method);
Am_Define_Method_Type_Impl(Drop_Method);

// ------------------------------------------------------------
// Object List Operations
// ------------------------------------------------------------

// Am_Value_List Index operations
int Object_List_Index(Am_Value_List list, Am_Object value)
{
  int i = 1;
  for (list.Start(); !list.Last(); list.Next(), ++i) {
    if ((Am_Object)list.Get() == value) return i;
  }
  return 0;
}

Am_Object Object_List_Get(Am_Value_List list, int i)
{
  int j = 1;
  for (list.Start(); !list.Last(); list.Next(), ++j) {
    if (i == j) return (Am_Object)list.Get();
  }
  return 0;
}

Am_Inter_Location Location_List_Get(Am_Value_List list, int i)
{
  int j = 0;
  for (list.Start(); !list.Last(); list.Next(), ++j) {
    if (i == j) return (Am_Inter_Location)list.Get();
  }
  return 0;
}

int Object_List_Max(Am_Value_List list, Am_Slot_Key key)
{
  int max = 0;
  for (list.Start(); !list.Last(); list.Next()) {
    Am_Object item = (Am_Object)list.Get();
    int value = item.Get(key);
    if (value > max) max = value;
  }
  return max;
}

int Group_Index(Am_Object obj)
{
  Am_Object owner = obj.Get_Owner();
  if (owner.Valid()) {
    Am_Value_List parts = (Am_Value_List)owner.Get(Am_GRAPHICAL_PARTS);
    return Object_List_Index(parts, obj);
  }
  return 0;
}

Am_Object Group_Get_By_Index(Am_Object group, int idx)
{
  if (!group.Valid()) return 0;
  Am_Value_List parts = (Am_Value_List)group.Get(Am_GRAPHICAL_PARTS);
  return Object_List_Get(parts, idx);
}

Am_Object Object_List_Get_By_Key(Am_Value_List list, Am_Slot_Key key, Am_String s)
{
  for (list.Start(); !list.Last(); list.Next()) {
    Am_Object item = (Am_Object)list.Get();
    if ((Am_String)item.Get(key) == s) {
      return item;
    }
  }
  return 0;
}  

int String_List_Index(Am_Value_List list, Am_String value)
{
  int i = 1;
  for (list.Start(); !list.Last(); list.Next(), ++i) {
    if (strcmp((Am_String)list.Get(), value) == 0) return i;
  }
  return 0;
}

void Value_List_Slot_Add(Am_Object parent, Am_Slot_Key list_slot, Am_Object obj)
{
  parent.Make_Unique(list_slot);
  Am_Value_List obj_list = parent.Get(list_slot);
  if (obj_list.Empty()) {
    parent.Set(list_slot, obj_list.Add(obj));
  } else {
    obj_list.Add(obj, Am_TAIL, false);
    parent.Note_Changed(list_slot);
  }
}

void Value_List_Slot_Remove(Am_Object parent, Am_Slot_Key list_slot, Am_Object obj)
{
  parent.Make_Unique(list_slot);
  Am_Value_List obj_list = parent.Get(list_slot);
  obj_list.Start();
  obj_list.Member(obj);
  if (!obj_list.Last()) {
    obj_list.Delete(false);
    parent.Note_Changed(list_slot);
  }
}

// ------------------------------------------------------------
// Find Instance of
// ------------------------------------------------------------
Am_Object Find_Instance_Of(Am_Object group, int x, int y, Am_Object ref, Am_Object proto)
{
  Am_Object found = Am_No_Object;
  for (;;) {
    //cout << group;
    Am_Object part = Am_Point_In_Part (group, x, y, ref, false, true);
    if (!part.Valid()) return found;
    //    cout << part << endl;
    if (part.Is_Instance_Of(proto)) found = part;
    group = part;
  }
}


// ------------------------------------------------------------
// Center of Object
// ------------------------------------------------------------
int CenterX(Am_Object obj)
{
  return (int)obj.Get(Am_LEFT) + (int)obj.Get(Am_WIDTH) / 2;
}

int CenterY(Am_Object obj)
{
  return (int)obj.Get(Am_TOP) + (int)obj.Get(Am_HEIGHT) / 2;
}

void Center_Of_Object(Am_Object obj, int& cx, int& cy)
{
  int x = obj.Get(Am_LEFT);
  int y = obj.Get(Am_TOP);
  int width = obj.Get(Am_WIDTH);
  int height = obj.Get(Am_HEIGHT);

  cx = x + width  / 2;
  cy = y + height / 2;
}

void Left_Top_Of_Object_By_Center(Am_Object obj, int cx, int cy, int& left, int& top)
{
  int width = obj.Get(Am_WIDTH);
  int height = obj.Get(Am_HEIGHT);

  left = cx - width  / 2;
  top = cy - height / 2;
}

Am_Define_Formula(int, CenterXForm)
{
  return (int)self.GV(Am_LEFT) + (int)self.GV(Am_WIDTH) / 2;
}

Am_Define_Formula(int, CenterYForm)
{
  return (int)self.GV(Am_TOP) + (int)self.GV(Am_HEIGHT) / 2;
}

// ------------------------------------------------------------
// Distance_Of_Objects
// ------------------------------------------------------------
int Distance_Of_Objects(Am_Object obj1, Am_Object obj2)
{
  int x1 = obj1.Get(Am_LEFT);
  int y1 = obj1.Get(Am_TOP);
  int x2 = obj2.Get(Am_LEFT);
  int y2 = obj2.Get(Am_TOP);
  int dx = x2 - x1;
  int dy = y2 - y1;
  return (int)floor(sqrt(dx * dx + dy * dy));
}  

// ------------------------------------------------------------
// Am_From_Sibling_Plus, Am_From_Owner_Plus
// ------------------------------------------------------------
typedef struct {
  Am_Slot_Key part;
  Am_Slot_Key key;
  int diff;
} Part_Key_Store;

void release_part_key_store (void* data)
{
  Part_Key_Store* store = (Part_Key_Store*)data;
  delete store;
}

static void from_sibling_plus_procedure (Am_Constraint_Context& cc, Am_Object& self, Am_Value& value) {
  Part_Key_Store* store = (Part_Key_Store*)cc.Get_Data ();
  Am_Object part = self.GV_Sibling (store->part);
  if (part) {
    value = (int)part.GV(store->key) + store->diff;
  } else {
    value = 0;
  }
}

Am_Constraint* Am_From_Sibling_Plus (Am_Slot_Key part, Am_Slot_Key key, int diff)
{
  Part_Key_Store* store = new (Part_Key_Store);
  store->part = part;
  store->key = key;
  store->diff = diff;
  Am_Formula_Advanced* formula = (Am_Formula_Advanced*)(Am_Constraint*)
      Am_Formula (from_sibling_plus_procedure, "Am_From_Sibling_Plus");
  formula->Set_Data (store, release_part_key_store);
  return formula;
}

static void from_owner_plus_procedure (Am_Constraint_Context& cc, Am_Object& self, Am_Value& value) {
  Part_Key_Store* store = (Part_Key_Store*)cc.Get_Data ();
  Am_Object owner = self.GV_Owner();
  if (owner) {
    value = (int)owner.GV(store->key) + store->diff;
  } else {
    value = 0;
  }
}

Am_Constraint* Am_From_Owner_Plus (Am_Slot_Key key, int diff)
{
  Part_Key_Store* store = new (Part_Key_Store);
  store->key = key;
  store->diff = diff;
  Am_Formula_Advanced* formula = (Am_Formula_Advanced*)(Am_Constraint*)
      Am_Formula (from_owner_plus_procedure, "Am_From_Owner_Plus");
  formula->Set_Data (store, release_part_key_store);
  return formula;
}

// ------------------------------------------------------------
// Am_From_Object
// ------------------------------------------------------------
typedef struct {
  Am_Object* object;
  Am_Slot_Key key;
} Object_Key_Store;

void release_object_key_store(void* data)
{
  Object_Key_Store* store = (Object_Key_Store*)data;
  delete store;
}

static void from_object_procedure(Am_Constraint_Context& cc, Am_Object& self, Am_Value& value) {
  Object_Key_Store* store = (Object_Key_Store*)cc.Get_Data ();
  Am_Object* object = store->object;
  if (*object) {
    object->GVM (store->key, value);
  }
}

Am_Constraint* Am_From_Object(Am_Object& object, Am_Slot_Key key)
{
  Object_Key_Store* store = new (Object_Key_Store);
  store->object = &object;
  store->key = key;
  Am_Formula_Advanced* formula = (Am_Formula_Advanced*)(Am_Constraint*)
      Am_Formula (from_object_procedure, "Am_From_Object");
  formula->Set_Data (store, release_object_key_store);
  return formula;
}

// ------------------------------------------------------------
// Bellow_Of_Sibling, Right_Of_Sibling
// ------------------------------------------------------------

static void bellow_of_sibling_procedure(Am_Constraint_Context& cc, Am_Object& self, Am_Value& value)
{
  Am_Slot_Key sibling_key = (Am_Slot_Key)cc.Get_Data ();
  Am_Object sibling = self.GV_Sibling(sibling_key);
  
  value = (int)sibling.GV(Am_TOP) + (int)sibling.GV(Am_HEIGHT);
}

Am_Constraint* Bellow_Of_Sibling(Am_Slot_Key key)
{
  Am_Formula_Advanced* formula = (Am_Formula_Advanced*)(Am_Constraint*)
      Am_Formula (bellow_of_sibling_procedure, "Bellow_Of_Sibling");
  formula->Set_Data ((void*)key, NULL);
  return formula;
}

static void right_of_sibling_procedure(Am_Constraint_Context& cc, Am_Object& self, Am_Value& value)
{
  Am_Slot_Key sibling_key = (Am_Slot_Key)cc.Get_Data ();
  Am_Object sibling = self.GV_Sibling(sibling_key);
  
  value = (int)sibling.GV(Am_LEFT) + (int)sibling.GV(Am_WIDTH);
}

Am_Constraint* Right_Of_Sibling(Am_Slot_Key key)
{
  Am_Formula_Advanced* formula = (Am_Formula_Advanced*)(Am_Constraint*)
      Am_Formula (right_of_sibling_procedure, "Right_Of_Sibling");
  formula->Set_Data ((void*)key, NULL);
  return formula;
}

// ------------------------------------------------------------
// Bellow_Of_Sibling, Right_Of_Sibling
// ------------------------------------------------------------
Am_Define_Formula (int, Fill_To_Bottom) {
  Am_Object owner = self.GV_Owner();
  if (!owner.Valid()) return 0;
  return (int)(owner.GV(Am_HEIGHT)) - (int)(self.GV(Am_TOP)) 
    - (int)(self.GV(Am_Y_OFFSET));
}

