// Copyright (C) 1997,1998  Toyoda Masashi (toyoda@is.titech.ac.jp)

#include <amulet.h>
#include <math.h>

#define _INTERNAL_
#include "ToyWidgets.h"

DEFINE_SLOT(Am_ARROW_H_WIDTH);
DEFINE_SLOT(Am_ARROW_H_HEIGHT);
DEFINE_SLOT(Am_ARROW_WIDTH);

Am_Define_Point_List_Formula(ArrowPointListForm)
{
  int x1 = self.GV(Am_X1);
  int y1 = self.GV(Am_Y1);
  int x2 = self.GV(Am_X2);
  int y2 = self.GV(Am_Y2);
  int dx = x2 - x1;
  int dy = y2 - y1;
  int al = self.GV(Am_ARROW_H_HEIGHT);
  int aw = (int)self.GV(Am_ARROW_H_WIDTH) / 2;
  double dl = sqrt(dx * dx + dy * dy);
  double sin_d = 0;
  double cos_d = 0;
  if (dl != 0) {
    sin_d = dy / dl;
    cos_d = dx / dl;
  }
  if (dl < al * 2) {
    al = (int)dl / 2;
  }
  int arx = (int)floor(x2 - al * cos_d);
  int ary = (int)floor(y2 - al * sin_d);
  int ax1 = (int)floor(arx - aw * sin_d);
  int ay1 = (int)floor(ary + aw * cos_d);
  int ax2 = (int)floor(arx + aw * sin_d);
  int ay2 = (int)floor(ary - aw * cos_d);

  Am_Point_List pts = Am_Point_List();
  pts.Add(x1,  y1);
  pts.Add(arx, ary);
  pts.Add(ax1, ay1);
  pts.Add(x2,  y2);
  pts.Add(ax2, ay2);
  pts.Add(arx, ary);
  return pts;
}

Am_Define_Point_List_Formula(ArrowPointListWithVariableWidthForm)
{
  int x1 = self.GV(Am_X1);
  int y1 = self.GV(Am_Y1);
  int x2 = self.GV(Am_X2);
  int y2 = self.GV(Am_Y2);
  int hw = self.GV(Am_ARROW_H_WIDTH);
  int hh = self.GV(Am_ARROW_H_HEIGHT);
  int aw = self.GV(Am_ARROW_WIDTH);

  int dx = x2 - x1;
  int dy = y2 - y1;
  float dl = sqrt(dx * dx + dy * dy);
  float sin_d = 0;
  float cos_d = 0;
  if (dl != 0) {
    sin_d = dy / dl;
    cos_d = dx / dl;
  }

  if (dl < hh * 2) {
    hh = (int)dl / 2;
    aw = hw / 3;
  }

  float ax1 = sin_d*aw/2;
  float ay1 = cos_d*aw/2;
  float ax2 = cos_d*(dl-hh);
  float ay2 = sin_d*(dl-hh);
  float ax3 = sin_d*(hw-aw)/2;
  float ay3 = cos_d*(hw-aw)/2;

  Am_Point_List pl;
  pl.Add(x2,             y2);
  pl.Add(x1-ax1+ax2-ax3, y1+ay1+ay2+ay3);
  pl.Add(x1-ax1+ax2    , y1+ay1+ay2);
  pl.Add(x1-ax1        , y1+ay1);
  pl.Add(x1+ax1        , y1-ay1);
  pl.Add(x1+ax1+ax2    , y1-ay1+ay2);
  pl.Add(x1+ax1+ax2+ax3, y1-ay1+ay2-ay3);
  pl.Add(x2,             y2);

  return pl;
}

void Initialize_Arrow()
{
  Am_Arrow = Am_Polygon.Create("ARROW")
    .Set(Am_AS_LINE, true)
    .Set(Am_X1, 0)
    .Set(Am_Y1, 0)
    .Set(Am_X2, 10)
    .Set(Am_Y2, 10)
    .Set(Am_ARROW_H_WIDTH, 10)
    .Set(Am_ARROW_H_HEIGHT, 10)
    .Set(Am_ARROW_WIDTH, 3)
    .Set(Am_POINT_LIST, ArrowPointListForm)
    .Set(Am_LINE_STYLE, Am_Black)
    .Set(Am_FILL_STYLE, Am_Purple)
    ;
}

// eof
