go:-
        animal(Cat1),
        animal(Cat2),
        animal(Dog1),
        animal(Dog2),
        animal(Dog3),
	notSamePosition([Cat1,Cat2]),
	notSamePosition([Dog1,Dog2,Dog3]),
        notAttack([Cat1,Cat2],[Dog1,Dog2,Dog3]),
        labelingAnimals([Cat1,Cat2,Dog1,Dog2,Dog3]),
	write([Cat1,Cat2,Dog1,Dog2,Dog3]),nl.

labelingAnimals([]).
labelingAnimals([animal(Row,Col)|Animals]):-
	indomain(Row),
	indomain(Col),
	labelingAnimals(Animals).

animal(animal(Row,Column)):-
	Row in 0..4,
	Column in 0..4.

notSamePosition([]).
notSamePosition([Ani|Animals]):-
	notSamePosition(Ani,Animals),
	notSamePosition(Animals).

notSamePosition(animal(Row1,Col1),[animal(Row2,Col2)|Animals]):-
	(Row1#\=Row2 #\/ Col1#\=Col2),
	notSamePosition(animal(Row1,Col1),Animals).
notSamePosition(_,[]).

notAttack([],Dogs).
notAttack([Cat|Cats],Dogs):-
	notAttack1(Cat,Dogs),
	notAttack(Cats,Dogs).

notAttack1(Cat,[]).
notAttack1(Cat,[Dog|Dogs]):-
	notAttack2(Cat,Dog),
	notAttack1(Cat,Dogs).

notAttack2(animal(Row1,Col1),animal(Row2,Col2)):-
	Row1 #\= Row2,
	Col1 #\= Col2,
	Row1+Col1 #\= Row2+Col2,
	Row1-Col1 #\= Row2-Col2.


	