//  Copyright (C) 1999 Takeo Igarashi

import java.awt.*;
import java.lang.*;


/** 􉽊wIvZɎgp QxNg */
public class Vector2 {
	
	// 2D vecoter
	// double x,y
	// vector2(Point, Point)
	// double inner_product(Vector2)
	// double get_cos(Vector2)
	// double distance(x1,y1,x2,y2)
	

	public double x;
	public double y;
	

	Vector2(Node start, Node end){
		x = end.x -  start.x;
		y = end.y -  start.y;
	}
	Vector2(){
	}
	Vector2(double _x, double _y){
		x = _x;
		y = _y;
	}

	public Vector2 flip_y_axis(){
	    return new Vector2(-x, y);
	}
	// ͕ςȂB
	public Vector2 rotate(double degree){
	    if (degree == 90)
		return new Vector2(-y, x);
	    else if (degree == 180)
		return new Vector2(-x, -y);
	    else if (degree == 270)
		return new Vector2(y, -x);

	    
	    double radian = degree * Math.PI / 180.0;
	    double cos = Math.cos(radian);
	    double sin = Math.sin(radian);

	    return  new Vector2(x * cos - y * sin,
				x * sin + y * cos );
	}
	// ͕ςȂB
	public Vector2 normalize(){
	    double length = length();
	    if (length == 0) length = 1;
	    return new Vector2(x / length, y / length);
	}
	// gkB͕ςȂB
	public Vector2 scale(double scale){
	    return new Vector2(x * scale, y *scale);
	}


	public double length(){
	  return Math.sqrt(x*x + y*y);
	}

	public double inner_product(Vector2 v){
		return x * v.x + y * v.y;
	}
	public double outer_product(Vector2 v){
		return x * v.y - y * v.x;
	}

	public double get_cos(Vector2 v){
	  double length = 
	    Math.sqrt( (x*x + y*y)*(v.x*v.x + v.y*v.y) );
	  if (length >0)
	    return inner_product(v) / length;
	  else
	    return 0;
	}

	public double get_sin(Vector2 v){
	  double length = 
	    Math.sqrt( (x*x + y*y)*(v.x*v.x + v.y*v.y) );
	  if (length >0)
	    return outer_product(v) / length;
	  else
	    return 0;
	}  

	public static double distance(int x1, int y1, int x2, int y2){
	  return Math.sqrt((x2-x1)*(x2-x1)+(y2-y1)*(y2-y1));
	}
	public static double distance(double x1, double y1, double x2, double y2){
	  return Math.sqrt((x2-x1)*(x2-x1)+(y2-y1)*(y2-y1));
	}

}
