//  Copyright (C) 1999 Takeo Igarashi

import java.awt.*;
import java.lang.*;
import java.io.*;



public class Segment implements Serializable{

	//	segment in the scene
	// 	double x1,y1,x2,y2
	// 	Segment(int,int,int,int)
	// 	Segment(Point, Point)
	//	Point start_node()
	//	Point end_node()
	//	static double	get_distance(Point, Point)
	//	double	distance(Point)	

	public double x1; 
	public double y1;
	public double x2; 
	public double y2;

	Segment(double _x1, double _y1, double _x2, double _y2){
		x1 = _x1;
		y1 = _y1;		
		x2 = _x2;		
		y2 = _y2;
	}


	Segment(Node start, Node end){
		x1 = start.x;
		y1 = start.y;
		x2 = end.x;
		y2 = end.y;
	}
	public void configure(Node start, Node end){
		x1 = start.x;
		y1 = start.y;
		x2 = end.x;
		y2 = end.y;
	}
	
	public double coords(int i){
	    switch(i){
		case 0:
		    return x1;
		case 1:
		    return y1;
		case 2:
		    return x2;
		case 3:
		    return y2;
	    }
	    return 0;
	}

	public double length(){
	    return Vector2.distance(x1,y1,x2,y2);
	}

	public Vector2 vector(){
	    return new Vector2(x2-x1, y2-y1);
	}
	public Node start_node(){
		return new Node(x1, y1);
	}
	public Node end_node(){
		return new Node(x2, y2);
	}

	/** normal  x Ƃ钼sWցAWϊsB ͕ω */
	public Segment coord_system(Vector2 normal){
	    double _x1 =   x1 * normal.x + y1 * normal.y;
	    double _y1 = - x1 * normal.y + y1 * normal.x;
	    double _x2 =   x2 * normal.x + y2 * normal.y;
	    double _y2 = - x2 * normal.y + y2 * normal.x;
	    return new Segment(_x1, _y1, _x2, _y2);
	}	



	public static double get_distance(Node p, Node q){
		return Math.sqrt((p.x - q.x)*(p.x - q.x) 
			  + (p.y - q.y)*(p.y - q.y));
	}

	/** ƂčlB */
	public double distance (Node node){
  
	  	Node start = start_node();
		Node end = end_node();

		Vector2 vec0 = new Vector2(start, end);
		Vector2 vec1 = new Vector2(start, node);
		if (vec0.inner_product(vec1) < 0){
		    return get_distance(node, start);
		};
		vec1 = new Vector2(end, node);
		if (vec0.inner_product(vec1) > 0){
		    return get_distance(node, end);
		};
		
		return distance_line(node);
	
	}

	/** ƂčlB */
	public double distance_line (Node node){

  	  double a = x2 - x1;
	  double b = y2 - y1;

	  double bunbo = Math.sqrt(a * a + b * b);
	  double bunshi = a * (node.y - y1) - b * (node.x - x1);

	  if ( bunbo == 0 ) {
		System.out.println("Error in Segment.distance_line");
	       return 0;}
	  else {
	       return Math.abs(bunshi / bunbo);
	  }

	}


	// ƂČ_邩B
	public boolean cross(Segment s){

	  // a * x + b * y + c = 0
	  double a0, b0, c0,
        	 a1, b1, c1; 

	  a0 = y1 - y2; 
	  b0 = x2 - x1;
	  c0 = y2 * x1 - x2 * y1;

	  a1 = s.y1 - s.y2; 
	  b1 = s.x2 - s.x1;
	  c1 = s.y2 * s.x1 - s.x2 * s.y1;

	  if (((a0*s.x1+b0*s.y1+c0)*(a0*s.x2+b0*s.y2+c0)<= Def.ERROR_RANGE) &&
	      ((a1*  x1+b1*  y1+c1)*(a1*  x2+b1*  y2+c1)<= Def.ERROR_RANGE))
		return true;
	  else
		return false;
	}

	// ƂČ_Ƃ߂B
	public Node cross_node(Segment s){
  	    double  a0, b0, c0,
		    a1, b1, c1; 
	
	    a0 = y1 - y2;
	    b0 = x2 - x1;
	    c0 = y2 * x1 - x2 * y1;

	    a1 = s.y1 - s.y2;
	    b1 = s.x2 - s.x1;
	    c1 = s.y2 * s.x1 - s.x2 * s.y1;

	    if (Math.abs(a0 * b1 - a1 * b0) < Def.ERROR_RANGE){
		// _ŌqĂ镽sB
		System.out.println("Error in Segment.cross_node().");
		return null;
	    }
	  
	    double x = ((b0 * c1 - b1 * c0)/(a0 * b1 - a1 * b0)) ;
	    double y = ((a0 * c1 - a1 * c0)/(a1 * b0 - a0 * b1));
	    return new Node(x,y);
	}





	//sǂ̃`FbN
	public boolean parallel(Segment segment){
	    Vector2 vector1 = vector();
	    Vector2 vector2 = segment.vector();

	    double sin = vector1.get_sin(vector2);
	    return (Math.abs(sin) < Def.ERROR_RANGE);

	}
	// interval Ƃēo^邩̃`FbNB
	// 		dȂ肪Kv, Ȃ -1
	//sꍇɊԊuAԂ
	// 		sԊu̕\Ɏg
	public double parallel_interval(Segment segment){
	    Vector2 normal_vector_x = vector().normalize();
	    Segment segment1 = coord_system(normal_vector_x);
	    Segment segment2 = segment.coord_system(normal_vector_x);
	    // dȂ`FbN
	    if ((((segment1.x1 - segment2.x2)*(segment1.x2 - segment2.x1))<0)||
		(((segment1.x1 - segment2.x2)*(segment1.x2 - segment2.x2))<0)||
		(((segment2.x1 - segment1.x1)*(segment2.x2 - segment1.x1))<0)) {
		double interval = segment2.y1 - segment1.y1;
	    	return Math.abs(interval);
	    }
	    // dȂȂ
	    return -1;
	}


	/** ꒼ォǂ̃`FbN rearrange łB*/
	public boolean same_line(Segment segment){
	    return (online(segment.start_node()) && 
		    online(segment.end_node()));
	}

	/** node  ォ ̃`FbNB */
	public boolean online(Node node){
	    return (distance_line(node) < Def.ERROR_RANGE);
	}

	/** n_ƏI_̊Ԃ`FbNB꒼ォ̃`FbN͂ȂB*/
	public boolean between(Node node){
	    if (Def.equal(y1, y2))
		return (  (node.x >= Math.min(x1, x2) - Def.ERROR_RANGE )
			&&(node.x <= Math.max(x1, x2) + Def.ERROR_RANGE ));
	    else
		return (  (node.y >= Math.min(y1, y2) - Def.ERROR_RANGE )
			&&(node.y <= Math.max(y1, y2) + Def.ERROR_RANGE ));
	}

	public boolean same(Segment s){
	   return (    (start_node().same(s.start_node()) && 
			end_node().same(s.end_node()) )
	    	   ||  (start_node().same(s.end_node()) && 
			end_node().same(s.start_node()) ));
	}
	
}





